/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastDetailRepository;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastDetailSdkService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastDetailVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubComBudgetForecastDetailSdkServiceImpl
implements SubComBudgetForecastDetailSdkService {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastDetailSdkServiceImpl.class);
    @Autowired(required=false)
    private SubComBudgetForecastDetailRepository subComBudgetForecastDetailRepository;

    public void writeBackProcessNo(String processNo, List<String> detailCodes) {
        if (StringUtils.isBlank((CharSequence)processNo) || CollectionUtils.isEmpty(detailCodes)) {
            return;
        }
        List<SubComBudgetForecastDetailEntity> list = this.subComBudgetForecastDetailRepository.writeBackProcessNo(detailCodes);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (SubComBudgetForecastDetailEntity entity : list) {
            entity.setProcessNo(processNo);
        }
        this.subComBudgetForecastDetailRepository.updateBatchById(list);
    }

    public List<SubComBudgetForecastDetailVo> findAmountDetailByBudgetForecastCode(String budgetForecastCode) {
        if (StringUtils.isBlank((CharSequence)budgetForecastCode)) {
            return Lists.newArrayList();
        }
        List<SubComBudgetForecastDetailVo> list = this.subComBudgetForecastDetailRepository.findAmountDetailByBudgetForecastCode(budgetForecastCode);
        if (!CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

