/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastLockService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComBudgetForecastLockServiceImpl
implements SubComBudgetForecastLockService {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastLockServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public boolean lock(String budgetForecastCode, TimeUnit timeUnit, int time) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            throw new RuntimeException("\u9884\u7b97\u9884\u6d4b\u52a0\u9501\u5931\u8d25\uff0c\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)((Object)timeUnit))) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (time <= 0) {
            time = 1200;
        }
        return this.redisLockService.tryLock("sub_com_budget_forecast:lock:" + budgetForecastCode, timeUnit, (long)time);
    }

    public boolean lock(List<String> budgetForecastCodeList, TimeUnit timeUnit, int time) {
        return this.lock(budgetForecastCodeList, timeUnit, time, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(List<String> budgetForecastCodeList, TimeUnit timeUnit, int lockTime, int waiteTime) {
        if (CollectionUtils.isEmpty(budgetForecastCodeList)) {
            throw new RuntimeException("\u9884\u7b97\u9884\u6d4b\u52a0\u9501\u5931\u8d25\uff0c\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)((Object)timeUnit))) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (lockTime <= 0) {
            lockTime = 1200;
        }
        if (waiteTime <= 0) {
            waiteTime = 3;
        }
        boolean isLock = true;
        ArrayList<String> successKeys = new ArrayList<String>();
        try {
            for (String budgetForecastCode : budgetForecastCodeList) {
                isLock = this.redisLockService.tryLock("sub_com_budget_forecast:lock:" + budgetForecastCode, timeUnit, (long)lockTime, (long)waiteTime);
                if (!isLock) {
                    boolean bl = false;
                    return bl;
                }
                successKeys.add(budgetForecastCode);
            }
        }
        finally {
            if (!isLock && !CollectionUtils.isEmpty(successKeys)) {
                successKeys.forEach(key -> this.redisLockService.unlock("sub_com_budget_forecast:lock:" + key));
            }
        }
        return true;
    }

    public void unLock(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            throw new RuntimeException("\u9884\u7b97\u9884\u6d4b\u89e3\u9501\u5931\u8d25\uff0c\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.redisLockService.unlock("sub_com_budget_forecast:lock:" + budgetForecastCode);
    }

    public void unLock(List<String> budgetForecastCodeList) {
        if (CollectionUtils.isEmpty(budgetForecastCodeList)) {
            throw new RuntimeException("\u9884\u7b97\u9884\u6d4b\u89e3\u9501\u5931\u8d25\uff0c\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        budgetForecastCodeList.forEach(budgetForecastCode -> this.redisLockService.unlock("sub_com_budget_forecast:lock:" + budgetForecastCode));
    }
}

