/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastRepository;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComBudgetForecastOtherService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.ProfitGoalDiscountEventDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.event.ProfitGoalDiscountEventListener;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.ProfitGoalDiscountResponse;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.DataSourceEnum;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComBudgetForecastOtherServiceImpl
implements SubComBudgetForecastOtherService {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastOtherServiceImpl.class);
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private SubComBudgetForecastRepository subComBudgetForecastRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public void updateOneselfCastData(String yearMonth) {
        if (StringUtils.isEmpty((CharSequence)yearMonth)) {
            return;
        }
        if (this.redisMutexService.islock("sub_com_budget_forecast:lock:oneself_cast:" + yearMonth)) {
            throw new RuntimeException("\u66f4\u65b0\u81ea\u6295\u8d39\u7528\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        boolean flag = false;
        try {
            flag = this.redisMutexService.tryLock("sub_com_budget_forecast:lock:oneself_cast:" + yearMonth, TimeUnit.SECONDS, 20);
            log.info("\u66f4\u65b0\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u81ea\u6295\u8d39\u7528\u52a0\u9501\u6210\u529f");
            this.reCalOneselfCastData(yearMonth);
        }
        finally {
            if (flag) {
                this.redisMutexService.unlock("sub_com_budget_forecast:lock:oneself_cast:" + yearMonth);
            }
        }
    }

    public void reCalOneselfCastData(String yearMonth) {
        List<SubComBudgetForecastEntity> forecastEntities = this.subComBudgetForecastRepository.listByConditions(yearMonth, FeeSourceEnum.AUTO_FEE.getCode());
        if (CollectionUtils.isEmpty(forecastEntities)) {
            return;
        }
        if (CollectionUtils.isEmpty(forecastEntities = forecastEntities.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getBusinessFormatCode()) && StringUtils.isNotBlank((CharSequence)o.getDataSourceCode()) && BusinessFormatEnum.NORMAL.getCode().equals(o.getBusinessFormatCode()) && DataSourceEnum.AUTO.getCode().equals(o.getDataSourceCode())).collect(Collectors.toList()))) {
            return;
        }
        List forecastCodes = forecastEntities.stream().map(SubComBudgetForecastEntity::getBudgetForecastCode).collect(Collectors.toList());
        ProfitGoalDiscountEventDto eventDto = new ProfitGoalDiscountEventDto();
        eventDto.setBudgetForecastCodes(forecastCodes);
        SerializableBiConsumer & Serializable getProfitGoalDiscountMap = ProfitGoalDiscountEventListener::getProfitGoalDiscountMap;
        EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, ProfitGoalDiscountEventListener.class, (SerializableBiConsumer)getProfitGoalDiscountMap);
        Map map = new HashMap();
        if (!Objects.isNull(eventResponse)) {
            ProfitGoalDiscountResponse discountResponse = (ProfitGoalDiscountResponse)eventResponse;
            map = discountResponse.getDtoMap();
        }
        if (map.isEmpty()) {
            return;
        }
        for (SubComBudgetForecastEntity forecastEntity : forecastEntities) {
            if (!map.containsKey(forecastEntity.getBudgetForecastCode())) continue;
            List dtoList = (List)map.get(forecastEntity.getBudgetForecastCode());
            this.subComBudgetForecastService.updateByConfigBatch(dtoList);
        }
    }
}

