/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComActivityPlanItemAmountEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComAutoDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComInternalDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComOffDetailPlanEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComOffPlanEntity;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.SubComBudgetForecastMapper;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComActivityPlanItemAmountRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComAutoDetailRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastDetailRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComInternalDetailRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComOffDetailPlanRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComOffPlanRepository;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComBudgetForecastDetailService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComAutoDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetApprovalDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastAdjustDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastLogEventDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastOperateDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.AutoDetailAmountTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.UndertakeTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.event.SubComBudgetForecastLogEventListener;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComAutoDetailVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastAdjustVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastChangeVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastMainAdjustVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastProcessVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.dto.ProfitGoalDiscountDto;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.BudgetAmountTypeEnum;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.ConfirmEunm;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.dto.TpmSubsidiaryYearBudgetDto;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.enumeration.TpmSubsidiaryYearBudgetDetailTypeEnum;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.service.TpmSubsidiaryYearBudgetService;
import com.biz.crm.tpm.business.subsidiary.year.budget.sdk.vo.TpmSubsidiaryYearBudgetMonthDetailVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SubComBudgetForecastServiceImpl
implements SubComBudgetForecastService {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastServiceImpl.class);
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private SubComBudgetForecastMapper subComBudgetForecastMapper;
    @Autowired(required=false)
    private SubComAutoDetailRepository subComAutoDetailRepository;
    @Autowired(required=false)
    private SubComInternalDetailRepository subComInternalDetailRepository;
    @Autowired(required=false)
    private SubComOffDetailPlanRepository subComOffDetailPlanRepository;
    @Autowired(required=false)
    private SubComBudgetForecastRepository subComBudgetForecastRepository;
    @Autowired(required=false)
    private SubComBudgetForecastDetailService subComBudgetForecastDetailService;
    @Autowired(required=false)
    private SubComBudgetForecastDetailRepository subComBudgetForecastDetailRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SubComOffPlanRepository subComOffPlanRepository;
    @Autowired(required=false)
    private SubComActivityPlanItemAmountRepository subComActivityPlanItemAmountRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private TpmSubsidiaryYearBudgetService tpmSubsidiaryYearBudgetService;

    public Page<SubComBudgetForecastVo> findByConditions(Pageable pageable, SubComBudgetForecastDto dto) {
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SubComBudgetForecastDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComBudgetForecastMapper.findByConditions((Page<SubComBudgetForecastVo>)page, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateByConfigBatch(List<ProfitGoalDiscountDto> profitGoalDiscountDtoList) {
        ProfitGoalDiscountDto profitGoalDiscountDto = profitGoalDiscountDtoList.get(0);
        SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.getByCode(profitGoalDiscountDto.getBudgetForecastCode());
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)subComBudgetForecastEntity))) {
            return;
        }
        SubComBudgetForecastDto oldDto = (SubComBudgetForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        SubComAutoDetailDto subComAutoDetailDto = new SubComAutoDetailDto();
        this.buildSubComBudgetForecast(profitGoalDiscountDtoList, subComBudgetForecastEntity, subComAutoDetailDto);
        this.buildAutoDetail(subComBudgetForecastEntity, subComAutoDetailDto, profitGoalDiscountDtoList);
        this.buildInitDetail(oldDto, subComBudgetForecastEntity);
        this.subComBudgetForecastRepository.saveOrUpdate((Object)subComBudgetForecastEntity);
    }

    public String saveByConfigBatch(List<ProfitGoalDiscountDto> profitGoalDiscountDtoList) {
        ProfitGoalDiscountDto profitGoalDiscountDto = profitGoalDiscountDtoList.get(0);
        SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.listDimension(profitGoalDiscountDto);
        SubComBudgetForecastDto oldDto = null;
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)subComBudgetForecastEntity))) {
            oldDto = (SubComBudgetForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        }
        SubComAutoDetailDto subComAutoDetailDto = new SubComAutoDetailDto();
        subComBudgetForecastEntity = this.buildSubComBudgetForecast(profitGoalDiscountDtoList, subComBudgetForecastEntity, subComAutoDetailDto);
        this.buildAutoDetail(subComBudgetForecastEntity, subComAutoDetailDto, profitGoalDiscountDtoList);
        this.buildInitDetail(oldDto, subComBudgetForecastEntity);
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)subComBudgetForecastEntity)) && StringUtils.isBlank((CharSequence)subComBudgetForecastEntity.getDataSourceCode())) {
            subComBudgetForecastEntity.setDataSourceCode("auto");
        }
        this.subComBudgetForecastRepository.saveOrUpdate((Object)subComBudgetForecastEntity);
        return subComBudgetForecastEntity.getBudgetForecastCode();
    }

    public void initByCode(String budgetForecastCode) {
        if (StringUtils.isEmpty((CharSequence)budgetForecastCode)) {
            return;
        }
        SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.getByCode(budgetForecastCode);
        SubComBudgetForecastDto oldDto = (SubComBudgetForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        subComBudgetForecastEntity.setRemainderAmount(subComBudgetForecastEntity.getRemainderAmount().subtract(subComBudgetForecastEntity.getBudgetAmount()));
        this.subComAutoDetailRepository.deleteByForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
        this.buildInitDetail(oldDto, subComBudgetForecastEntity);
        this.subComBudgetForecastRepository.saveOrUpdate((Object)subComBudgetForecastEntity);
    }

    public void manualInternalData(String yearMonth) {
        if (StringUtils.isEmpty((CharSequence)yearMonth)) {
            return;
        }
        if (this.redisLockService.isLock("sub_com_budget_forecast:lock:" + yearMonth)) {
            throw new RuntimeException("\u70b9\u5185\u9884\u7b97\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        boolean flag = false;
        try {
            flag = this.redisLockService.tryLock("sub_com_budget_forecast:lock:" + yearMonth, TimeUnit.SECONDS, 7200L);
            log.info("\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5185\u8d39\u7528\u52a0\u9501\u6210\u529f");
            this.calInternalData(yearMonth);
            this.calInternalDataLikeExternal(yearMonth);
        }
        finally {
            if (flag) {
                this.redisLockService.unlock("sub_com_budget_forecast:lock:" + yearMonth);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void calInternalData(String yearMonth) {
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        monthBudgetDto.setYearMonthLy(yearMonth);
        monthBudgetDto.setGroupCode("customer");
        List monthBudgetVoList = this.monthBudgetService.listByConditions(monthBudgetDto);
        if (CollectionUtils.isEmpty((Collection)monthBudgetVoList)) {
            log.info("\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5185\u8d39\u7528\uff0c\u6708\u5ea6\u9884\u7b97\u4e3a\u7a7a\uff01");
            return;
        }
        Set customerCodeSet = monthBudgetVoList.stream().map(MonthBudgetVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet));
        Set customerMdgCodeSet = customerVoList.stream().map(CustomerVo::getErpCode).collect(Collectors.toSet());
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(new ArrayList(customerMdgCodeSet));
        if (CollectionUtils.isEmpty((Collection)salesOrgSubComOrgVos)) {
            log.info("\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5185\u8d39\u7528\uff0c\u5ba2\u6237\u4e0e\u9500\u552e\u673a\u6784\u7684\u5173\u7cfb\u4e3a\u7a7a\uff01");
            return;
        }
        List customerCodes = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        List activityDetailList = this.activityDetailPlanItemSdkService.findSubComActivityDetailByYearMonth(yearMonth, customerCodes);
        HashMap budgetItemCodeLinkActivityDetailMap = new HashMap();
        for (ActivityDetailPlanItemVo vo : activityDetailList) {
            List linkedBudgetList = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(vo.getMonthBudgetCode()) || o.getMonthBudgetCode().equals(vo.getHeadMonthBudgetCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(linkedBudgetList)) continue;
            for (MonthBudgetVo budget : linkedBudgetList) {
                if (!budgetItemCodeLinkActivityDetailMap.containsKey(budget.getBudgetItemCode())) {
                    budgetItemCodeLinkActivityDetailMap.put(budget.getBudgetItemCode(), new ArrayList());
                }
                ((List)budgetItemCodeLinkActivityDetailMap.get(budget.getBudgetItemCode())).add(vo);
            }
        }
        Map subSalesOrgMsgMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
        List subComMonthBudgetVoList = monthBudgetVoList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getCustomerCode()) && subSalesOrgMsgMap.containsKey(o.getCustomerCode().substring(0, 10))).collect(Collectors.toList());
        Set budgetItemCodeSet = subComMonthBudgetVoList.stream().map(MonthBudgetVo::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByMainBudgetItem(new ArrayList(budgetItemCodeSet));
        HashMap<String, List> mainMap = new HashMap<String, List>();
        budgetItemVos.forEach(budgetItemVo -> {
            if (!CollectionUtils.isEmpty((Collection)budgetItemVo.getBudgetItemMainItemList())) {
                mainMap.put(budgetItemVo.getBudgetItemCode(), budgetItemVo.getBudgetItemMainItemList().stream().map(BudgetItemMainItemVo::getMainBudgetItemCode).collect(Collectors.toList()));
            }
        });
        Map<String, String> subComBudgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getBudgetItemName));
        Map<String, List<MonthBudgetVo>> monthBudgetMap = subComMonthBudgetVoList.stream().collect(Collectors.groupingBy(MonthBudgetVo::getBudgetItemCode));
        this.subComBudgetForecastRepository.resetBudgetAmount(yearMonth, FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.listByConditions(yearMonth, FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
        Map budgetForecastMap = subComBudgetForecastEntityList.stream().collect(Collectors.toMap(subComBudgetForecastEntity -> subComBudgetForecastEntity.getBusinessFormatCode() + subComBudgetForecastEntity.getBusinessUnitCode() + subComBudgetForecastEntity.getOrgCode() + subComBudgetForecastEntity.getBudgetItemCode(), Function.identity()));
        if (MapUtils.isEmpty(mainMap)) {
            log.info("\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5185\u8d39\u7528\uff0cmainMap\u4e3a\u7a7a\uff01");
            return;
        }
        mainMap.forEach((subComBudgetItemCode, mainBudgetItemCodeList) -> {
            ArrayList monthBudgetVos = new ArrayList();
            mainBudgetItemCodeList.forEach(mainBudgetItemCode -> {
                if (!monthBudgetMap.containsKey(mainBudgetItemCode)) {
                    return;
                }
                monthBudgetVos.addAll((Collection)monthBudgetMap.get(mainBudgetItemCode));
            });
            Map<String, List<MonthBudgetVo>> cusMonthMap = monthBudgetVos.stream().collect(Collectors.groupingBy(o -> o.getCustomerCode().substring(0, 10)));
            cusMonthMap.forEach((customerCode, value) -> {
                SalesOrgSubComOrgVo comOrgVo;
                SalesOrgSubComOrgVo salesOrgSubComOrgVo;
                SubComBudgetForecastEntity subComBudgetForecastEntity = new SubComBudgetForecastEntity();
                subComBudgetForecastEntity.setDataSourceCode("auto");
                subComBudgetForecastEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                subComBudgetForecastEntity.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                subComBudgetForecastEntity.setYearMonthLy(yearMonth);
                if (!CollectionUtils.isEmpty((Map)subSalesOrgMsgMap) && !Objects.isNull(salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerCode))) {
                    subComBudgetForecastEntity.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                    subComBudgetForecastEntity.setOrgName(salesOrgSubComOrgVo.getOrgName());
                }
                subComBudgetForecastEntity.setBudgetItemCode((String)subComBudgetItemCode);
                subComBudgetForecastEntity.setBudgetItemName((String)subComBudgetItemMap.get(subComBudgetItemCode));
                subComBudgetForecastEntity.setFeeSourceCode(FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
                String key = subComBudgetForecastEntity.getBusinessFormatCode() + subComBudgetForecastEntity.getBusinessUnitCode() + subComBudgetForecastEntity.getOrgCode() + subComBudgetForecastEntity.getBudgetItemCode();
                if (budgetForecastMap.containsKey(key)) {
                    SubComBudgetForecastEntity oldEntity = (SubComBudgetForecastEntity)((Object)((Object)((Object)budgetForecastMap.get(key))));
                    subComBudgetForecastEntity.setBudgetForecastCode(((SubComBudgetForecastEntity)((Object)((Object)((Object)budgetForecastMap.get(key))))).getBudgetForecastCode());
                    subComBudgetForecastEntity.setId(((SubComBudgetForecastEntity)((Object)((Object)((Object)budgetForecastMap.get(key))))).getId());
                    subComBudgetForecastEntity.setAdjustAmount(oldEntity.getAdjustAmount());
                    subComBudgetForecastEntity.setFreezeAmount(oldEntity.getFreezeAmount());
                    subComBudgetForecastEntity.setDesignAmount(oldEntity.getDesignAmount());
                    subComBudgetForecastEntity.setUsedAmount(oldEntity.getUsedAmount());
                    subComBudgetForecastEntity.setFullAcceptUsedAmount(oldEntity.getFullAcceptUsedAmount());
                    subComBudgetForecastEntity.setPartAcceptUsedAmount(oldEntity.getPartAcceptUsedAmount());
                    if (StringUtils.isBlank((CharSequence)oldEntity.getDataSourceCode())) {
                        subComBudgetForecastEntity.setDataSourceCode("auto");
                    }
                } else {
                    subComBudgetForecastEntity.setDataSourceCode("auto");
                    subComBudgetForecastEntity.setBudgetForecastCode((String)this.generateCodeService.generateCode("YSYC", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS).get(0));
                }
                subComBudgetForecastEntity.setTenantCode(TenantUtils.getTenantCode());
                subComBudgetForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                BigDecimal reduce = value.stream().map(MonthBudgetVo::getAfterFreezeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                subComBudgetForecastEntity.setBudgetAmount(Optional.ofNullable(subComBudgetForecastEntity.getBudgetAmount()).orElse(BigDecimal.ZERO).add(reduce));
                subComBudgetForecastEntity.setApprovedAmount(subComBudgetForecastEntity.getBudgetAmount());
                ArrayList activityDetailPlanItemVos = new ArrayList();
                for (MonthBudgetVo budgetVo : value) {
                    if (CollectionUtils.isEmpty((Collection)((Collection)budgetItemCodeLinkActivityDetailMap.get(budgetVo.getBudgetItemCode())))) continue;
                    activityDetailPlanItemVos.addAll((Collection)budgetItemCodeLinkActivityDetailMap.get(budgetVo.getBudgetItemCode()));
                }
                log.error("{}\u7ec6\u6848\uff1a{}", (Object)subComBudgetForecastEntity.getBudgetForecastCode(), (Object)activityDetailPlanItemVos.stream().map(ActivityDetailPlanItemBase::getDetailPlanCode).collect(Collectors.joining(",")));
                subComBudgetForecastEntity.setFirstWholeUndertakeAmt(BigDecimal.ZERO);
                subComBudgetForecastEntity.setFirstPartUndertakeAmt(BigDecimal.ZERO);
                subComBudgetForecastEntity.setApplyAmountUp(BigDecimal.ZERO);
                if (!CollectionUtils.isEmpty(activityDetailPlanItemVos)) {
                    for (ActivityDetailPlanItemVo planItemVo : activityDetailPlanItemVos) {
                        BigDecimal amt;
                        CustomerVo customerVo = customerVoList.stream().filter(o -> o.getCustomerCode().equals(planItemVo.getCustomerCode())).findFirst().orElse(null);
                        if (ObjectUtils.isEmpty((Object)customerVo)) {
                            log.error("\u9884\u7b97\u9884\u6d4b[{}]\u8ba1\u7b97\u70b9\u5185\u660e\u7ec6\u5ba2\u6237[{}]\u4e0d\u5c5e\u4e8e\u6708\u5ea6\u9884\u7b97\u5ba2\u6237", (Object)subComBudgetForecastEntity.getBudgetForecastCode(), (Object)planItemVo.getCustomerCode());
                            continue;
                        }
                        if (Objects.isNull(subSalesOrgMsgMap.get(customerVo.getErpCode())) || StringUtils.isBlank((CharSequence)((SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode())).getOrgCode()) || !((SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode())).getOrgCode().equals(subComBudgetForecastEntity.getOrgCode())) {
                            log.error("\u9884\u7b97\u9884\u6d4b[{}]\u8ba1\u7b97\u70b9\u5185\u660e\u7ec6\u5ba2\u6237[{}]\u6ca1\u6709HR\u7ec4\u7ec7", (Object)subComBudgetForecastEntity.getBudgetForecastCode(), (Object)planItemVo.getCustomerCode());
                            continue;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)planItemVo.getUndertakingMode()) && planItemVo.getUndertakingMode().equals("full_accept")) {
                            BigDecimal firstWholeUndertakeAmt = subComBudgetForecastEntity.getFirstWholeUndertakeAmt() == null ? BigDecimal.ZERO : subComBudgetForecastEntity.getFirstWholeUndertakeAmt();
                            amt = firstWholeUndertakeAmt.add(planItemVo.getIntraCompanyAmount() == null ? BigDecimal.ZERO : planItemVo.getIntraCompanyAmount());
                            subComBudgetForecastEntity.setFirstWholeUndertakeAmt(amt);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)planItemVo.getUndertakingMode()) && planItemVo.getUndertakingMode().equals("part_accept")) {
                            BigDecimal firstPartUndertakeAmt = subComBudgetForecastEntity.getFirstPartUndertakeAmt() == null ? BigDecimal.ZERO : subComBudgetForecastEntity.getFirstPartUndertakeAmt();
                            amt = firstPartUndertakeAmt.add(planItemVo.getIntraCompanyAmount() == null ? BigDecimal.ZERO : planItemVo.getIntraCompanyAmount());
                            subComBudgetForecastEntity.setFirstPartUndertakeAmt(amt);
                        }
                        BigDecimal applyAmountUp = subComBudgetForecastEntity.getApplyAmountUp() == null ? BigDecimal.ZERO : subComBudgetForecastEntity.getApplyAmountUp();
                        amt = applyAmountUp.add(planItemVo.getIntraCompanyAmount() == null ? BigDecimal.ZERO : planItemVo.getIntraCompanyAmount());
                        subComBudgetForecastEntity.setApplyAmountUp(amt);
                        subComBudgetForecastEntity.setFirstBudgetAmount(subComBudgetForecastEntity.getApplyAmountUp());
                    }
                }
                subComBudgetForecastEntity.setSurplusWholeUndertakeAmt(Optional.ofNullable(subComBudgetForecastEntity.getFirstWholeUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComBudgetForecastEntity.getFullAcceptUsedAmount()).orElse(BigDecimal.ZERO)));
                subComBudgetForecastEntity.setSurplusPartUndertakeAmt(Optional.ofNullable(subComBudgetForecastEntity.getFirstPartUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComBudgetForecastEntity.getPartAcceptUsedAmount()).orElse(BigDecimal.ZERO)));
                subComBudgetForecastEntity.setApprovedAmount(subComBudgetForecastEntity.getBudgetAmount());
                BigDecimal remainderAmount = Optional.ofNullable(subComBudgetForecastEntity.getFirstBudgetAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(subComBudgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(subComBudgetForecastEntity.getFreezeAmount()).orElse(BigDecimal.ZERO));
                subComBudgetForecastEntity.setRemainderAmount(remainderAmount);
                if (subSalesOrgMsgMap.containsKey(customerCode) && null != (comOrgVo = (SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerCode))) {
                    subComBudgetForecastEntity.setSalesCompanyCode(comOrgVo.getSalesOrgCode());
                    subComBudgetForecastEntity.setSalesCompanyName(comOrgVo.getSubComOrgName());
                }
                this.buildInternalDetail((List<MonthBudgetVo>)value, subComBudgetForecastEntity);
                this.buildInternalInitDetail(subComBudgetForecastEntity);
                this.subComBudgetForecastRepository.saveOrUpdate((Object)subComBudgetForecastEntity);
            });
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void calInternalDataLikeExternal(String yearMonth) {
        HashMap<String, SubComBudgetForecastEntity> resultMap = new HashMap<String, SubComBudgetForecastEntity>();
        ArrayList<SubComOffDetailPlanEntity> saveDetailPlanList = new ArrayList<SubComOffDetailPlanEntity>();
        ArrayList<SubComOffPlanEntity> savePlanList = new ArrayList<SubComOffPlanEntity>();
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.findAll();
        List subComCustomerErpCodeList = salesOrgSubComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).collect(Collectors.toList());
        List customerList = this.customerVoService.findByErpCodeList(subComCustomerErpCodeList);
        List customerCode = customerList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        List activityDetailList = this.activityDetailPlanItemSdkService.findSubComActivityDetailByYearMonth(yearMonth, customerCode);
        this.buildInternalByActivityDetail(yearMonth, activityDetailList, resultMap, saveDetailPlanList, savePlanList);
        this.subComBudgetForecastRepository.saveOrUpdateBatch(new ArrayList(resultMap.values()));
        this.subComOffDetailPlanRepository.saveOrUpdateBatch(saveDetailPlanList);
    }

    private void buildInternalByActivityDetail(String yearMonth, List<ActivityDetailPlanItemVo> activityDetailList, Map<String, SubComBudgetForecastEntity> resultMap, List<SubComOffDetailPlanEntity> saveDetailPlanList, List<SubComOffPlanEntity> savePlanList) {
        Set customerCodeSet = activityDetailList.stream().map(ActivityDetailPlanItemBase::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List customerVoList = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        Set customerMdgCodeSet = customerVoList.stream().map(CustomerVo::getErpCode).collect(Collectors.toSet());
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(new ArrayList(customerMdgCodeSet));
        if (CollectionUtils.isEmpty((Collection)salesOrgSubComOrgVos)) {
            return;
        }
        Map subSalesOrgMsgMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
        Map<String, List<ActivityDetailPlanItemVo>> activityCustomerMap = activityDetailList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())).collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getCustomerCode));
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setMonthBudgetCodeList(activityDetailList.stream().map(ActivityDetailPlanItemBase::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        monthBudgetDto.getMonthBudgetCodeList().addAll(activityDetailList.stream().map(ActivityDetailPlanItemBase::getHeadMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        List monthBudgetVoList = this.monthBudgetService.listByConditions(monthBudgetDto);
        HashMap budgetItemCodeLinkActivityDetailMap = new HashMap();
        for (ActivityDetailPlanItemVo vo : activityDetailList) {
            List linkedBudgetList = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(vo.getMonthBudgetCode()) || o.getMonthBudgetCode().equals(vo.getHeadMonthBudgetCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(linkedBudgetList)) continue;
            for (MonthBudgetVo budget : linkedBudgetList) {
                if (!budgetItemCodeLinkActivityDetailMap.containsKey(budget.getBudgetItemCode())) {
                    budgetItemCodeLinkActivityDetailMap.put(budget.getBudgetItemCode(), new ArrayList());
                }
                ((List)budgetItemCodeLinkActivityDetailMap.get(budget.getBudgetItemCode())).add(vo);
            }
        }
        Set budgetItemCodeSet = monthBudgetVoList.stream().map(MonthBudgetVo::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByMainBudgetItem(new ArrayList(budgetItemCodeSet));
        Map budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        HashMap<String, List<String>> mainMap = new HashMap<String, List<String>>();
        budgetItemVos.forEach(budgetItemVo -> {
            if (!CollectionUtils.isEmpty((Collection)budgetItemVo.getBudgetItemMainItemList())) {
                mainMap.put(budgetItemVo.getBudgetItemCode(), budgetItemVo.getBudgetItemMainItemList().stream().map(BudgetItemMainItemVo::getMainBudgetItemCode).collect(Collectors.toList()));
            }
        });
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.listByConditions(yearMonth, FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
        Map budgetForecastMap = subComBudgetForecastEntityList.stream().collect(Collectors.toMap(subComBudgetForecastEntity -> subComBudgetForecastEntity.getBusinessFormatCode() + subComBudgetForecastEntity.getBusinessUnitCode() + subComBudgetForecastEntity.getOrgCode() + subComBudgetForecastEntity.getBudgetItemCode(), Function.identity()));
        for (Map.Entry<String, List<ActivityDetailPlanItemVo>> entry : activityCustomerMap.entrySet()) {
            String customerCode = entry.getKey();
            Optional<CustomerVo> customerOptional = customerVoList.stream().filter(o -> customerCode.equals(o.getCustomerCode())).findFirst();
            CustomerVo customerVo = null;
            if (!customerOptional.isPresent()) {
                throw new UnsupportedOperationException("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff0c\u5ba2\u6237\u4e0d\u5b58\u5728");
            }
            customerVo = customerOptional.get();
            if (StringUtils.isEmpty((CharSequence)customerVo.getErpCode())) {
                throw new UnsupportedOperationException("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff0cerp\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            if (Objects.isNull(subSalesOrgMsgMap.get(customerVo.getErpCode())) || StringUtils.isEmpty((CharSequence)((SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode())).getOrgCode())) {
                log.error("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b-\u5ba2\u6237[{}}]\u672a\u80fd\u627e\u5230\u5bf9\u5e94hr\u90e8\u95e8\u4fe1\u606f\uff0c\u4e0b\u5217\u6d3b\u52a8\u660e\u7ec6\u5df2\u8df3\u8fc7\uff1a" + JSON.toJSONString(entry.getValue().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList())), (Object)customerVo.getCustomerCode());
                continue;
            }
            for (String budgetItemCode : mainMap.keySet()) {
                SalesOrgSubComOrgVo comOrgVo;
                SalesOrgSubComOrgVo salesOrgSubComOrgVo;
                List mainBudgetItemCode = (List)mainMap.get(budgetItemCode);
                ArrayList<ActivityDetailPlanItemVo> linkActivityList = new ArrayList<ActivityDetailPlanItemVo>();
                for (Object mainCode : mainBudgetItemCode) {
                    linkActivityList.addAll(((List)budgetItemCodeLinkActivityDetailMap.get(mainCode)).stream().filter(o -> customerCode.equals(o.getCustomerCode())).collect(Collectors.toList()));
                }
                if (CollectionUtils.isEmpty(linkActivityList)) continue;
                Map<String, List<ActivityDetailPlanItemVo>> linkActivityItemMap = linkActivityList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getDetailPlanItemCode));
                if (linkActivityList.size() != linkActivityItemMap.keySet().size()) {
                    Object mainCode;
                    linkActivityList.clear();
                    mainCode = linkActivityItemMap.keySet().iterator();
                    while (mainCode.hasNext()) {
                        String key = (String)mainCode.next();
                        linkActivityList.add(linkActivityItemMap.get(key).get(0));
                    }
                }
                BudgetItemVo budgetItem = (BudgetItemVo)budgetItemMap.get(budgetItemCode);
                SubComBudgetForecastEntity entity = new SubComBudgetForecastEntity();
                entity.setBudgetAmount(BigDecimal.ZERO);
                entity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                entity.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                entity.setYearMonthLy(yearMonth);
                if (!CollectionUtils.isEmpty(subSalesOrgMsgMap) && !Objects.isNull(salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode()))) {
                    entity.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                    entity.setOrgName(salesOrgSubComOrgVo.getOrgName());
                }
                entity.setBudgetItemCode(budgetItem.getBudgetItemCode());
                entity.setBudgetItemName(budgetItem.getBudgetItemName());
                entity.setFeeSourceCode(FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
                entity.setApprovedAmount(BigDecimal.ZERO);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                String key = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getOrgCode() + entity.getBudgetItemCode();
                if (budgetForecastMap.containsKey(key)) {
                    SubComBudgetForecastEntity oldEntity = (SubComBudgetForecastEntity)((Object)budgetForecastMap.get(key));
                    entity.setBudgetForecastCode(((SubComBudgetForecastEntity)((Object)budgetForecastMap.get(key))).getBudgetForecastCode());
                    entity.setId(((SubComBudgetForecastEntity)((Object)budgetForecastMap.get(key))).getId());
                    entity.setAdjustAmount(oldEntity.getAdjustAmount());
                    entity.setFreezeAmount(oldEntity.getFreezeAmount());
                    entity.setDesignAmount(oldEntity.getDesignAmount());
                    entity.setUsedAmount(oldEntity.getUsedAmount());
                    entity.setFullAcceptUsedAmount(oldEntity.getFullAcceptUsedAmount());
                    entity.setPartAcceptUsedAmount(oldEntity.getPartAcceptUsedAmount());
                    entity.setApprovedAmount(oldEntity.getApprovedAmount());
                    entity.setBudgetAmount(oldEntity.getBudgetAmount());
                    if (StringUtils.isBlank((CharSequence)oldEntity.getDataSourceCode())) {
                        entity.setDataSourceCode("auto");
                    }
                } else {
                    entity.setDataSourceCode("auto");
                    entity.setBudgetForecastCode((String)this.generateCodeService.generateCode("YSYC", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS).get(0));
                }
                if (resultMap.containsKey(key)) {
                    entity.setBudgetForecastCode(resultMap.get(key).getBudgetForecastCode());
                    entity.setBudgetAmount(resultMap.get(key).getBudgetAmount());
                }
                for (ActivityDetailPlanItemVo item : linkActivityList) {
                    BigDecimal amt;
                    if (StringUtils.isNotEmpty((CharSequence)item.getUndertakingMode()) && item.getUndertakingMode().equals("full_accept")) {
                        BigDecimal firstWholeUndertakeAmt = entity.getFirstWholeUndertakeAmt() == null ? BigDecimal.ZERO : entity.getFirstWholeUndertakeAmt();
                        amt = firstWholeUndertakeAmt.add(item.getIntraCompanyAmount() == null ? BigDecimal.ZERO : item.getIntraCompanyAmount());
                        entity.setFirstWholeUndertakeAmt(amt);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)item.getUndertakingMode()) && item.getUndertakingMode().equals("part_accept")) {
                        BigDecimal firstPartUndertakeAmt = entity.getFirstPartUndertakeAmt() == null ? BigDecimal.ZERO : entity.getFirstPartUndertakeAmt();
                        amt = firstPartUndertakeAmt.add(item.getIntraCompanyAmount() == null ? BigDecimal.ZERO : item.getIntraCompanyAmount());
                        entity.setFirstPartUndertakeAmt(amt);
                    }
                    BigDecimal applyAmountUp = entity.getApplyAmountUp() == null ? BigDecimal.ZERO : entity.getApplyAmountUp();
                    amt = applyAmountUp.add(item.getIntraCompanyAmount() == null ? BigDecimal.ZERO : item.getIntraCompanyAmount());
                    entity.setApplyAmountUp(amt);
                    entity.setFirstBudgetAmount(entity.getApplyAmountUp());
                }
                entity.setSurplusWholeUndertakeAmt(Optional.ofNullable(entity.getFirstWholeUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(entity.getFullAcceptUsedAmount()).orElse(BigDecimal.ZERO)));
                entity.setSurplusPartUndertakeAmt(Optional.ofNullable(entity.getFirstPartUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(entity.getPartAcceptUsedAmount()).orElse(BigDecimal.ZERO)));
                entity.setApprovedAmount(entity.getBudgetAmount());
                BigDecimal remainderAmount = Optional.ofNullable(entity.getFirstBudgetAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(entity.getUsedAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO));
                entity.setRemainderAmount(remainderAmount);
                resultMap.put(key, entity);
                if (subSalesOrgMsgMap.containsKey(customerVo.getErpCode()) && null != (comOrgVo = (SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode()))) {
                    entity.setSalesCompanyCode(comOrgVo.getSalesOrgCode());
                    entity.setSalesCompanyName(comOrgVo.getSubComOrgName());
                }
                this.buildInternalDetailActivityDetailPart(yearMonth, entity.getBudgetForecastCode(), saveDetailPlanList, linkActivityList, monthBudgetVoList, budgetItem, mainMap);
            }
        }
    }

    private void buildInternalDetailActivityDetailPart(String yearMonth, String budgetForecastCode, List<SubComOffDetailPlanEntity> saveDetailPlanList, List<ActivityDetailPlanItemVo> activityDetailList, List<MonthBudgetVo> monthBudgetVoList, BudgetItemVo budgetItem, Map<String, List<String>> mainMap) {
        for (ActivityDetailPlanItemVo itemVo : activityDetailList) {
            Optional<MonthBudgetVo> baseOptional;
            List<String> mainItemCodeList = mainMap.get(budgetItem.getBudgetItemCode());
            BigDecimal amount = BigDecimal.ZERO;
            Optional<MonthBudgetVo> areaOptional = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(itemVo.getMonthBudgetCode())).findFirst();
            if (areaOptional.isPresent() && mainItemCodeList.contains(areaOptional.get().getBudgetItemCode())) {
                amount = amount.add(itemVo.getDepartmentFeeAmount() == null ? BigDecimal.ZERO : itemVo.getDepartmentFeeAmount()).subtract(itemVo.getIntraCompanyAmount() == null ? BigDecimal.ZERO : itemVo.getIntraCompanyAmount());
            }
            if ((baseOptional = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(itemVo.getHeadMonthBudgetCode())).findFirst()).isPresent() && mainItemCodeList.contains(baseOptional.get().getBudgetItemCode())) {
                amount = amount.add(itemVo.getHeadFeeAmount() == null ? BigDecimal.ZERO : itemVo.getHeadFeeAmount());
            }
            if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
            SubComOffDetailPlanEntity detailEntity = new SubComOffDetailPlanEntity();
            detailEntity.setBudgetForecastCode(budgetForecastCode);
            detailEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            detailEntity.setYearMonthLy(yearMonth);
            detailEntity.setDetailPlanCode(itemVo.getDetailPlanCode());
            detailEntity.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
            detailEntity.setDetailPlanName(itemVo.getDetailPlanName());
            detailEntity.setPlanCode(itemVo.getRelatePlanCode());
            detailEntity.setPlanItemCode(itemVo.getRelatePlanItemCode());
            detailEntity.setPlanName(null);
            detailEntity.setActivityFormName(itemVo.getActivityFormName());
            detailEntity.setActivityFormCode(itemVo.getActivityFormCode());
            detailEntity.setActivityTypeName(itemVo.getActivityTypeName());
            detailEntity.setActivityTypeCode(itemVo.getActivityTypeCode());
            detailEntity.setActivityBeginDate(DateUtil.format((Date)itemVo.getActivityBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            detailEntity.setActivityEndDate(DateUtil.format((Date)itemVo.getActivityEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            detailEntity.setProductBrandCode(itemVo.getProductBrandCode());
            detailEntity.setProductBrandName(itemVo.getProductBrandName());
            detailEntity.setProductCategoryCode(itemVo.getProductCategoryCode());
            detailEntity.setProductCategoryName(itemVo.getProductCategoryName());
            detailEntity.setProductItemCode(itemVo.getProductItemCode());
            detailEntity.setProductItemName(itemVo.getProductItemName());
            detailEntity.setProductCode(itemVo.getProductCode());
            detailEntity.setProductName(itemVo.getProductName());
            detailEntity.setBudgetType(budgetItem.getFeeAttrCode());
            detailEntity.setAmount(amount);
            detailEntity.setFeeBelongCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
            detailEntity.setBudgetItemCode(budgetItem.getBudgetItemCode());
            detailEntity.setBudgetItemName(budgetItem.getBudgetItemName());
            detailEntity.setTenantCode(TenantUtils.getTenantCode());
            detailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            SubComOffDetailPlanEntity existEntity = this.subComOffDetailPlanRepository.findByDetailPlanItemCodeAndBudgetForecastCode(itemVo.getDetailPlanItemCode(), budgetForecastCode);
            if (existEntity != null) {
                detailEntity.setId(existEntity.getId());
            }
            saveDetailPlanList.add(detailEntity);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void calExternalData(String yearMonth) {
        HashMap<String, SubComBudgetForecastEntity> resultMap = new HashMap<String, SubComBudgetForecastEntity>();
        ArrayList<SubComOffDetailPlanEntity> saveDetailPlanList = new ArrayList<SubComOffDetailPlanEntity>();
        ArrayList<SubComOffPlanEntity> savePlanList = new ArrayList<SubComOffPlanEntity>();
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.findAll();
        List subComCustomerErpCodeList = salesOrgSubComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).collect(Collectors.toList());
        List customerList = this.customerVoService.findByErpCodeList(subComCustomerErpCodeList);
        List customerCode = customerList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        List activityDetailList = this.activityDetailPlanItemSdkService.findSubComActivityDetailByYearMonth(yearMonth, customerCode);
        this.buildExternalByActivityDetail(yearMonth, activityDetailList, resultMap, saveDetailPlanList, savePlanList);
        log.info("\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5916\u8d39\u7528\uff0c\u751f\u6210\u6570\u636e\uff1a{}", (Object)resultMap.values().size());
        this.subComBudgetForecastRepository.saveOrUpdateBatch(new ArrayList(resultMap.values()));
        this.subComOffDetailPlanRepository.saveOrUpdateBatch(saveDetailPlanList);
    }

    private void buildExternalByActivityDetail(String yearMonth, List<ActivityDetailPlanItemVo> activityDetailList, Map<String, SubComBudgetForecastEntity> resultMap, List<SubComOffDetailPlanEntity> saveDetailPlanList, List<SubComOffPlanEntity> savePlanList) {
        Set customerCodeSet = activityDetailList.stream().map(ActivityDetailPlanItemBase::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List customerVoList = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        Set customerMdgCodeSet = customerVoList.stream().map(CustomerVo::getErpCode).collect(Collectors.toSet());
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(new ArrayList(customerMdgCodeSet));
        if (CollectionUtils.isEmpty((Collection)salesOrgSubComOrgVos)) {
            log.info("\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5916\u8d39\u7528\uff0c\u5ba2\u6237\u4e0e\u9500\u552e\u673a\u6784\u7684\u5173\u7cfb\u4e3a\u7a7a\uff01");
            return;
        }
        Map subSalesOrgMsgMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
        Map<String, List<ActivityDetailPlanItemVo>> activityCustomerMap = activityDetailList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())).collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getCustomerCode));
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setMonthBudgetCodeList(activityDetailList.stream().map(ActivityDetailPlanItemBase::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        monthBudgetDto.getMonthBudgetCodeList().addAll(activityDetailList.stream().map(ActivityDetailPlanItemBase::getHeadMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        List monthBudgetVoList = this.monthBudgetService.listByConditions(monthBudgetDto);
        HashMap budgetItemCodeLinkActivityDetailMap = new HashMap();
        for (ActivityDetailPlanItemVo vo : activityDetailList) {
            List linkedBudgetList = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(vo.getMonthBudgetCode()) || o.getMonthBudgetCode().equals(vo.getHeadMonthBudgetCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(linkedBudgetList)) continue;
            for (MonthBudgetVo budget : linkedBudgetList) {
                if (!budgetItemCodeLinkActivityDetailMap.containsKey(budget.getBudgetItemCode())) {
                    budgetItemCodeLinkActivityDetailMap.put(budget.getBudgetItemCode(), new ArrayList());
                }
                ((List)budgetItemCodeLinkActivityDetailMap.get(budget.getBudgetItemCode())).add(vo);
            }
        }
        Set budgetItemCodeSet = monthBudgetVoList.stream().map(MonthBudgetVo::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByMainBudgetItem(new ArrayList(budgetItemCodeSet));
        Map budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
        HashMap<String, List<String>> mainMap = new HashMap<String, List<String>>();
        budgetItemVos.forEach(budgetItemVo -> {
            if (!CollectionUtils.isEmpty((Collection)budgetItemVo.getBudgetItemMainItemList())) {
                mainMap.put(budgetItemVo.getBudgetItemCode(), budgetItemVo.getBudgetItemMainItemList().stream().map(BudgetItemMainItemVo::getMainBudgetItemCode).collect(Collectors.toList()));
            }
        });
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.listByConditions(yearMonth, FeeSourceEnum.OFF_POINT_FEE.getCode());
        Map budgetForecastMap = subComBudgetForecastEntityList.stream().collect(Collectors.toMap(subComBudgetForecastEntity -> subComBudgetForecastEntity.getBusinessFormatCode() + subComBudgetForecastEntity.getBusinessUnitCode() + subComBudgetForecastEntity.getOrgCode() + subComBudgetForecastEntity.getBudgetItemCode(), Function.identity()));
        for (Map.Entry<String, List<ActivityDetailPlanItemVo>> entry : activityCustomerMap.entrySet()) {
            String customerCode = entry.getKey();
            Optional<CustomerVo> customerOptional = customerVoList.stream().filter(o -> customerCode.equals(o.getCustomerCode())).findFirst();
            CustomerVo customerVo = null;
            if (!customerOptional.isPresent()) {
                throw new UnsupportedOperationException("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff0c\u5ba2\u6237\u4e0d\u5b58\u5728");
            }
            customerVo = customerOptional.get();
            if (StringUtils.isEmpty((CharSequence)customerVo.getErpCode())) {
                throw new UnsupportedOperationException("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff0cerp\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            if (Objects.isNull(subSalesOrgMsgMap.get(customerVo.getErpCode())) || StringUtils.isEmpty((CharSequence)((SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode())).getOrgCode())) {
                log.error("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b-\u5ba2\u6237[{}}]\u672a\u80fd\u627e\u5230\u5bf9\u5e94hr\u90e8\u95e8\u4fe1\u606f\uff0c\u4e0b\u5217\u6d3b\u52a8\u660e\u7ec6\u5df2\u8df3\u8fc7\uff1a" + JSON.toJSONString(entry.getValue().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList())), (Object)customerVo.getCustomerCode());
                continue;
            }
            for (String budgetItemCode : mainMap.keySet()) {
                SalesOrgSubComOrgVo comOrgVo;
                SalesOrgSubComOrgVo salesOrgSubComOrgVo;
                List mainBudgetItemCode = (List)mainMap.get(budgetItemCode);
                ArrayList<ActivityDetailPlanItemVo> linkActivityList = new ArrayList<ActivityDetailPlanItemVo>();
                for (Object mainCode : mainBudgetItemCode) {
                    linkActivityList.addAll(((List)budgetItemCodeLinkActivityDetailMap.get(mainCode)).stream().filter(o -> customerCode.equals(o.getCustomerCode())).collect(Collectors.toList()));
                }
                if (CollectionUtils.isEmpty(linkActivityList)) continue;
                Map<String, List<ActivityDetailPlanItemVo>> linkActivityItemMap = linkActivityList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getDetailPlanItemCode));
                if (linkActivityList.size() != linkActivityItemMap.keySet().size()) {
                    Object mainCode;
                    linkActivityList.clear();
                    mainCode = linkActivityItemMap.keySet().iterator();
                    while (mainCode.hasNext()) {
                        String key = (String)mainCode.next();
                        linkActivityList.add(linkActivityItemMap.get(key).get(0));
                    }
                }
                BudgetItemVo budgetItem = (BudgetItemVo)budgetItemMap.get(budgetItemCode);
                SubComBudgetForecastEntity entity = new SubComBudgetForecastEntity();
                entity.setBudgetAmount(BigDecimal.ZERO);
                entity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                entity.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                entity.setYearMonthLy(yearMonth);
                if (!CollectionUtils.isEmpty(subSalesOrgMsgMap) && !Objects.isNull(salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode()))) {
                    entity.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                    entity.setOrgName(salesOrgSubComOrgVo.getOrgName());
                }
                entity.setBudgetItemCode(budgetItem.getBudgetItemCode());
                entity.setBudgetItemName(budgetItem.getBudgetItemName());
                entity.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
                entity.setApprovedAmount(BigDecimal.ZERO);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                String key = entity.getBusinessFormatCode() + entity.getBusinessUnitCode() + entity.getOrgCode() + entity.getBudgetItemCode();
                if (budgetForecastMap.containsKey(key)) {
                    SubComBudgetForecastEntity oldEntity = (SubComBudgetForecastEntity)((Object)budgetForecastMap.get(key));
                    entity.setBudgetForecastCode(((SubComBudgetForecastEntity)((Object)budgetForecastMap.get(key))).getBudgetForecastCode());
                    entity.setId(((SubComBudgetForecastEntity)((Object)budgetForecastMap.get(key))).getId());
                    entity.setAdjustAmount(oldEntity.getAdjustAmount());
                    entity.setFreezeAmount(oldEntity.getFreezeAmount());
                    entity.setDesignAmount(oldEntity.getDesignAmount());
                    entity.setUsedAmount(oldEntity.getUsedAmount());
                    entity.setFullAcceptUsedAmount(oldEntity.getFullAcceptUsedAmount());
                    entity.setPartAcceptUsedAmount(oldEntity.getPartAcceptUsedAmount());
                    if (StringUtils.isBlank((CharSequence)oldEntity.getDataSourceCode())) {
                        entity.setDataSourceCode("auto");
                    }
                } else {
                    entity.setDataSourceCode("auto");
                    entity.setBudgetForecastCode((String)this.generateCodeService.generateCode("YSYC", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS).get(0));
                }
                if (resultMap.containsKey(key)) {
                    entity.setBudgetForecastCode(resultMap.get(key).getBudgetForecastCode());
                    entity.setBudgetAmount(resultMap.get(key).getBudgetAmount());
                }
                for (ActivityDetailPlanItemVo item : linkActivityList) {
                    BigDecimal amt;
                    BigDecimal offPointAmount;
                    BigDecimal headFeeAmount;
                    if (StringUtils.isNotEmpty((CharSequence)item.getBudgetItemCode()) && mainBudgetItemCode.contains(item.getBudgetItemCode())) {
                        entity.setBudgetAmount(entity.getBudgetAmount().add(item.getDepartmentFeeAmount() == null ? BigDecimal.ZERO : item.getDepartmentFeeAmount()).subtract(item.getIntraCompanyAmount() == null ? BigDecimal.ZERO : item.getIntraCompanyAmount()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)item.getHeadBudgetItemCode()) && mainBudgetItemCode.contains(item.getHeadBudgetItemCode())) {
                        entity.setBudgetAmount(entity.getBudgetAmount().add(item.getHeadFeeAmount() == null ? BigDecimal.ZERO : item.getHeadFeeAmount()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)item.getUndertakingMode()) && item.getUndertakingMode().equals("full_accept")) {
                        headFeeAmount = item.getHeadFeeAmount() == null ? BigDecimal.ZERO : item.getHeadFeeAmount();
                        offPointAmount = item.getOffPointAmount() == null ? BigDecimal.ZERO : item.getOffPointAmount();
                        amt = Optional.ofNullable(item.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getIntraCompanyAmount()).orElse(BigDecimal.ZERO));
                        BigDecimal firstWholeUndertakeAmt = entity.getFirstWholeUndertakeAmt() == null ? BigDecimal.ZERO : entity.getFirstWholeUndertakeAmt();
                        entity.setFirstWholeUndertakeAmt(firstWholeUndertakeAmt.add(amt));
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)item.getUndertakingMode()) || !item.getUndertakingMode().equals("part_accept")) continue;
                    headFeeAmount = item.getHeadFeeAmount() == null ? BigDecimal.ZERO : item.getHeadFeeAmount();
                    offPointAmount = item.getOffPointAmount() == null ? BigDecimal.ZERO : item.getOffPointAmount();
                    amt = Optional.ofNullable(item.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(item.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(item.getIntraCompanyAmount()).orElse(BigDecimal.ZERO));
                    BigDecimal firstPartUndertakeAmt = entity.getFirstPartUndertakeAmt() == null ? BigDecimal.ZERO : entity.getFirstPartUndertakeAmt();
                    entity.setFirstPartUndertakeAmt(firstPartUndertakeAmt.add(amt));
                }
                entity.setApplyAmountUp(entity.getBudgetAmount());
                entity.setSurplusWholeUndertakeAmt(Optional.ofNullable(entity.getFirstWholeUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(entity.getFullAcceptUsedAmount()).orElse(BigDecimal.ZERO)));
                entity.setSurplusPartUndertakeAmt(Optional.ofNullable(entity.getFirstPartUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(entity.getPartAcceptUsedAmount()).orElse(BigDecimal.ZERO)));
                entity.setApprovedAmount(entity.getBudgetAmount());
                entity.setFirstBudgetAmount(entity.getApplyAmountUp());
                BigDecimal remainderAmount = Optional.ofNullable(entity.getFirstBudgetAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(entity.getUsedAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(entity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(entity.getFreezeAmount()).orElse(BigDecimal.ZERO));
                entity.setRemainderAmount(remainderAmount);
                resultMap.put(key, entity);
                if (subSalesOrgMsgMap.containsKey(customerVo.getErpCode()) && null != (comOrgVo = (SalesOrgSubComOrgVo)subSalesOrgMsgMap.get(customerVo.getErpCode()))) {
                    entity.setSalesCompanyCode(comOrgVo.getSalesOrgCode());
                    entity.setSalesCompanyName(comOrgVo.getSubComOrgName());
                }
                this.buildExternalDetailActivityDetailPart(yearMonth, entity.getBudgetForecastCode(), saveDetailPlanList, linkActivityList, monthBudgetVoList, budgetItem, mainMap);
            }
        }
    }

    private void buildExternalDetailActivityDetailPart(String yearMonth, String budgetForecastCode, List<SubComOffDetailPlanEntity> saveDetailPlanList, List<ActivityDetailPlanItemVo> activityDetailList, List<MonthBudgetVo> monthBudgetVoList, BudgetItemVo budgetItem, Map<String, List<String>> mainMap) {
        for (ActivityDetailPlanItemVo itemVo : activityDetailList) {
            Optional<MonthBudgetVo> baseOptional;
            List<String> mainItemCodeList = mainMap.get(budgetItem.getBudgetItemCode());
            BigDecimal amount = BigDecimal.ZERO;
            Optional<MonthBudgetVo> areaOptional = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(itemVo.getMonthBudgetCode())).findFirst();
            if (areaOptional.isPresent() && mainItemCodeList.contains(areaOptional.get().getBudgetItemCode())) {
                amount = amount.add(itemVo.getDepartmentFeeAmount() == null ? BigDecimal.ZERO : itemVo.getDepartmentFeeAmount()).subtract(itemVo.getIntraCompanyAmount() == null ? BigDecimal.ZERO : itemVo.getIntraCompanyAmount());
            }
            if ((baseOptional = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(itemVo.getHeadMonthBudgetCode())).findFirst()).isPresent() && mainItemCodeList.contains(baseOptional.get().getBudgetItemCode())) {
                amount = amount.add(itemVo.getHeadFeeAmount() == null ? BigDecimal.ZERO : itemVo.getHeadFeeAmount());
            }
            if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
            SubComOffDetailPlanEntity detailEntity = new SubComOffDetailPlanEntity();
            detailEntity.setBudgetForecastCode(budgetForecastCode);
            detailEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            detailEntity.setYearMonthLy(yearMonth);
            detailEntity.setDetailPlanCode(itemVo.getDetailPlanCode());
            detailEntity.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
            detailEntity.setDetailPlanName(itemVo.getDetailPlanName());
            detailEntity.setPlanCode(itemVo.getRelatePlanCode());
            detailEntity.setPlanItemCode(itemVo.getRelatePlanItemCode());
            detailEntity.setPlanName(null);
            detailEntity.setActivityFormName(itemVo.getActivityFormName());
            detailEntity.setActivityFormCode(itemVo.getActivityFormCode());
            detailEntity.setActivityTypeName(itemVo.getActivityTypeName());
            detailEntity.setActivityTypeCode(itemVo.getActivityTypeCode());
            detailEntity.setActivityBeginDate(DateUtil.format((Date)itemVo.getActivityBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            detailEntity.setActivityEndDate(DateUtil.format((Date)itemVo.getActivityEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            detailEntity.setProductBrandCode(itemVo.getProductBrandCode());
            detailEntity.setProductBrandName(itemVo.getProductBrandName());
            detailEntity.setProductCategoryCode(itemVo.getProductCategoryCode());
            detailEntity.setProductCategoryName(itemVo.getProductCategoryName());
            detailEntity.setProductItemCode(itemVo.getProductItemCode());
            detailEntity.setProductItemName(itemVo.getProductItemName());
            detailEntity.setProductCode(itemVo.getProductCode());
            detailEntity.setProductName(itemVo.getProductName());
            detailEntity.setBudgetType(budgetItem.getFeeAttrCode());
            detailEntity.setAmount(amount);
            detailEntity.setFeeBelongCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
            detailEntity.setBudgetItemCode(budgetItem.getBudgetItemCode());
            detailEntity.setBudgetItemName(budgetItem.getBudgetItemName());
            detailEntity.setUndertakingMode(itemVo.getUndertakingMode());
            detailEntity.setTenantCode(TenantUtils.getTenantCode());
            detailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            SubComOffDetailPlanEntity existEntity = this.subComOffDetailPlanRepository.findByDetailPlanItemCodeAndBudgetForecastCode(itemVo.getDetailPlanItemCode(), budgetForecastCode);
            if (existEntity != null) {
                detailEntity.setId(existEntity.getId());
            }
            saveDetailPlanList.add(detailEntity);
        }
    }

    private List<SubComOffDetailPlanEntity> buildExternalDetail(List<ActivityDetailPlanItemVo> activityDetailList, SubComBudgetForecastEntity subComBudgetForecastEntity) {
        ArrayList<SubComOffDetailPlanEntity> subComExternalDetailEntities = new ArrayList<SubComOffDetailPlanEntity>();
        activityDetailList.forEach(activityDetail -> {
            SubComOffDetailPlanEntity subComOffDetailPlanEntity = (SubComOffDetailPlanEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(activityDetail, SubComOffDetailPlanEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            subComOffDetailPlanEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            subComOffDetailPlanEntity.setTenantCode(TenantUtils.getTenantCode());
            subComOffDetailPlanEntity.setId(null);
            subComOffDetailPlanEntity.setBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
            subComOffDetailPlanEntity.setAmount(activityDetail.getCustomerFeeAmount());
            subComExternalDetailEntities.add(subComOffDetailPlanEntity);
        });
        return subComExternalDetailEntities;
    }

    public List<SubComBudgetForecastVo> listByConditions(SubComBudgetForecastDto subComBudgetForecastDto) {
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)subComBudgetForecastDto)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getBusinessFormatCode()) && StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getBusinessUnitCode()) && StringUtils.isEmpty((CharSequence)subComBudgetForecastDto.getOrgCode()) && CollectionUtils.isEmpty((Collection)subComBudgetForecastDto.getYearMonthList())) {
            return Lists.newArrayList();
        }
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.listByConditions(subComBudgetForecastDto);
        if (CollectionUtils.isEmpty(subComBudgetForecastEntityList)) {
            return Lists.newArrayList();
        }
        Collection subComBudgetForecastVos = this.nebulaToolkitService.copyCollectionByWhiteList(subComBudgetForecastEntityList, SubComBudgetForecastEntity.class, SubComBudgetForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<SubComBudgetForecastVo>(subComBudgetForecastVos);
    }

    @Transactional(rollbackFor={Exception.class})
    public void operationBudgetForecast(List<SubComBudgetForecastDetailDto> subComBudgetForecastDtoList) {
        List autoEntityList;
        if (CollectionUtils.isEmpty(subComBudgetForecastDtoList)) {
            return;
        }
        Map<String, List<SubComBudgetForecastDetailDto>> forecastMap = subComBudgetForecastDtoList.stream().collect(Collectors.groupingBy(SubComBudgetForecastDetailDto::getBudgetForecastCode));
        List<String> budgetForecastCodeList = subComBudgetForecastDtoList.stream().map(SubComBudgetForecastDetailDto::getBudgetForecastCode).distinct().collect(Collectors.toList());
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.listByCodes(budgetForecastCodeList, null);
        if (CollectionUtils.isEmpty(subComBudgetForecastEntityList)) {
            throw new RuntimeException("\u9884\u7b97\u9884\u6d4b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ArrayList detailList = Lists.newArrayList();
        subComBudgetForecastEntityList.forEach(subComBudgetForecastEntity -> {
            if (forecastMap.containsKey(subComBudgetForecastEntity.getBudgetForecastCode())) {
                List thisSubComBudgetForecastDtoList = (List)forecastMap.get(subComBudgetForecastEntity.getBudgetForecastCode());
                for (SubComBudgetForecastDetailDto subComBudgetForecastDto : thisSubComBudgetForecastDtoList) {
                    BigDecimal remainderAmount = subComBudgetForecastEntity.getRemainderAmount();
                    if (ForecastOperationTypeEnum.USE.getCode().equals(subComBudgetForecastDto.getOperationType())) {
                        subComBudgetForecastEntity.setDesignAmount(Optional.ofNullable(subComBudgetForecastEntity.getDesignAmount()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                        subComBudgetForecastEntity.setUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                        subComBudgetForecastEntity.setRemainderAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                        if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(subComBudgetForecastEntity.getFeeSourceCode()) || FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(subComBudgetForecastEntity.getFeeSourceCode())) {
                            if (UndertakeTypeEnum.PART_UNDERTAKE.getCode().equals(subComBudgetForecastDto.getUndertakingMode())) {
                                subComBudgetForecastEntity.setSurplusPartUndertakeAmt(Optional.ofNullable(subComBudgetForecastEntity.getSurplusPartUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                                subComBudgetForecastEntity.setPartAcceptUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getPartAcceptUsedAmount()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                            } else if (UndertakeTypeEnum.WHOLE_UNDERTAKE.getCode().equals(subComBudgetForecastDto.getUndertakingMode())) {
                                subComBudgetForecastEntity.setSurplusWholeUndertakeAmt(Optional.ofNullable(subComBudgetForecastEntity.getSurplusWholeUndertakeAmt()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                                subComBudgetForecastEntity.setFullAcceptUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getFullAcceptUsedAmount()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                            }
                        }
                    } else if (ForecastOperationTypeEnum.RETURN.getCode().equals(subComBudgetForecastDto.getOperationType())) {
                        subComBudgetForecastEntity.setDesignAmount(Optional.ofNullable(subComBudgetForecastEntity.getDesignAmount()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                        subComBudgetForecastEntity.setUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                        subComBudgetForecastEntity.setRemainderAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                        if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(subComBudgetForecastEntity.getFeeSourceCode()) || FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(subComBudgetForecastEntity.getFeeSourceCode())) {
                            if (UndertakeTypeEnum.PART_UNDERTAKE.getCode().equals(subComBudgetForecastDto.getUndertakingMode())) {
                                subComBudgetForecastEntity.setSurplusPartUndertakeAmt(Optional.ofNullable(subComBudgetForecastEntity.getSurplusPartUndertakeAmt()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                                subComBudgetForecastEntity.setPartAcceptUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getPartAcceptUsedAmount()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                            } else if (UndertakeTypeEnum.WHOLE_UNDERTAKE.getCode().equals(subComBudgetForecastDto.getUndertakingMode())) {
                                subComBudgetForecastEntity.setSurplusWholeUndertakeAmt(Optional.ofNullable(subComBudgetForecastEntity.getSurplusWholeUndertakeAmt()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                                subComBudgetForecastEntity.setFullAcceptUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getFullAcceptUsedAmount()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                            }
                        }
                    } else if (ForecastOperationTypeEnum.AUDIT_USE.getCode().equals(subComBudgetForecastDto.getOperationType()) || ForecastOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode().equals(subComBudgetForecastDto.getOperationType())) {
                        subComBudgetForecastEntity.setRemainderAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                        subComBudgetForecastEntity.setUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                    } else if (ForecastOperationTypeEnum.AUDIT_RETURN.getCode().equals(subComBudgetForecastDto.getOperationType()) || ForecastOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode().equals(subComBudgetForecastDto.getOperationType())) {
                        subComBudgetForecastEntity.setRemainderAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(subComBudgetForecastDto.getCurOperationAmount()));
                        subComBudgetForecastEntity.setUsedAmount(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO).subtract(subComBudgetForecastDto.getCurOperationAmount()));
                    } else {
                        throw new RuntimeException("\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b\uff01");
                    }
                    SubComBudgetForecastDetailEntity subComBudgetForecastDetailEntity = (SubComBudgetForecastDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
                    subComBudgetForecastDetailEntity.setId(null);
                    subComBudgetForecastDetailEntity.setBusinessCode(subComBudgetForecastDto.getBusinessCode());
                    subComBudgetForecastDetailEntity.setOperationType(subComBudgetForecastDto.getOperationType());
                    if (ForecastOperationTypeEnum.AUDIT_USE.getCode().equals(subComBudgetForecastDto.getOperationType())) {
                        subComBudgetForecastDetailEntity.setProcessNo(subComBudgetForecastDto.getProcessNo());
                    }
                    subComBudgetForecastDetailEntity.setCurOperationAmount(subComBudgetForecastDto.getCurOperationAmount());
                    subComBudgetForecastDetailEntity.setBeforeAmount(remainderAmount);
                    subComBudgetForecastDetailEntity.setBalanceAmount(subComBudgetForecastEntity.getRemainderAmount());
                    detailList.add(subComBudgetForecastDetailEntity);
                }
            }
        });
        this.subComBudgetForecastRepository.updateBatchById(subComBudgetForecastEntityList);
        if (!CollectionUtils.isEmpty((Collection)detailList)) {
            this.subComBudgetForecastDetailRepository.saveBatch(detailList);
        }
        if (!CollectionUtils.isEmpty(autoEntityList = subComBudgetForecastEntityList.stream().filter(item -> "auto".equals(item.getDataSourceCode())).collect(Collectors.toList()))) {
            Map<String, BigDecimal> bigMap = autoEntityList.stream().collect(Collectors.toMap(o -> o.getYearMonthLy() + o.getBusinessFormatCode() + o.getBusinessUnitCode() + o.getOrgCode() + o.getFeeSourceCode() + o.getBudgetItemCode(), SubComBudgetForecastEntity::getBudgetAmount));
            this.subComMonthBudgetService.updateSubComMonthBudgetByBudgetForecast(bigMap);
        }
    }

    public BigDecimal queryTaxAndAddition(SubComBudgetForecastVo subComBudgetForecastVo) {
        SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.queryTaxAndAddition(subComBudgetForecastVo);
        if (Objects.isNull((Object)subComBudgetForecastEntity)) {
            return BigDecimal.ZERO;
        }
        return this.subComAutoDetailRepository.queryTaxAndAddition(subComBudgetForecastEntity.getBudgetForecastCode());
    }

    public void clearByCode(List<String> budgetForecastCodeList) {
        if (CollectionUtils.isEmpty(budgetForecastCodeList)) {
            return;
        }
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.listByCodes(budgetForecastCodeList, null);
        if (CollectionUtils.isEmpty(subComBudgetForecastEntityList)) {
            return;
        }
        subComBudgetForecastEntityList.forEach(subComBudgetForecastEntity -> {
            subComBudgetForecastEntity.setApprovedAmount(BigDecimal.ZERO);
            subComBudgetForecastEntity.setRemainderAmount(BigDecimal.ZERO);
            subComBudgetForecastEntity.setUsedAmount(BigDecimal.ZERO);
        });
        this.clearAutoDetail(budgetForecastCodeList);
        this.subComBudgetForecastRepository.saveOrUpdateBatch(subComBudgetForecastEntityList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateBudgetForecastForActivityPlan(List<ActivityPlanItemDto> activityPlanItemList) {
        MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
        monthBudgetDto.setMonthBudgetCodeList(activityPlanItemList.stream().map(o -> o.getMonthBudgetCode() == null ? o.getHeadMonthBudgetCode() : o.getMonthBudgetCode()).collect(Collectors.toList()));
        List monthBudgetVoList = this.monthBudgetService.listByConditions(monthBudgetDto);
        HashMap activityDetailLinkBudgetItemCodeMap = new HashMap();
        for (ActivityPlanItemDto vo : activityPlanItemList) {
            Optional<MonthBudgetVo> budget = monthBudgetVoList.stream().filter(o -> o.getMonthBudgetCode().equals(vo.getMonthBudgetCode()) || o.getMonthBudgetCode().equals(vo.getHeadMonthBudgetCode())).findFirst();
            budget.ifPresent(monthBudgetVo -> activityDetailLinkBudgetItemCodeMap.put(vo.getPlanItemCode(), monthBudgetVo.getBudgetItemCode()));
        }
        Set budgetItemCodeSet = monthBudgetVoList.stream().map(MonthBudgetVo::getBudgetItemCode).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByMainBudgetItem(new ArrayList(budgetItemCodeSet));
        Map budgetItemMap = budgetItemVos.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getMainBudgetItemCode())).collect(Collectors.toMap(BudgetItemVo::getMainBudgetItemCode, Function.identity()));
        for (ActivityPlanItemDto itemDto : activityPlanItemList) {
            SubComOffPlanEntity entity = new SubComOffPlanEntity();
            entity.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            entity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            if (itemDto.getActivityBeginDate() != null) {
                entity.setYearMonthLy(DateUtil.format((Date)itemDto.getActivityBeginDate(), (String)"yyyy-MM"));
            } else {
                entity.setYearMonthLy(StringUtils.substring((String)itemDto.getActivityBeginDateStr(), (int)0, (int)7));
            }
            entity.setPlanCode(itemDto.getPlanCode());
            entity.setPlanName(itemDto.getPlanName());
            entity.setPlanItemCode(itemDto.getPlanItemCode());
            String budgetItemCode = (String)activityDetailLinkBudgetItemCodeMap.get(itemDto.getPlanItemCode());
            if (StringUtils.isNotEmpty((CharSequence)budgetItemCode)) {
                budgetItemMap.forEach((key, budgetItemVo) -> {
                    if (key.contains(budgetItemCode)) {
                        entity.setBudgetItemCode(budgetItemVo.getBudgetItemCode());
                        entity.setBudgetItemName(budgetItemVo.getBudgetItemName());
                    }
                });
            }
            entity.setAreaCode(itemDto.getActivityOrgCode());
            entity.setAreaName(itemDto.getActivityOrgName());
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            String orgCode = loginDetails.getOrgCode();
            List orgList = this.orgVoService.findAllParentByOrgCode(orgCode);
            List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(orgList.stream().map(OrgVo::getSalesOrgCode).collect(Collectors.toList()));
            Optional<SalesOrgVo> salesOrgVo = salesOrgVoList.stream().filter(o -> SalesOrgLevelTypeEnum.MECHANISM.getCode().equals(o.getSalesOrgLevel())).findFirst();
            if (salesOrgVo.isPresent() && !CollectionUtils.isEmpty((Collection)orgList)) {
                for (OrgVo orgVo : orgList) {
                    if (!salesOrgVo.get().getSalesOrgCode().equals(orgVo.getSalesOrgCode())) continue;
                    List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgVo.get().getErpCode());
                    if (CollectionUtils.isEmpty((Collection)salesOrgSubComOrgVos)) {
                        throw new UnsupportedOperationException("\u4e0d\u5b58\u5728\u5206\u5b50\u516c\u53f8\u5ba2\u6237\u4fe1\u606f");
                    }
                    List subComCustomerErpCodeList = salesOrgSubComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).collect(Collectors.toList());
                    List subCustomerList = this.customerVoService.findByErpCodeList(subComCustomerErpCodeList);
                    if (!CollectionUtils.isEmpty((Collection)subCustomerList)) {
                        entity.setOrgCode(orgVo.getOrgCode());
                        entity.setOrgName(orgVo.getOrgName());
                        entity.setCustomerCode(((CustomerVo)subCustomerList.get(0)).getCustomerCode());
                        entity.setCustomerName(((CustomerVo)subCustomerList.get(0)).getCustomerName());
                    }
                    break;
                }
            } else {
                throw new UnsupportedOperationException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u6240\u5728\u90e8\u95e8\u4e0a\u7ea7\u90e8\u95e8\u4fe1\u606f");
            }
            entity.setActivityFormCode(itemDto.getActivityFormCode());
            entity.setActivityFormName(itemDto.getActivityFormName());
            entity.setActivityTypeCode(itemDto.getActivityTypeCode());
            entity.setActivityTypeName(itemDto.getActivityTypeName());
            entity.setProductBrandCode(itemDto.getProductBrandCode());
            entity.setProductBrandName(itemDto.getProductBrandName());
            entity.setProductCategoryCode(itemDto.getProductCategoryCode());
            entity.setProductCategoryName(itemDto.getProductCategoryName());
            entity.setProductItemCode(itemDto.getProductItemCode());
            entity.setProductItemName(itemDto.getProductItemName());
            entity.setProductCode(itemDto.getProductCode());
            entity.setProductName(itemDto.getProductName());
            entity.setAuditExpressionName(itemDto.getAuditConditionName());
            entity.setAuditExpressionCode(itemDto.getAuditConditionCode());
            entity.setPlanAmount(new BigDecimal(itemDto.getPublicInputAmountStr()));
            SubComBudgetForecastEntity forecastEntity = this.subComBudgetForecastRepository.findForOffPlan(entity);
            if (forecastEntity == null) {
                forecastEntity = new SubComBudgetForecastEntity();
                forecastEntity.setYearMonthLy(entity.getYearMonthLy());
                forecastEntity.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                forecastEntity.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                forecastEntity.setYearMonthLy(entity.getYearMonthLy());
                forecastEntity.setOrgCode(entity.getOrgCode());
                forecastEntity.setOrgName(entity.getOrgName());
                forecastEntity.setBudgetItemCode(entity.getBudgetItemCode());
                forecastEntity.setBudgetItemName(entity.getBudgetItemName());
                forecastEntity.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
                forecastEntity.setBudgetForecastCode((String)this.generateCodeService.generateCode("YSYC", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS).get(0));
                forecastEntity.setTenantCode(TenantUtils.getTenantCode());
                forecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                forecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                forecastEntity.setBudgetAmount(new BigDecimal(itemDto.getPublicInputAmountStr()));
                forecastEntity.setDataSourceCode("auto");
            } else {
                forecastEntity.setBudgetAmount(forecastEntity.getBudgetAmount().add(new BigDecimal(itemDto.getPublicInputAmountStr())));
            }
            SubComActivityPlanItemAmountEntity planItemAmountEntity = new SubComActivityPlanItemAmountEntity();
            planItemAmountEntity.setActivityPlanItemCode(itemDto.getPlanCode());
            planItemAmountEntity.setPublicInputAmount(new BigDecimal(itemDto.getPublicInputAmountStr()));
            planItemAmountEntity.setTenantCode(TenantUtils.getTenantCode());
            planItemAmountEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            planItemAmountEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            this.subComBudgetForecastRepository.saveOrUpdate((Object)forecastEntity);
            entity.setBudgetForecastCode(forecastEntity.getBudgetForecastCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            this.subComOffPlanRepository.save((Object)entity);
            this.subComActivityPlanItemAmountRepository.save((Object)planItemAmountEntity);
        }
    }

    private void clearAutoDetail(List<String> budgetForecastCodeList) {
        List<SubComAutoDetailEntity> subComAutoDetailEntityList = this.subComAutoDetailRepository.listByForecastCodes(budgetForecastCodeList);
        subComAutoDetailEntityList.forEach(subComAutoDetailEntity -> subComAutoDetailEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.subComAutoDetailRepository.updateBatchById(subComAutoDetailEntityList);
    }

    private void buildInternalDetail(List<MonthBudgetVo> internalDetails, SubComBudgetForecastEntity subComBudgetForecastEntity) {
        ArrayList subComInternalDetailEntities = new ArrayList();
        internalDetails.forEach(internalDetail -> {
            SubComInternalDetailEntity subComInternalDetailEntity = (SubComInternalDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(internalDetail, SubComInternalDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            subComInternalDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            subComInternalDetailEntity.setTenantCode(TenantUtils.getTenantCode());
            subComInternalDetailEntity.setId(null);
            subComInternalDetailEntity.setBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
            subComInternalDetailEntity.setBudgetAmount(internalDetail.getAfterFreezeAmount());
            subComInternalDetailEntities.add(subComInternalDetailEntity);
        });
        this.subComInternalDetailRepository.delByBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
        log.info("\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5185\u8d39\u7528\uff0c\u751f\u6210\u6570\u636e\uff1a{}", (Object)subComInternalDetailEntities.size());
        this.subComInternalDetailRepository.saveBatch(subComInternalDetailEntities);
    }

    private void buildInternalInitDetail(SubComBudgetForecastEntity subComBudgetForecastEntity) {
        SubComBudgetForecastDetailEntity subComBudgetForecastDetailEntity = (SubComBudgetForecastDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        subComBudgetForecastDetailEntity.setId(null);
        subComBudgetForecastDetailEntity.setInitialAmount(subComBudgetForecastEntity.getBudgetAmount());
        subComBudgetForecastDetailEntity.setOperationType(ForecastOperationTypeEnum.INIT.getCode());
        subComBudgetForecastDetailEntity.setTenantCode(TenantUtils.getTenantCode());
        subComBudgetForecastDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.subComBudgetForecastDetailRepository.delByBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
        this.subComBudgetForecastDetailRepository.save((Object)subComBudgetForecastDetailEntity);
    }

    private void buildInitDetail(SubComBudgetForecastDto oldDto, SubComBudgetForecastEntity subComBudgetForecastEntity) {
        List<SubComBudgetForecastDetailEntity> detailList = this.subComBudgetForecastDetailRepository.listByForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
        List otherList = detailList.stream().filter(detail -> !ForecastOperationTypeEnum.INIT.getCode().equals(detail.getOperationType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(otherList)) {
            SubComBudgetForecastDetailEntity subComBudgetForecastDetailEntity = (SubComBudgetForecastDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            subComBudgetForecastDetailEntity.setId(null);
            subComBudgetForecastDetailEntity.setOperationType(ForecastOperationTypeEnum.INIT.getCode());
            subComBudgetForecastDetailEntity.setInitialAmount(subComBudgetForecastEntity.getBudgetAmount());
            if (!CollectionUtils.isEmpty(detailList)) {
                subComBudgetForecastDetailEntity.setId(detailList.get(0).getId());
            }
            subComBudgetForecastDetailEntity.setCurOperationAmount(subComBudgetForecastDetailEntity.getInitialAmount());
            subComBudgetForecastDetailEntity.setBeforeAmount(BigDecimal.ZERO);
            subComBudgetForecastDetailEntity.setBalanceAmount(subComBudgetForecastDetailEntity.getInitialAmount());
            this.subComBudgetForecastDetailRepository.saveOrUpdate((Object)subComBudgetForecastDetailEntity);
        } else {
            SubComBudgetForecastDetailEntity subComBudgetForecastDetailEntity = (SubComBudgetForecastDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            subComBudgetForecastDetailEntity.setId(null);
            subComBudgetForecastDetailEntity.setBeforeAmount(oldDto.getRemainderAmount());
            subComBudgetForecastDetailEntity.setInitialAmount(((SubComBudgetForecastDetailEntity)((Object)otherList.get(0))).getInitialAmount());
            subComBudgetForecastDetailEntity.setOperationType(ForecastOperationTypeEnum.CHANGE.getCode());
            subComBudgetForecastDetailEntity.setCurOperationAmount(subComBudgetForecastEntity.getRemainderAmount().subtract(oldDto.getRemainderAmount()));
            subComBudgetForecastDetailEntity.setBalanceAmount(subComBudgetForecastEntity.getRemainderAmount());
            this.subComBudgetForecastDetailRepository.save((Object)subComBudgetForecastDetailEntity);
        }
    }

    private void buildAutoDetail(SubComBudgetForecastEntity subComBudgetForecastEntity, SubComAutoDetailDto subComAutoDetailDto, List<ProfitGoalDiscountDto> profitGoalDiscountDtoList) {
        ArrayList subComAutoDetailEntityList = new ArrayList();
        Map<String, List<ProfitGoalDiscountDto>> typeMap = profitGoalDiscountDtoList.stream().collect(Collectors.groupingBy(ProfitGoalDiscountDto::getTypeCode));
        typeMap.forEach((typeCode, value) -> {
            if (BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(typeCode)) {
                Map<String, List<ProfitGoalDiscountDto>> valueBudgetItemMap = value.stream().collect(Collectors.groupingBy(ProfitGoalDiscountDto::getBudgetItemCode));
                valueBudgetItemMap.forEach((budgetItemCode, dtoList) -> {
                    SubComAutoDetailEntity subComAutoDetailEntity = new SubComAutoDetailEntity();
                    subComAutoDetailEntity.setTenantCode(TenantUtils.getTenantCode());
                    subComAutoDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    subComAutoDetailEntity.setBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
                    subComAutoDetailEntity.setBudgetAmountType(BudgetAmountTypeEnum.FIXED_PAY.getCode());
                    subComAutoDetailEntity.setBudgetAmountTypeName(BudgetAmountTypeEnum.FIXED_PAY.getDesc());
                    subComAutoDetailEntity.setBudgetItemCode((String)budgetItemCode);
                    subComAutoDetailEntity.setBudgetItemName(((ProfitGoalDiscountDto)dtoList.get(0)).getBudgetItemName());
                    subComAutoDetailEntity.setFeeAmount(dtoList.stream().map(ProfitGoalDiscountDto::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
                    subComAutoDetailEntityList.add(subComAutoDetailEntity);
                });
            }
        });
        List autoDetailAmountTypeList = AutoDetailAmountTypeEnum.concertEnumToList();
        autoDetailAmountTypeList.forEach(autoDetailAmountType -> {
            SubComAutoDetailEntity subComAutoDetailEntity = new SubComAutoDetailEntity();
            subComAutoDetailEntity.setBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
            subComAutoDetailEntity.setTenantCode(TenantUtils.getTenantCode());
            subComAutoDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            if (AutoDetailAmountTypeEnum.THEORY_INCOME.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.THEORY_INCOME.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.THEORY_INCOME.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getTheoryIncome());
            }
            if (AutoDetailAmountTypeEnum.THEORY_COST.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.THEORY_COST.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.THEORY_COST.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getTheoryCost());
            }
            if (AutoDetailAmountTypeEnum.THEORY_PROFIT.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.THEORY_PROFIT.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.THEORY_PROFIT.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getTheoryProfit());
            }
            if (AutoDetailAmountTypeEnum.FIXED_PAY_TOTAL.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.FIXED_PAY_TOTAL.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.FIXED_PAY_TOTAL.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getFixedPayTotal());
            }
            if (AutoDetailAmountTypeEnum.PROFIT_GOAL.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.PROFIT_GOAL.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.PROFIT_GOAL.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getProfitGoal());
            }
            if (AutoDetailAmountTypeEnum.ASSESS_DEDUCTION.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.ASSESS_DEDUCTION.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.ASSESS_DEDUCTION.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getAssessDeduction());
            }
            if (AutoDetailAmountTypeEnum.TAX_AMOUNT.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.TAX_AMOUNT.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.TAX_AMOUNT.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getTaxAmount());
            }
            if (AutoDetailAmountTypeEnum.AUTO_AMOUNT.getCode().equals(autoDetailAmountType)) {
                subComAutoDetailEntity.setBudgetAmountType(AutoDetailAmountTypeEnum.AUTO_AMOUNT.getCode());
                subComAutoDetailEntity.setBudgetAmountTypeName(AutoDetailAmountTypeEnum.AUTO_AMOUNT.getDesc());
                subComAutoDetailEntity.setFeeAmount(subComAutoDetailDto.getAutoAmount());
            }
            subComAutoDetailEntityList.add(subComAutoDetailEntity);
        });
        this.subComAutoDetailRepository.deleteByForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
        this.subComAutoDetailRepository.saveBatch(subComAutoDetailEntityList);
    }

    private SubComBudgetForecastEntity buildSubComBudgetForecast(List<ProfitGoalDiscountDto> profitGoalDiscountDtoList, SubComBudgetForecastEntity subComBudgetForecastEntity, SubComAutoDetailDto subComAutoDetailDto) {
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)subComBudgetForecastEntity))) {
            subComBudgetForecastEntity = (SubComBudgetForecastEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)profitGoalDiscountDtoList.get(0), SubComBudgetForecastEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            subComBudgetForecastEntity.setBudgetForecastCode((String)this.generateCodeService.generateCode("YSYC", 1, Integer.valueOf(8), 2L, TimeUnit.DAYS).get(0));
        }
        subComBudgetForecastEntity.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        subComBudgetForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        subComBudgetForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        subComBudgetForecastEntity.setBudgetItemCode(null);
        subComBudgetForecastEntity.setBudgetItemName(null);
        OrgVo orgVo = this.orgVoService.findByOrgCode(subComBudgetForecastEntity.getOrgCode());
        BigDecimal theoryIncome = BigDecimal.ZERO;
        BigDecimal theoryCost = BigDecimal.ZERO;
        List salesPlanVos = new ArrayList();
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)orgVo)) {
            SalesPlanDto salesPlanDto = new SalesPlanDto();
            salesPlanDto.setBusinessFormatCode(subComBudgetForecastEntity.getBusinessFormatCode());
            salesPlanDto.setBusinessUnitCode(subComBudgetForecastEntity.getBusinessUnitCode());
            String salesOrgCode = orgVo.getSalesOrgCode();
            SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(salesOrgCode);
            if (salesOrgVo != null) {
                salesPlanDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
            }
            salesPlanDto.setYearMonthLy(subComBudgetForecastEntity.getYearMonthLy());
            salesPlanDto.setSpecialDataStatus(ConfirmEunm.COMPLETETHECONFIRMATION.getCode());
            salesPlanVos = this.salesPlanService.listByConditions(salesPlanDto);
            if (!CollectionUtils.isEmpty(salesPlanVos)) {
                theoryIncome = salesPlanVos.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                theoryCost = salesPlanVos.stream().map(SalesPlanVo::getTheoryCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                subComAutoDetailDto.setTheoryIncome(theoryIncome);
                subComAutoDetailDto.setTheoryCost(theoryCost);
            }
        }
        BigDecimal theoryProfit = theoryIncome.subtract(theoryCost);
        subComAutoDetailDto.setTheoryProfit(theoryProfit);
        BigDecimal fixedPayTotal = profitGoalDiscountDtoList.stream().filter(dto -> BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(dto.getTypeCode())).map(ProfitGoalDiscountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        subComAutoDetailDto.setFixedPayTotal(fixedPayTotal);
        BigDecimal profitGoal = profitGoalDiscountDtoList.stream().filter(dto -> BudgetAmountTypeEnum.PROFIT_GOAL.getCode().equals(dto.getTypeCode())).map(ProfitGoalDiscountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        subComAutoDetailDto.setProfitGoal(profitGoal);
        BigDecimal assessDeduction = profitGoalDiscountDtoList.stream().filter(dto -> BudgetAmountTypeEnum.ASSESS_DEDUCTION.getCode().equals(dto.getTypeCode())).map(ProfitGoalDiscountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        subComAutoDetailDto.setAssessDeduction(assessDeduction);
        BigDecimal deliveryDiscountRatio = profitGoalDiscountDtoList.stream().filter(dto -> BudgetAmountTypeEnum.DISCOUNT_RATIO.getCode().equals(dto.getTypeCode())).filter(dto -> Objects.nonNull(dto.getDeliveryDiscountRatio())).map(ProfitGoalDiscountDto::getDeliveryDiscountRatio).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal purchaseDiscountRatio = profitGoalDiscountDtoList.stream().filter(dto -> BudgetAmountTypeEnum.DISCOUNT_RATIO.getCode().equals(dto.getTypeCode())).map(ProfitGoalDiscountDto::getPurchaseDiscountRatio).reduce(BigDecimal.ZERO, BigDecimal::add);
        AtomicReference<BigDecimal> taxAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        salesPlanVos.forEach(salesPlanVo -> {
            BigDecimal detailTheoryIncome = Optional.ofNullable(salesPlanVo.getTheoryIncome()).orElse(BigDecimal.ZERO);
            BigDecimal detailTheoryCost = Optional.ofNullable(salesPlanVo.getTheoryCost()).orElse(BigDecimal.ZERO);
            BigDecimal taxRatio = Optional.ofNullable(salesPlanVo.getTaxRate()).orElse(BigDecimal.ZERO);
            BigDecimal theoryIncomeTax = detailTheoryIncome.divide(BigDecimal.ONE.add(taxRatio), 4, RoundingMode.HALF_UP).multiply(taxRatio);
            BigDecimal theoryCostTax = detailTheoryCost.divide(BigDecimal.ONE.add(taxRatio), 4, RoundingMode.HALF_UP).multiply(taxRatio);
            BigDecimal deliveryDiscountTax = detailTheoryIncome.multiply(deliveryDiscountRatio).divide(BigDecimal.ONE.add(taxRatio), 4, RoundingMode.HALF_UP).multiply(taxRatio);
            BigDecimal purchaseDiscountTax = detailTheoryCost.multiply(purchaseDiscountRatio).divide(BigDecimal.ONE.add(taxRatio), 4, RoundingMode.HALF_UP).multiply(taxRatio);
            taxAmount.set(((BigDecimal)taxAmount.get()).add(Optional.ofNullable(salesPlanVo.getTaxesFee()).orElse(BigDecimal.ZERO)));
        });
        subComAutoDetailDto.setTaxAmount(taxAmount.get());
        BigDecimal autoAmount = theoryProfit.subtract(fixedPayTotal).subtract(profitGoal).subtract(assessDeduction).subtract(taxAmount.get());
        subComAutoDetailDto.setAutoAmount(autoAmount);
        subComBudgetForecastEntity.setBudgetAmount(autoAmount);
        subComBudgetForecastEntity.setFirstBudgetAmount(autoAmount);
        BigDecimal remainderAmount = Optional.ofNullable(subComBudgetForecastEntity.getFirstBudgetAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(subComBudgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(subComBudgetForecastEntity.getFreezeAmount()).orElse(BigDecimal.ZERO));
        subComBudgetForecastEntity.setRemainderAmount(remainderAmount);
        Map budgetConfigMap = this.dictToolkitService.findMapByDictTypeCode("tpm_auto_budget_config");
        subComBudgetForecastEntity.setBudgetItemCode((String)budgetConfigMap.get("code"));
        subComBudgetForecastEntity.setBudgetItemName((String)budgetConfigMap.get("name"));
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.findByOrgCode(subComBudgetForecastEntity.getOrgCode());
        if (!CollectionUtils.isEmpty((Collection)salesOrgSubComOrgVos)) {
            SalesOrgSubComOrgVo comOrgVo = (SalesOrgSubComOrgVo)salesOrgSubComOrgVos.get(0);
            subComBudgetForecastEntity.setSalesCompanyCode(comOrgVo.getSalesOrgCode());
            subComBudgetForecastEntity.setSalesCompanyName(comOrgVo.getSalesOrgName());
        }
        return subComBudgetForecastEntity;
    }

    private void buildOperationDetail(SubComBudgetForecastEntity subComBudgetForecastEntity, BigDecimal operationAmount, String operationType) {
    }

    public SubComBudgetForecastVo summationBudgetAmount(SubComBudgetForecastDto dto) {
        return this.subComBudgetForecastMapper.summationBudgetAmount(dto);
    }

    public void importSave(List<SubComBudgetForecastDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        List subComBudgetForecastEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(importList, SubComBudgetForecastDto.class, SubComBudgetForecastEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List codes = this.generateCodeService.generateCode("YSYC", subComBudgetForecastEntities.size(), Integer.valueOf(8), 2L, TimeUnit.DAYS);
        for (int i = 0; i < subComBudgetForecastEntities.size(); ++i) {
            SubComBudgetForecastEntity subComBudgetForecastEntity = (SubComBudgetForecastEntity)((Object)subComBudgetForecastEntities.get(i));
            subComBudgetForecastEntity.setDataSourceCode("manual");
            subComBudgetForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            subComBudgetForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            subComBudgetForecastEntity.setTenantCode(tenantCode);
            subComBudgetForecastEntity.setBudgetForecastCode((String)codes.get(i));
            if (BusinessFormatEnum.NORMAL.getCode().equals(subComBudgetForecastEntity.getBusinessFormatCode())) continue;
            subComBudgetForecastEntity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        }
        this.subComBudgetForecastRepository.saveBatch(subComBudgetForecastEntities);
    }

    public void releaseAmount(SubComBudgetForecastDto forecastDto, BigDecimal returnAutoAmount, BigDecimal returnInternalAmount, BigDecimal returnOffAmount) {
        SubComBudgetForecastEntity entity = this.subComBudgetForecastRepository.findBySubComBudgetForecastDto(forecastDto);
        Assert.notNull((Object)((Object)entity), (String)"\u672a\u67e5\u8be2\u5230\u5206\u5b50\u9884\u7b97\u9884\u6d4b");
        BigDecimal amount = BigDecimal.ZERO;
        String feeSourceCode = forecastDto.getFeeSourceCode();
        if (FeeSourceEnum.AUTO_FEE.getCode().equals(feeSourceCode)) {
            amount = returnAutoAmount;
        } else if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(feeSourceCode)) {
            amount = returnOffAmount;
        } else if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(feeSourceCode)) {
            amount = returnInternalAmount;
        } else {
            throw new IllegalArgumentException("\u8d39\u7528\u7c7b\u578b\u9519\u8bef");
        }
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        entity.setUsedAmount(entity.getUsedAmount().subtract(amount));
        entity.setRemainderAmount(entity.getRemainderAmount().add(amount));
        this.subComBudgetForecastRepository.updateById((Object)entity);
        SubComBudgetForecastDetailEntity detailEntity = new SubComBudgetForecastDetailEntity();
        detailEntity.setBudgetForecastCode(entity.getBudgetForecastCode());
        detailEntity.setTenantCode(TenantUtils.getTenantCode());
        detailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailEntity.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
        detailEntity.setBusinessFormatCode(entity.getBusinessFormatCode());
        detailEntity.setBusinessUnitCode(entity.getBusinessUnitCode());
        detailEntity.setBudgetItemCode(entity.getBudgetItemCode());
        detailEntity.setBudgetItemName(entity.getBudgetItemName());
        detailEntity.setInitialAmount(entity.getBudgetAmount());
        detailEntity.setBalanceAmount(entity.getRemainderAmount().subtract(amount));
        detailEntity.setBeforeAmount(entity.getRemainderAmount());
        detailEntity.setCurOperationAmount(amount);
        detailEntity.setOrgCode(entity.getOrgCode());
        detailEntity.setOrgName(entity.getOrgName());
        this.subComBudgetForecastDetailRepository.save((Object)detailEntity);
    }

    public List<SubComBudgetForecastVo> findListByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        return this.subComBudgetForecastMapper.findListByCodes(codes);
    }

    public List<SubComBudgetForecastVo> findListByBudgetItemCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        return this.subComBudgetForecastMapper.findListByBudgetItemCodes(codes, TenantUtils.getTenantCode());
    }

    public void changeUndertakeAmt(SubComBudgetForecastDto dto, BigDecimal wholeUndertakeAmt, BigDecimal partUndertakeAmt) {
        Validate.notNull((Object)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBudgetItemCode(), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SubComBudgetForecastEntity entity = (SubComBudgetForecastEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.subComBudgetForecastRepository.lambdaQuery().eq(SubComBudgetForecastEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(SubComBudgetForecastEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(SubComBudgetForecastEntity::getYearMonthLy, (Object)dto.getYearMonthLy())).eq(SubComBudgetForecastEntity::getOrgCode, (Object)dto.getOrgCode())).eq(SubComBudgetForecastEntity::getBudgetItemCode, (Object)dto.getBudgetItemCode())).one());
        if (entity == null) {
            throw new UnsupportedOperationException("\u672a\u67e5\u8be2\u5230\u9884\u7b97\u9884\u6d4b\u6570\u636e");
        }
        entity.setSurplusWholeUndertakeAmt(entity.getSurplusWholeUndertakeAmt().add(wholeUndertakeAmt));
        entity.setSurplusPartUndertakeAmt(entity.getSurplusPartUndertakeAmt().add(partUndertakeAmt));
        this.subComBudgetForecastRepository.saveOrUpdate((Object)entity);
    }

    public SubComBudgetForecastVo findById(String id) {
        Validate.notNull((Object)id, (String)"\u53c2\u6570ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SubComBudgetForecastEntity entity = this.subComBudgetForecastRepository.getById(id);
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (SubComBudgetForecastVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, SubComBudgetForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(List<String> budgetForecastCodes, TimeUnit timeUnit, int time) {
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)timeUnit))) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (time <= 0) {
            time = 1200;
        }
        boolean isLock = true;
        ArrayList<String> successKeys = new ArrayList<String>();
        try {
            for (String budgetForecastCode : budgetForecastCodes) {
                isLock = this.redisLockService.tryLock("sub_com_budget_forecast_lock:lock:" + budgetForecastCode, timeUnit, (long)time);
                if (!isLock) {
                    boolean bl = false;
                    return bl;
                }
                successKeys.add(budgetForecastCode);
            }
        }
        finally {
            if (!isLock && !CollectionUtils.isEmpty(successKeys)) {
                successKeys.forEach(key -> this.redisLockService.unlock("sub_com_budget_forecast_lock:lock:" + key));
            }
        }
        return true;
    }

    public void unLock(List<String> budgetForecastCodes) {
        if (CollectionUtils.isEmpty(budgetForecastCodes)) {
            throw new RuntimeException("\u9884\u7b97\u9884\u6d4b\u89e3\u9501\u5931\u8d25\uff0c\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        budgetForecastCodes.forEach(budgetForecastCode -> this.redisLockService.unlock("sub_com_budget_forecast_lock:lock:" + budgetForecastCode));
    }

    public void adjust(SubComBudgetForecastAdjustDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getAdjustOutBudgetCode(), (String)"\u8c03\u51fa\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAdjustOutAmount(), (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getAdjustOutAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getAdjustInBudgetCode(), (String)"\u8c03\u5165\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness(), (String)"\u5ba1\u6279\u6d41\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessKey(), (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessTitle(), (String)"\u6d41\u7a0b\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity adjustInEntity = this.subComBudgetForecastRepository.getByCode(dto.getAdjustInBudgetCode());
        Validate.notNull((Object)((Object)adjustInEntity), (String)"\u8c03\u6574\u5931\u8d25\uff0c\u8c03\u5165\u65b9\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity adjustOutEntity = this.subComBudgetForecastRepository.getByCode(dto.getAdjustOutBudgetCode());
        Validate.notNull((Object)((Object)adjustOutEntity), (String)"\u8c03\u6574\u5931\u8d25\uff0c\u8c03\u51fa\u65b9\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)adjustInEntity.getOrgCode(), (String)"\u8c03\u5165\u65b9\u7ec4\u7ec7\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)adjustOutEntity.getOrgCode(), (String)"\u8c03\u51fa\u65b9\u7ec4\u7ec7\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)adjustInEntity.getOrgCode(), (CharSequence)adjustOutEntity.getOrgCode()), (String)"\u8c03\u5165\u8c03\u51fa\u65b9\u7ec4\u7ec7\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        if (Optional.ofNullable(adjustOutEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getAdjustOutAmount()) < 0) {
            throw new RuntimeException("\u9884\u7b97\u9884\u6d4b[" + dto.getAdjustOutBudgetCode() + "]\u7684\u8c03\u51fa\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u53ef\u7528\u4f59\u989d");
        }
        adjustOutEntity.setAdjustAmount(Optional.ofNullable(adjustOutEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
        adjustOutEntity.setApprovingAmount(Optional.ofNullable(adjustOutEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
        adjustOutEntity.setAfterFreezeAmount(Optional.ofNullable(adjustOutEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
        adjustOutEntity.setRemainderAmount(Optional.ofNullable(adjustOutEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(dto.getAdjustOutAmount()));
        adjustInEntity.setApprovingAmount(Optional.ofNullable(adjustInEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getAdjustOutAmount()));
        this.subComBudgetForecastRepository.updateById((Object)adjustOutEntity);
        this.subComBudgetForecastRepository.updateById((Object)adjustInEntity);
        String processNo = this.adjustSubmit(dto);
        SubComBudgetForecastDetailDto adjustOutDetailDto = this.buildDetail(adjustOutEntity, dto.getAdjustOutAmount(), BudgetOperationTypeEnum.ADJUST_OUT.getCode());
        adjustOutDetailDto.setProcessNo(processNo);
        adjustOutDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        adjustOutDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.subComBudgetForecastDetailService.create(adjustOutDetailDto);
        SubComBudgetForecastDetailDto adjustInDetailDto = this.buildDetail(adjustInEntity, dto.getAdjustOutAmount(), BudgetOperationTypeEnum.ADJUST_IN.getCode());
        adjustInDetailDto.setProcessNo(processNo);
        adjustInDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        adjustInDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        this.subComBudgetForecastDetailService.create(adjustInDetailDto);
    }

    public String adjustSubmit(SubComBudgetForecastAdjustDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("adjust_sub_com_budget_forecast");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull((Object)processBusinessVo, (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processBusinessVo.getProcessNo(), (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        return processBusinessVo.getProcessNo();
    }

    private SubComBudgetForecastDetailDto buildDetail(SubComBudgetForecastEntity subComBudgetForecast, BigDecimal operationAmount, String operationType) {
        SubComBudgetForecastDetailDto detailDto = (SubComBudgetForecastDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecast, SubComBudgetForecastDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        operationAmount = Objects.isNull(operationAmount) ? BigDecimal.ZERO : operationAmount;
        detailDto.setId(null);
        detailDto.setOperationType(operationType);
        detailDto.setInitialAmount(subComBudgetForecast.getFirstBudgetAmount());
        detailDto.setBalanceAmount(subComBudgetForecast.getRemainderAmount());
        if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(operationType) || BudgetOperationTypeEnum.RETURN.getCode().equals(operationType) || BudgetOperationTypeEnum.REPLAY.getCode().equals(operationType) || BudgetOperationTypeEnum.PLAN.getCode().equals(operationType) || BudgetOperationTypeEnum.ACTUAL_SALES.getCode().equals(operationType)) {
            detailDto.setBeforeAmount(Optional.ofNullable(subComBudgetForecast.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(operationAmount));
        } else if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(operationType) || BudgetOperationTypeEnum.FORECAST_OVER.getCode().equals(operationType) || BudgetOperationTypeEnum.SUBTRACT.getCode().equals(operationType) || BudgetOperationTypeEnum.FREEZE.getCode().equals(operationType) || BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
            detailDto.setBeforeAmount(Optional.ofNullable(subComBudgetForecast.getRemainderAmount()).orElse(BigDecimal.ZERO).add(operationAmount));
        } else if (BudgetOperationTypeEnum.ADD.getCode().equals(operationType) || BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(operationType)) {
            detailDto.setBeforeAmount(Optional.ofNullable(subComBudgetForecast.getRemainderAmount()).orElse(BigDecimal.ZERO));
        }
        detailDto.setCurOperationAmount(operationAmount);
        return detailDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unOrFreeze(SubComBudgetForecastOperateDto dto, String operationType) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setOperationType(operationType);
        Validate.notBlank((CharSequence)dto.getBudgetForecastCode(), (String)"\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)BudgetOperationTypeEnum.freezeMap().containsKey(dto.getOperationType()), (String)"\u64cd\u4f5c\u7c7b\u578b\u53ea\u80fd\u662f\u51bb\u7ed3\u3001\u89e3\u51bb\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperationAmount(), (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        boolean lockFlag = true;
        try {
            lockFlag = this.redisLockService.tryLock("sub_com_budget_forecast_lock:lock:" + dto.getBudgetForecastCode(), TimeUnit.MINUTES, 10L);
            Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u9884\u7b97\u9884\u6d4b\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.getByCode(dto.getBudgetForecastCode());
            Validate.notNull((Object)((Object)subComBudgetForecastEntity), (String)"\u5f53\u524d\u9884\u7b97\u9884\u6d4b\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9884\u7b97\u53ef\u7528\u91d1\u989d\uff01", (Object[])new Object[0]);
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(subComBudgetForecastEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)"\u89e3\u51bb\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u51bb\u7ed3\u91d1\u989d\uff01", (Object[])new Object[0]);
            }
            if (BudgetOperationTypeEnum.FREEZE.getCode().equals(dto.getOperationType())) {
                subComBudgetForecastEntity.setFreezeAmount(Optional.ofNullable(subComBudgetForecastEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                subComBudgetForecastEntity.setAfterFreezeAmount(Optional.ofNullable(subComBudgetForecastEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComBudgetForecastEntity.setRemainderAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
            }
            if (BudgetOperationTypeEnum.UNFREEZE.getCode().equals(dto.getOperationType())) {
                subComBudgetForecastEntity.setFreezeAmount(Optional.ofNullable(subComBudgetForecastEntity.getFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComBudgetForecastEntity.setAfterFreezeAmount(Optional.ofNullable(subComBudgetForecastEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                subComBudgetForecastEntity.setRemainderAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
            }
            this.subComBudgetForecastRepository.saveOrUpdate((Object)subComBudgetForecastEntity);
            SubComBudgetForecastDetailDto detailDto = this.buildDetail(subComBudgetForecastEntity, dto.getOperationAmount(), dto.getOperationType());
            this.subComBudgetForecastDetailService.create(detailDto);
        }
        finally {
            if (lockFlag) {
                this.redisLockService.unlock("sub_com_budget_forecast_lock:lock:" + dto.getBudgetForecastCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(SubComBudgetForecastOperateDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBudgetForecastCode(), (String)"\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperationType(), (String)"\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)BudgetOperationTypeEnum.changeMap().containsKey(dto.getOperationType()), (String)"\u53d8\u66f4\u7c7b\u578b\u53ea\u80fd\u662f\u8ffd\u52a0\u3001\u524a\u51cf\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperationAmount(), (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getOperationAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness(), (String)"\u5ba1\u6279\u6d41\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessKey(), (String)"\u6d41\u7a0bkey\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness().getProcessTitle(), (String)"\u6d41\u7a0b\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getOperationRemarks()) && dto.getOperationRemarks().length() > 600) {
            throw new IllegalArgumentException("\u8bf7\u586b\u5199\u7b80\u77ed\u8bf4\u660e,\u4e0d\u80fd\u5927\u4e8e600\u5b57\u7b26\uff01");
        }
        boolean lockFlag = true;
        try {
            lockFlag = this.redisLockService.tryLock("sub_com_budget_forecast_lock:lock:" + dto.getBudgetForecastCode(), TimeUnit.MINUTES, 10L);
            Validate.isTrue((boolean)lockFlag, (String)"\u5f53\u524d\u9884\u7b97\u9884\u6d4b\u6b63\u5728\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
            SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.getByCode(dto.getBudgetForecastCode());
            Validate.notNull((Object)((Object)subComBudgetForecastEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                Validate.isTrue((Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).compareTo(dto.getOperationAmount()) >= 0 ? 1 : 0) != 0, (String)"\u524a\u51cf\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9884\u7b97\u53ef\u7528\u91d1\u989d", (Object[])new Object[0]);
            }
            BigDecimal balanceAmount = BigDecimal.ZERO;
            if (BudgetOperationTypeEnum.ADD.getCode().equals(dto.getOperationType())) {
                subComBudgetForecastEntity.setApprovingAmount(Optional.ofNullable(subComBudgetForecastEntity.getApprovingAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount()));
                balanceAmount = Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).add(dto.getOperationAmount());
            }
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                subComBudgetForecastEntity.setAdjustAmount(Optional.ofNullable(subComBudgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComBudgetForecastEntity.setApprovingAmount(Optional.ofNullable(subComBudgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComBudgetForecastEntity.setAfterFreezeAmount(Optional.ofNullable(subComBudgetForecastEntity.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                subComBudgetForecastEntity.setRemainderAmount(Optional.ofNullable(subComBudgetForecastEntity.getRemainderAmount()).orElse(BigDecimal.ZERO).subtract(dto.getOperationAmount()));
                balanceAmount = subComBudgetForecastEntity.getRemainderAmount();
            }
            this.subComBudgetForecastRepository.saveOrUpdate((Object)subComBudgetForecastEntity);
            SubComBudgetForecastDetailDto changeDetailDto = this.buildDetail(subComBudgetForecastEntity, dto.getOperationAmount(), dto.getOperationType());
            if (BudgetOperationTypeEnum.SUBTRACT.getCode().equals(dto.getOperationType())) {
                changeDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            } else {
                changeDetailDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            }
            changeDetailDto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            changeDetailDto.setBalanceAmount(balanceAmount);
            changeDetailDto.setRemark(dto.getOperationRemarks());
            SubComBudgetForecastDetailEntity entity = this.subComBudgetForecastDetailService.create(changeDetailDto);
            String processNo = this.changeSubmit(dto);
            this.subComBudgetForecastDetailService.updateProcessNoById(entity.getId(), processNo);
        }
        finally {
            if (lockFlag) {
                this.redisLockService.unlock("sub_com_budget_forecast_lock:lock:" + dto.getBudgetForecastCode());
            }
        }
    }

    public String changeSubmit(SubComBudgetForecastOperateDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("change_sub_com_budget_forecast");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull((Object)processBusinessVo, (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)processBusinessVo.getProcessNo(), (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        return processBusinessVo.getProcessNo();
    }

    public List<SubComBudgetForecastVo> findListByConditions(SubComBudgetForecastDto subComBudgetForecastDto) {
        if (Objects.isNull(subComBudgetForecastDto)) {
            return Lists.newArrayList();
        }
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.findListByConditions(subComBudgetForecastDto);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(subComBudgetForecastEntityList, SubComBudgetForecastEntity.class, SubComBudgetForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<SubComBudgetForecastVo> listByBudgetForecastCodeList(List<String> budgetForecastCodeList) {
        if (CollectionUtils.isEmpty(budgetForecastCodeList)) {
            return Lists.newArrayList();
        }
        List<SubComBudgetForecastEntity> subComBudgetForecastEntityList = this.subComBudgetForecastRepository.listByCodes(budgetForecastCodeList, EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isEmpty(subComBudgetForecastEntityList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(subComBudgetForecastEntityList, SubComBudgetForecastEntity.class, SubComBudgetForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public SubComBudgetForecastMainAdjustVo adjustQuery(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComBudgetForecastDetailEntity> subComMonthBudgetDetailEntityList = this.subComBudgetForecastDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComMonthBudgetDetailEntityList)) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5bf9\u5e94\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u8c03\u6574\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        SubComBudgetForecastMainAdjustVo mainAdjustVo = new SubComBudgetForecastMainAdjustVo();
        subComMonthBudgetDetailEntityList.forEach(detailEntity -> {
            SubComBudgetForecastEntity forecastEntity = this.subComBudgetForecastRepository.getByCode(detailEntity.getBudgetForecastCode());
            SubComBudgetForecastAdjustVo adjustVo = (SubComBudgetForecastAdjustVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)forecastEntity, SubComBudgetForecastAdjustVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            if (BudgetOperationTypeEnum.ADJUST_IN.getCode().equals(detailEntity.getOperationType())) {
                adjustVo.setBalanceBeforeAdjustAmount(detailEntity.getBeforeAmount());
                adjustVo.setAdjustAmount(detailEntity.getCurOperationAmount());
                adjustVo.setBalanceBehindAdjustAmount(detailEntity.getBalanceAmount());
                mainAdjustVo.setAdjustInVo(adjustVo);
            }
            if (BudgetOperationTypeEnum.ADJUST_OUT.getCode().equals(detailEntity.getOperationType())) {
                adjustVo.setBalanceBeforeAdjustAmount(detailEntity.getBeforeAmount());
                adjustVo.setAdjustAmount(detailEntity.getCurOperationAmount());
                adjustVo.setBalanceBehindAdjustAmount(detailEntity.getBalanceAmount());
                mainAdjustVo.setAdjustOutVo(adjustVo);
            }
        });
        return mainAdjustVo;
    }

    public SubComBudgetForecastChangeVo changeQuery(String processNo) {
        Validate.notEmpty((CharSequence)processNo, (String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComBudgetForecastDetailEntity> subComMonthBudgetDetailEntityList = this.subComBudgetForecastDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(subComMonthBudgetDetailEntityList)) {
            throw new RuntimeException("\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u5bf9\u5e94\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u53d8\u66f4\u660e\u7ec6\u4e0d\u5b58\u5728\uff01");
        }
        SubComBudgetForecastChangeVo mainAdjustVo = new SubComBudgetForecastChangeVo();
        SubComBudgetForecastDetailEntity detailEntity = subComMonthBudgetDetailEntityList.get(0);
        SubComBudgetForecastEntity forecastEntity = this.subComBudgetForecastRepository.getByCode(detailEntity.getBudgetForecastCode());
        SubComBudgetForecastChangeVo changeVo = (SubComBudgetForecastChangeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)forecastEntity, SubComBudgetForecastChangeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        changeVo.setOperationAmount(detailEntity.getCurOperationAmount());
        changeVo.setOperationType(detailEntity.getOperationType());
        changeVo.setOperationRemarks(detailEntity.getRemark());
        changeVo.setBehindOperationAmount(detailEntity.getBalanceAmount());
        return changeVo;
    }

    public List<SubComBudgetForecastVo> listByOnlyKeys(List<String> onlyKeys) {
        if (CollectionUtils.isEmpty(onlyKeys)) {
            return Lists.newArrayList();
        }
        List<SubComBudgetForecastVo> list = this.subComBudgetForecastRepository.listByOnlyKeys(onlyKeys);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public void submitApproval(SubComBudgetApprovalDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getId()), (String)"\u63d0\u4ea4\u5ba1\u6279\u6d41\u7684id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SubComBudgetForecastEntity forecastEntity = this.subComBudgetForecastRepository.getById(dto.getId());
        Validate.notNull((Object)((Object)forecastEntity), (String)"\u672a\u627e\u5230id\u4e3a\u3010%s\u3011\u7684\u9884\u7b97\u9884\u6d4b\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)forecastEntity.getDataSourceCode()) && !BusinessFormatEnum.NORMAL.getCode().equals(forecastEntity.getBusinessFormatCode()) && "manual".equals(forecastEntity.getDataSourceCode()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u624b\u52a8\u65b0\u589e\u7684\u4e1a\u6001\u4e0d\u4e3a\u5e38\u6e29\u7684\u9884\u7b97\u9884\u6d4b\u624d\u80fd\u8fdb\u884c\u5ba1\u6279", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)forecastEntity.getProcessStatus()) && (ProcessStatusEnum.PREPARE.getDictCode().equals(forecastEntity.getProcessStatus()) || ProcessStatusEnum.REJECT.getDictCode().equals(forecastEntity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getDictCode().equals(forecastEntity.getProcessStatus())) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u63d0\u4ea4\u5904\u4e8e\u9a73\u56de\uff0c\u8ffd\u56de\uff0c\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u9884\u7b97\u9884\u6d4b", (Object[])new Object[0]);
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("manual_sub_com_budget_forecast");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        Validate.notNull((Object)processBusinessVo, (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processBusinessVo.getProcessNo(), (String)"\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity forecastEntity1 = new SubComBudgetForecastEntity();
        forecastEntity1.setId(forecastEntity.getId());
        forecastEntity1.setProcessNo(processBusinessVo.getProcessNo());
        forecastEntity1.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        this.subComBudgetForecastRepository.updateById((Object)forecastEntity1);
    }

    public List<SubComBudgetForecastVo> findListByUniqueKeys(List<String> uniqueKeys) {
        return this.subComBudgetForecastRepository.findListByUniqueKeys(uniqueKeys);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<SubComBudgetForecastEntity> entities = this.subComBudgetForecastRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        for (SubComBudgetForecastEntity en2 : entities) {
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)en2.getDataSourceCode()) && "manual".equals(en2.getDataSourceCode()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u624b\u52a8\u65b0\u589e\u7684\u9884\u7b97\u9884\u6d4b\u624d\u80fd\u5220\u9664\uff0c\u9884\u7b97\u7f16\u7801\u3010%s\u3011", (Object[])new Object[]{en2.getBudgetForecastCode()});
            Validate.isTrue((StringUtils.isBlank((CharSequence)en2.getProcessStatus()) || !ProcessStatusEnum.PASS.getDictCode().equals(en2.getProcessStatus()) ? 1 : 0) != 0, (String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5ba1\u6279\u901a\u8fc7\u7684\u9884\u7b97\u9884\u6d4b\uff0c\u9884\u7b97\u7f16\u7801\u3010%s\u3011", (Object[])new Object[]{en2.getBudgetForecastCode()});
            en2.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        }
        this.subComBudgetForecastRepository.updateBatchById(entities);
        entities.forEach(en -> {
            SubComBudgetForecastLogEventDto logEventDto = new SubComBudgetForecastLogEventDto();
            logEventDto.setOriginal((SubComBudgetForecastDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)en, SubComBudgetForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = SubComBudgetForecastLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SubComBudgetForecastLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }

    public SubComBudgetForecastProcessVo findChangeDetailByProcessNo(String processNo) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return null;
        }
        List<SubComBudgetForecastDetailEntity> detailList = this.subComBudgetForecastDetailRepository.listByProcessNo(processNo);
        if (CollectionUtils.isEmpty(detailList)) {
            return null;
        }
        SubComBudgetForecastDetailEntity detail = detailList.get(0);
        SubComBudgetForecastProcessVo processVo = new SubComBudgetForecastProcessVo();
        processVo.setBudgetForecastCode(detail.getBudgetForecastCode());
        processVo.setOperationAmount(detail.getCurOperationAmount());
        processVo.setOperationType(detail.getOperationType());
        processVo.setOperationRemarks(detail.getRemark());
        processVo.setBalanceAmount(detail.getBalanceAmount());
        SubComBudgetForecastEntity entity = this.subComBudgetForecastRepository.getByCode(detail.getBudgetForecastCode());
        if (null != entity) {
            SubComBudgetForecastVo forecastVo = (SubComBudgetForecastVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, SubComBudgetForecastVo.class, HashSet.class, ArrayList.class, new String[0]);
            processVo.setForecastVo(forecastVo);
        }
        return processVo;
    }

    public List<SubComBudgetForecastVo> findByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return Lists.newArrayList();
        }
        List<SubComBudgetForecastEntity> entities = this.subComBudgetForecastRepository.findByBudgetItemCodes(budgetItemCodes);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SubComBudgetForecastEntity.class, SubComBudgetForecastVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void updateForecastRemainderAmount(String id, BigDecimal amount) {
        if (StringUtils.isEmpty((CharSequence)id) || Objects.isNull(amount)) {
            return;
        }
        this.subComBudgetForecastRepository.updateForecastRemainderAmount(id, amount);
    }

    public Page<SubComBudgetForecastVo> findSubBudgetForecastByConditions(Pageable pageable, SubComBudgetForecastDto selectDto) {
        Page<SubComBudgetForecastVo> resultPage = this.findByConditions(pageable, selectDto);
        if (Objects.isNull(resultPage)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        return resultPage;
    }

    public List<String> excessPrompt(Integer excessPromptTotal) {
        ArrayList<String> result = new ArrayList<String>();
        if ((excessPromptTotal = Optional.ofNullable(excessPromptTotal).orElse(10)) <= 0) {
            excessPromptTotal = 10;
        }
        Date curDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        calendar.add(2, -1);
        String curYearMonth = DateUtil.format((Date)curDate, (String)"yyyy-MM");
        String lastYearMonth = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM");
        ArrayList<String> yearMonthList = new ArrayList<String>();
        yearMonthList.add(curYearMonth);
        yearMonthList.add(lastYearMonth);
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setYearMonthList(yearMonthList);
        subComBudgetForecastDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        subComBudgetForecastDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        subComBudgetForecastDto.setTenantCode(TenantUtils.getTenantCode());
        log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u67e5\u8be2\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)subComBudgetForecastDto));
        PageRequest page = PageRequest.of((int)1, (int)50);
        Page<SubComBudgetForecastVo> budgetForecastVoPage = this.findByConditions((Pageable)page, subComBudgetForecastDto);
        Optional<Long> total = Optional.ofNullable(budgetForecastVoPage).map(Page::getTotal);
        int curTotal = excessPromptTotal;
        List<String> messages = null;
        if (total.isPresent()) {
            log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u603b\u6761\u6570:(),\u5f53\u524d\u9875:{}", (Object)total.get(), (Object)budgetForecastVoPage.getCurrent());
            List subComBudgetList = budgetForecastVoPage.getRecords();
            messages = this.findExcessPrompt(subComBudgetList, curTotal);
            if (!CollectionUtils.isEmpty(messages)) {
                result.addAll(messages);
            }
            log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u5f53\u524d\u627e\u5230\u63d0\u793a\u6761\u6570:{}", (Object)result.size());
            if (result.size() == excessPromptTotal.intValue()) {
                return result;
            }
            curTotal = excessPromptTotal - result.size();
            while (budgetForecastVoPage.hasNext()) {
                page = page.next();
                budgetForecastVoPage = this.findByConditions((Pageable)page, subComBudgetForecastDto);
                log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u603b\u6761\u6570:(),\u5f53\u524d\u9875:{}", (Object)total.get(), (Object)budgetForecastVoPage.getCurrent());
                messages = this.findExcessPrompt(budgetForecastVoPage.getRecords(), curTotal);
                if (!CollectionUtils.isEmpty(messages)) {
                    result.addAll(messages);
                }
                log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u5f53\u524d\u627e\u5230\u63d0\u793a\u6761\u6570:{}", (Object)result.size());
                if (result.size() == excessPromptTotal.intValue()) {
                    return result;
                }
                curTotal = excessPromptTotal - result.size();
            }
        }
        return result;
    }

    private List<String> findExcessPrompt(List<SubComBudgetForecastVo> subComBudgetForecastList, int excessPromptTotal) {
        if (CollectionUtils.isEmpty(subComBudgetForecastList)) {
            return Lists.newArrayList();
        }
        ArrayList<String> massages = new ArrayList<String>();
        Map<String, List<SubComBudgetForecastVo>> subComBudgetForecastMap = subComBudgetForecastList.stream().collect(Collectors.groupingBy(f -> f.getBusinessFormatCode() + f.getBusinessUnitCode() + f.getYearLy() + f.getOrgCode()));
        for (String key : subComBudgetForecastMap.keySet()) {
            log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u67e5\u8be2\u5e74\u5ea6\u9884\u7b97,\u68c0\u6d4b\u8d85\u989d,\u3010\u4e1a\u6001\u3001\u4e1a\u52a1\u5355\u5143\u3001\u5e74\u3001\u7ec4\u7ec7\u7f16\u7801\u3011:{}", (Object)key);
            List<SubComBudgetForecastVo> voList = subComBudgetForecastMap.get(key);
            if (CollectionUtils.isEmpty(voList)) continue;
            SubComBudgetForecastVo budgetForecastVo = voList.get(0);
            TpmSubsidiaryYearBudgetDto selectDto = new TpmSubsidiaryYearBudgetDto();
            selectDto.setBusinessFormatCode(budgetForecastVo.getBusinessFormatCode());
            selectDto.setBusinessUnitCode(budgetForecastVo.getBusinessUnitCode());
            selectDto.setYearLy(budgetForecastVo.getYearLy());
            selectDto.setOrgCode(budgetForecastVo.getOrgCode());
            selectDto.setBudgetDetailType(TpmSubsidiaryYearBudgetDetailTypeEnum.AUTOMATIC.getCode());
            log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u67e5\u8be2\u5e74\u5ea6\u9884\u7b97,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)selectDto));
            List yearBudgetVoList = this.tpmSubsidiaryYearBudgetService.findByConditionsForSubAuto(selectDto);
            if (CollectionUtils.isEmpty((Collection)yearBudgetVoList)) {
                log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u67e5\u8be2\u5e74\u5ea6\u9884\u7b97,\u68c0\u6d4b\u8d85\u989d,\u3010\u4e1a\u6001\u3001\u4e1a\u52a1\u5355\u5143\u3001\u5e74\u3001\u7ec4\u7ec7\u7f16\u7801\u3011:{},====> \u65e0\u5bf9\u5e94\u5e74\u5ea6\u9884\u7b97\u6570\u636e", (Object)key);
                continue;
            }
            Map<String, List<TpmSubsidiaryYearBudgetMonthDetailVo>> yearBudgetMonthMap = yearBudgetVoList.stream().collect(Collectors.groupingBy(b -> b.getBudgetDetailMonth()));
            String msg = "";
            for (SubComBudgetForecastVo vo : voList) {
                if (StringUtils.isBlank((CharSequence)vo.getYearMonthLy()) || Objects.isNull(vo.getBudgetAmount()) || BigDecimal.ZERO.compareTo(vo.getBudgetAmount()) == 0) {
                    log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u5206\u5b50\u9884\u7b97\u9884\u6d4b[" + vo.getBudgetForecastCode() + "],\u5e74\u6708:{},\u9884\u7b97\u91d1\u989d:{},====>\u4e0d\u68c0\u6d4b\u8d85\u989d", (Object)vo.getYearMonthLy(), (Object)vo.getBudgetAmount());
                    continue;
                }
                String[] split = vo.getYearMonthLy().split("-");
                if (split.length < 2) continue;
                List<TpmSubsidiaryYearBudgetMonthDetailVo> yearBudgetMonthDetailVoList = yearBudgetMonthMap.get(split[1].startsWith("0") ? split[1].replaceFirst("0", "") : split[1]);
                if (CollectionUtils.isEmpty(yearBudgetMonthDetailVoList)) {
                    log.info("\u81ea\u6295\u8d39\u7528\u63d0\u793a,\u5206\u5b50\u9884\u7b97\u9884\u6d4b[" + vo.getBudgetForecastCode() + "][" + vo.getYearMonthLy() + "]===>\u65e0\u5bf9\u5e94\u5e74\u5ea6\u9884\u7b97\u6570\u636e");
                    continue;
                }
                BigDecimal yearAutoAmount = yearBudgetMonthDetailVoList.stream().map(TpmSubsidiaryYearBudgetMonthDetailVo::getBudgetDetailAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal subtract = vo.getBudgetAmount().subtract(yearAutoAmount);
                if (subtract.compareTo(BigDecimal.ZERO) <= 0) continue;
                msg = split[0] + "\u5e74" + split[1] + "\u6708," + vo.getOrgName() + "(" + vo.getOrgCode() + "),\u81ea\u6295\u9884\u7b97\u5bf9\u6bd4\u5e74\u5ea6\u9884\u7b97\u504f\u5dee" + subtract.setScale(2, 4) + "\u5143";
                massages.add(msg);
                if (massages.size() < excessPromptTotal) continue;
                return massages;
            }
        }
        return massages;
    }

    public Page<SubComBudgetForecastVo> findListByProfitMonitor(Pageable pageable, SubComBudgetForecastDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComBudgetForecastRepository.findListByProfitMonitor((Page<SubComBudgetForecastVo>)page, dto);
    }

    public List<SubComAutoDetailVo> findAutoDetailSummary(List<SubComBudgetForecastVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.subComAutoDetailRepository.findAutoDetailSummary(records);
    }

    public Page<SubComBudgetForecastVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {
        if (CollectionUtils.isEmpty(yearMonthList)) {
            return new Page(0L, 0L);
        }
        return this.subComBudgetForecastRepository.findBySonCompanyBudgetWarn(pageable, yearMonthList, orgCode, saleCompanyCode, channelCode, saleGroupCode, customerCode, budgetItemCode);
    }
}

