/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetInternalApprovedAmountChangeDetailLogEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetInternalApprovedAmountChangeLogEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComInternalDetailEntity;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.SubComInternalDetailMapper;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetInternalApprovedAmountChangeDetailLogRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetInternalApprovedAmountChangeLogRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComInternalDetailRepository;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComBudgetForecastDetailService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComInternalDetailService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComInternalDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComInternalDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubComInternalDetailServiceImpl
implements SubComInternalDetailService {
    private static final Logger log = LoggerFactory.getLogger(SubComInternalDetailServiceImpl.class);
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private SubComInternalDetailMapper subComInternalDetailMapper;
    @Resource
    private SubComBudgetForecastRepository subComBudgetForecastRepository;
    @Resource
    private SubComInternalDetailRepository subComInternalDetailRepository;
    @Resource
    private SubComBudgetForecastDetailService subComBudgetForecastDetailService;
    @Resource
    private LoginUserService loginUserService;
    @Resource
    private SubComBudgetInternalApprovedAmountChangeDetailLogRepository subComBudgetInternalApprovedAmountChangeDetailLogRepository;
    @Resource
    private SubComBudgetInternalApprovedAmountChangeLogRepository subComBudgetInternalApprovedAmountChangeLogRepository;

    @Override
    public Page<SubComInternalDetailVo> detail(Pageable pageable, SubComInternalDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBudgetForecastCode(), (String)"\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SubComInternalDetailVo> byConditions = this.subComInternalDetailMapper.findByConditions((Page<SubComInternalDetailVo>)page, dto);
        Map unitMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_unit");
        Map feeBelongMap = this.dictToolkitService.findMapByDictTypeCode("tpm_fee_belong");
        if (!CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
            byConditions.getRecords().forEach(record -> {
                record.setBusinessUnitName((String)unitMap.get(record.getBusinessUnitCode()));
                record.setFeeBelongName((String)feeBelongMap.get(record.getFeeBelongCode()));
            });
        }
        return byConditions;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void internalUpdate(List<SubComInternalDetailDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<String> ids = dtoList.stream().map(UuidDto::getId).collect(Collectors.toList());
        List<SubComInternalDetailEntity> subComInternalDetailEntityList = this.subComInternalDetailRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notEmpty(subComInternalDetailEntityList, (String)"\u70b9\u5185\u8d39\u7528\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.getByCode(subComInternalDetailEntityList.get(0).getBudgetForecastCode());
        Map map = subComInternalDetailEntityList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        AtomicReference<BigDecimal> operationAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        dtoList.forEach(dto -> {
            if (!map.containsKey(dto.getId())) {
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
            }
            if (dto.getApprovedAmount() == null) {
                return;
            }
            SubComInternalDetailEntity subComInternalDetailEntity = (SubComInternalDetailEntity)((Object)((Object)map.get(dto.getId())));
            if (subComInternalDetailEntity.getBudgetAmount() == null && dto.getApprovedAmount() != null) {
                throw new RuntimeException("\u9884\u7b97\u91d1\u989d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6838\u51c6\uff01");
            }
            if (subComInternalDetailEntity.getBudgetAmount() != null && subComInternalDetailEntity.getBudgetAmount().compareTo(dto.getApprovedAmount()) < 0) {
                throw new RuntimeException("\u6838\u51c6\u91d1\u989d" + dto.getApprovedAmount() + "\u4e0d\u80fd\u5927\u4e8e\u9884\u7b97\u91d1\u989d" + subComInternalDetailEntity.getBudgetAmount());
            }
            operationAmount.set(((BigDecimal)operationAmount.get()).add(dto.getApprovedAmount()).subtract(Optional.ofNullable(subComInternalDetailEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
        });
        ArrayList<SubComInternalDetailEntity> subComInternalDetailEntities = new ArrayList<SubComInternalDetailEntity>(this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, SubComInternalDetailDto.class, SubComInternalDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        BigDecimal approvedAmount = dtoList.stream().map(SubComInternalDetailDto::getApprovedAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        subComBudgetForecastEntity.setApprovedAmount(approvedAmount);
        subComBudgetForecastEntity.setFirstBudgetAmount(subComBudgetForecastEntity.getBudgetAmount().min(subComBudgetForecastEntity.getApprovedAmount()).min(subComBudgetForecastEntity.getApplyAmountUp()));
        subComBudgetForecastEntity.setRemainderAmount(subComBudgetForecastEntity.getFirstBudgetAmount().subtract(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(subComBudgetForecastEntity.getAdjustAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(subComBudgetForecastEntity.getFreezeAmount()).orElse(BigDecimal.ZERO)));
        this.subComBudgetForecastRepository.updateById((Object)subComBudgetForecastEntity);
        this.subComInternalDetailRepository.updateBatchById(subComInternalDetailEntities);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        SubComBudgetInternalApprovedAmountChangeLogEntity approvedAmountChangeLogEntity = this.generateApprovedAmountChangeLog(loginDetails, subComBudgetForecastEntity);
        this.subComBudgetInternalApprovedAmountChangeLogRepository.save((Object)approvedAmountChangeLogEntity);
        List<SubComBudgetInternalApprovedAmountChangeDetailLogEntity> approvedAmountChangeDetailLogEntityList = this.generateApprovedAmountChangeDetailLog(approvedAmountChangeLogEntity.getId(), subComInternalDetailEntities);
        this.subComBudgetInternalApprovedAmountChangeDetailLogRepository.saveBatch(approvedAmountChangeDetailLogEntityList);
        SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = (SubComBudgetForecastDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        subComBudgetForecastDetailDto.setId(null);
        subComBudgetForecastDetailDto.setCurOperationAmount(operationAmount.get());
        subComBudgetForecastDetailDto.setBalanceAmount(subComBudgetForecastEntity.getRemainderAmount());
        subComBudgetForecastDetailDto.setBeforeAmount(subComBudgetForecastEntity.getRemainderAmount().subtract(operationAmount.get()));
        this.subComBudgetForecastDetailService.approved(subComBudgetForecastDetailDto, operationAmount.get());
    }

    private List<SubComBudgetInternalApprovedAmountChangeDetailLogEntity> generateApprovedAmountChangeDetailLog(String id, List<SubComInternalDetailEntity> subComInternalDetailEntities) {
        ArrayList<SubComBudgetInternalApprovedAmountChangeDetailLogEntity> entityList = new ArrayList<SubComBudgetInternalApprovedAmountChangeDetailLogEntity>();
        for (SubComInternalDetailEntity detailEntity : subComInternalDetailEntities) {
            SubComBudgetInternalApprovedAmountChangeDetailLogEntity entity = new SubComBudgetInternalApprovedAmountChangeDetailLogEntity();
            entity.setParentId(id);
            entity.setBudgetItemCode(detailEntity.getBudgetItemCode());
            entity.setBudgetItemLevelCode(detailEntity.getBudgetItemLevelCode());
            entity.setBudgetItemName(detailEntity.getBudgetItemName());
            entity.setFeeBelongCode(detailEntity.getFeeBelongCode());
            entity.setBusinessFormatCode(detailEntity.getBusinessFormatCode());
            entity.setYearMonthLy(detailEntity.getYearMonthLy());
            entity.setOrgCode(detailEntity.getOrgCode());
            entity.setOrgName(detailEntity.getOrgName());
            entity.setCustomerCode(detailEntity.getCustomerCode());
            entity.setCustomerName(detailEntity.getCustomerName());
            entity.setProductBrandCode(detailEntity.getProductBrandCode());
            entity.setProductBrandName(detailEntity.getProductBrandName());
            entity.setProductCategoryCode(detailEntity.getProductCategoryCode());
            entity.setProductCategoryName(detailEntity.getProductCategoryName());
            entity.setProductItemCode(detailEntity.getProductItemCode());
            entity.setProductItemName(detailEntity.getProductItemName());
            entity.setProductCode(detailEntity.getProductCode());
            entity.setProductName(detailEntity.getProductName());
            entity.setBudgetAmount(detailEntity.getBudgetAmount());
            entity.setBudgetApprovedAmount(detailEntity.getBudgetApprovedAmount());
            entity.setApprovedAmount(detailEntity.getApprovedAmount());
            entity.setRemark(detailEntity.getRemark());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entityList.add(entity);
        }
        return entityList;
    }

    private SubComBudgetInternalApprovedAmountChangeLogEntity generateApprovedAmountChangeLog(FacturerUserDetails loginDetails, SubComBudgetForecastEntity subComBudgetForecastEntity) {
        SubComBudgetInternalApprovedAmountChangeLogEntity entity = new SubComBudgetInternalApprovedAmountChangeLogEntity();
        entity.setApprovedAmount(subComBudgetForecastEntity.getApprovedAmount());
        entity.setBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
        entity.setBudgetItemCode(subComBudgetForecastEntity.getBudgetItemCode());
        entity.setModifyPositionCode(loginDetails.getPostCode());
        entity.setModifyPositionName(loginDetails.getPostName());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return entity;
    }
}

