/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetExternalApprovedAmountChangeDetailLogEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetExternalApprovedAmountChangeLogEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComBudgetForecastEntity;
import com.biz.crm.tpm.business.budget.forecast.local.entity.SubComOffPlanEntity;
import com.biz.crm.tpm.business.budget.forecast.local.mapper.SubComOffPlanMapper;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetExternalApprovedAmountChangeDetailLogRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetExternalApprovedAmountChangeLogRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComBudgetForecastRepository;
import com.biz.crm.tpm.business.budget.forecast.local.repository.SubComOffPlanRepository;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComBudgetForecastDetailService;
import com.biz.crm.tpm.business.budget.forecast.local.service.SubComOffPlanService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComOffPlanDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComOffDetailPlanVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComOffPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubComOffPlanServiceImpl
implements SubComOffPlanService {
    private static final Logger log = LoggerFactory.getLogger(SubComOffPlanServiceImpl.class);
    @Resource
    private SubComOffPlanMapper subComOffPlanMapper;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private SubComOffPlanRepository subComOffPlanRepository;
    @Resource
    private SubComBudgetForecastRepository subComBudgetForecastRepository;
    @Resource
    private SubComBudgetForecastDetailService subComBudgetForecastDetailService;
    @Resource
    private LoginUserService loginUserService;
    @Resource
    private SubComBudgetExternalApprovedAmountChangeLogRepository subComBudgetExternalApprovedAmountChangeLogRepository;
    @Resource
    private SubComBudgetExternalApprovedAmountChangeDetailLogRepository subComBudgetExternalApprovedAmountChangeDetailLogRepository;

    @Override
    public Page<SubComOffPlanVo> detail(Pageable pageable, SubComOffPlanDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new SubComOffPlanDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.subComOffPlanMapper.findByConditions((Page<SubComOffDetailPlanVo>)page, dto);
    }

    @Override
    public void offUpdate(List<SubComOffPlanDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<String> ids = dtoList.stream().map(UuidDto::getId).collect(Collectors.toList());
        List<SubComOffPlanEntity> subComOffPlanEntities = this.subComOffPlanRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notEmpty(subComOffPlanEntities, (String)"\u70b9\u5916\u8d39\u7528\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        SubComBudgetForecastEntity subComBudgetForecastEntity = this.subComBudgetForecastRepository.getByCode(subComOffPlanEntities.get(0).getBudgetForecastCode());
        Map map = subComOffPlanEntities.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        AtomicReference<BigDecimal> operationAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        dtoList.forEach(dto -> {
            if (!map.containsKey(dto.getId())) {
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
            }
            if (dto.getApprovedAmount() == null) {
                return;
            }
            SubComOffPlanEntity subComOffPlanEntity = (SubComOffPlanEntity)((Object)((Object)map.get(dto.getId())));
            operationAmount.set(((BigDecimal)operationAmount.get()).add(dto.getApprovedAmount()).subtract(Optional.ofNullable(subComOffPlanEntity.getApprovedAmount()).orElse(BigDecimal.ZERO)));
        });
        ArrayList subComOffPlanTransEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, SubComOffPlanDto.class, SubComOffPlanEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        BigDecimal approvedAmount = dtoList.stream().map(SubComOffPlanDto::getApprovedAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        subComBudgetForecastEntity.setApprovedAmount(approvedAmount);
        subComBudgetForecastEntity.setRemainderAmount(subComBudgetForecastEntity.getApprovedAmount().subtract(Optional.ofNullable(subComBudgetForecastEntity.getUsedAmount()).orElse(BigDecimal.ZERO)));
        this.subComBudgetForecastRepository.updateById((Object)subComBudgetForecastEntity);
        this.subComOffPlanRepository.updateBatchById(subComOffPlanTransEntities);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        SubComBudgetExternalApprovedAmountChangeLogEntity approvedAmountChangeLogEntity = this.generateApprovedAmountChangeLog(loginDetails, subComBudgetForecastEntity);
        this.subComBudgetExternalApprovedAmountChangeLogRepository.save((Object)approvedAmountChangeLogEntity);
        List<SubComBudgetExternalApprovedAmountChangeDetailLogEntity> approvedAmountChangeDetailLogEntityList = this.generateApprovedAmountChangeDetailLog(approvedAmountChangeLogEntity.getId(), subComOffPlanEntities);
        this.subComBudgetExternalApprovedAmountChangeDetailLogRepository.saveBatch(approvedAmountChangeDetailLogEntityList);
        SubComBudgetForecastDetailDto subComBudgetForecastDetailDto = (SubComBudgetForecastDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComBudgetForecastEntity, SubComBudgetForecastDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        subComBudgetForecastDetailDto.setId(null);
        subComBudgetForecastDetailDto.setCurOperationAmount(operationAmount.get());
        subComBudgetForecastDetailDto.setBalanceAmount(subComBudgetForecastEntity.getRemainderAmount());
        subComBudgetForecastDetailDto.setBeforeAmount(subComBudgetForecastEntity.getRemainderAmount().subtract(operationAmount.get()));
        this.subComBudgetForecastDetailService.approved(subComBudgetForecastDetailDto, operationAmount.get());
    }

    private List<SubComBudgetExternalApprovedAmountChangeDetailLogEntity> generateApprovedAmountChangeDetailLog(String id, List<SubComOffPlanEntity> subComExternalDetailEntities) {
        ArrayList<SubComBudgetExternalApprovedAmountChangeDetailLogEntity> entityList = new ArrayList<SubComBudgetExternalApprovedAmountChangeDetailLogEntity>();
        for (SubComOffPlanEntity detailEntity : subComExternalDetailEntities) {
            SubComBudgetExternalApprovedAmountChangeDetailLogEntity entity = new SubComBudgetExternalApprovedAmountChangeDetailLogEntity();
            entity.setParentId(id);
            entity.setBudgetItemCode(detailEntity.getBudgetItemCode());
            entity.setBudgetItemName(detailEntity.getBudgetItemName());
            entity.setBusinessFormatCode(detailEntity.getBusinessFormatCode());
            entity.setYearMonthLy(detailEntity.getYearMonthLy());
            entity.setOrgCode(detailEntity.getOrgCode());
            entity.setOrgName(detailEntity.getOrgName());
            entity.setCustomerCode(detailEntity.getCustomerCode());
            entity.setCustomerName(detailEntity.getCustomerName());
            entity.setProductBrandCode(detailEntity.getProductBrandCode());
            entity.setProductBrandName(detailEntity.getProductBrandName());
            entity.setProductCategoryCode(detailEntity.getProductCategoryCode());
            entity.setProductCategoryName(detailEntity.getProductCategoryName());
            entity.setProductItemCode(detailEntity.getProductItemCode());
            entity.setProductItemName(detailEntity.getProductItemName());
            entity.setProductCode(detailEntity.getProductCode());
            entity.setProductName(detailEntity.getProductName());
            entity.setPlanAmount(detailEntity.getPlanAmount());
            entity.setForecastAvailableAmount(detailEntity.getForecastAvailableAmount());
            entity.setApprovedAmount(detailEntity.getApprovedAmount());
            entity.setRemark(detailEntity.getRemark());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entityList.add(entity);
        }
        return entityList;
    }

    private SubComBudgetExternalApprovedAmountChangeLogEntity generateApprovedAmountChangeLog(FacturerUserDetails loginDetails, SubComBudgetForecastEntity subComBudgetForecastEntity) {
        SubComBudgetExternalApprovedAmountChangeLogEntity entity = new SubComBudgetExternalApprovedAmountChangeLogEntity();
        entity.setApprovedAmount(subComBudgetForecastEntity.getApprovedAmount());
        entity.setBudgetForecastCode(subComBudgetForecastEntity.getBudgetForecastCode());
        entity.setBudgetItemCode(subComBudgetForecastEntity.getBudgetItemCode());
        entity.setModifyPositionCode(loginDetails.getPostCode());
        entity.setModifyPositionName(loginDetails.getPostName());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return entity;
    }
}

