/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.listener;

import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastCallBackService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AdjustSubComBudgetForecastCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AdjustSubComBudgetForecastCompleteListener.class);
    @Resource
    private SubComBudgetForecastCallBackService subComBudgetForecastCallBackService;

    public String getBusinessCode() {
        return "adjust_sub_com_budget_forecast";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        Validate.notNull((Object)dto, (String)"\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u8c03\u6574\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.subComBudgetForecastCallBackService.adjustPass(dto);
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            this.subComBudgetForecastCallBackService.adjustRejectAndRecover(dto);
        }
        if (ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.subComBudgetForecastCallBackService.adjustRejectAndRecover(dto);
        }
    }
}

