/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.listener;

import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastCallBackService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SubComBudgetForecastCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastCompleteListener.class);
    @Resource
    private SubComBudgetForecastCallBackService subComBudgetForecastCallBackService;

    public String getBusinessCode() {
        return "manual_sub_com_budget_forecast";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        Validate.notNull((Object)dto, (String)"\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u624b\u52a8\u5f55\u5165\u6570\u636e\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String processStatus = dto.getProcessStatus();
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.subComBudgetForecastCallBackService.manualPass(dto);
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            this.subComBudgetForecastCallBackService.manualRejectAndRecover(dto);
        }
        if (ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.subComBudgetForecastCallBackService.manualRejectAndRecover(dto);
        }
    }
}

