/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.BudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastImportsVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BudgetForecastImportsProcess
implements ImportProcess<BudgetForecastImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(BudgetForecastImportsProcess.class);
    @Resource
    private BudgetItemService budgetItemService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private BudgetForecastService budgetForecastService;
    private Map<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
    private Map<String, String> tpmFeeClassifyMap = new HashMap<String, String>();
    private Map<String, String> tpmForecastTypeMap = new HashMap<String, String>();
    private Map<String, BudgetItemVo> budgetItemVoMap = new HashMap<String, BudgetItemVo>();

    public Map<Integer, String> execute(LinkedHashMap<Integer, BudgetForecastImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<BudgetForecastDto> importList = this.validate(data);
        this.budgetForecastService.importSave(importList);
        return null;
    }

    private List<BudgetForecastDto> validate(LinkedHashMap<Integer, BudgetForecastImportsVo> data) {
        ArrayList<BudgetForecastImportsVo> budgetForecastImportsVos = new ArrayList<BudgetForecastImportsVo>(data.values());
        this.buildBaseMap(budgetForecastImportsVos);
        budgetForecastImportsVos.forEach(importsVo -> {
            this.buildBaseData((BudgetForecastImportsVo)importsVo);
            this.buildDecimal((BudgetForecastImportsVo)importsVo);
        });
        Collection budgetForecastDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(budgetForecastImportsVos, BudgetForecastImportsVo.class, BudgetForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<BudgetForecastDto>(budgetForecastDtoList);
    }

    private void buildDecimal(BudgetForecastImportsVo importsVo) {
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getJanuaryNumStr())) {
                importsVo.setJanuaryNum(new BigDecimal(importsVo.getJanuaryNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e00\u6708\u4efd\u6570\u636e" + importsVo.getJanuaryNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getFebruaryNumStr())) {
                importsVo.setFebruaryNum(new BigDecimal(importsVo.getFebruaryNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e8c\u6708\u4efd\u6570\u636e" + importsVo.getFebruaryNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getMarchNumStr())) {
                importsVo.setMarchNum(new BigDecimal(importsVo.getMarchNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e09\u6708\u4efd\u6570\u636e" + importsVo.getMarchNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getAprilNumStr())) {
                importsVo.setAprilNum(new BigDecimal(importsVo.getAprilNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u56db\u6708\u4efd\u6570\u636e" + importsVo.getAprilNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getMayNumStr())) {
                importsVo.setMayNum(new BigDecimal(importsVo.getMayNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e94\u6708\u4efd\u6570\u636e" + importsVo.getMayNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getJuneNumStr())) {
                importsVo.setJuneNum(new BigDecimal(importsVo.getJuneNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u516d\u6708\u4efd\u6570\u636e" + importsVo.getJuneNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getJulyNumStr())) {
                importsVo.setJulyNum(new BigDecimal(importsVo.getJulyNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e03\u6708\u4efd\u6570\u636e" + importsVo.getJulyNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getAugustNumStr())) {
                importsVo.setAugustNum(new BigDecimal(importsVo.getAugustNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u516b\u6708\u4efd\u6570\u636e" + importsVo.getAugustNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getSeptemberNumStr())) {
                importsVo.setSeptemberNum(new BigDecimal(importsVo.getSeptemberNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e5d\u6708\u4efd\u6570\u636e" + importsVo.getSeptemberNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getOctoberNumStr())) {
                importsVo.setOctoberNum(new BigDecimal(importsVo.getOctoberNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5341\u6708\u4efd\u6570\u636e" + importsVo.getOctoberNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getNovemberNumStr())) {
                importsVo.setNovemberNum(new BigDecimal(importsVo.getNovemberNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5341\u4e00\u6708\u4efd\u6570\u636e" + importsVo.getNovemberNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)importsVo.getDecemberNumStr())) {
                importsVo.setDecemberNum(new BigDecimal(importsVo.getDecemberNumStr()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5341\u4e8c\u6708\u4efd\u6570\u636e" + importsVo.getDecemberNumStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private void buildBaseData(BudgetForecastImportsVo importsVo) {
        Validate.notEmpty((CharSequence)importsVo.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importsVo.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importsVo.getBudgetItemCode(), (String)"\u9884\u7b97\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importsVo.getYearLy(), (String)"\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importsVo.getFeeClassifyCode(), (String)"\u8d39\u7528\u5f52\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importsVo.getForecastTypeCode(), (String)"\u9884\u6d4b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)importsVo.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        importsVo.setBusinessFormatCode(this.mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
        importsVo.setBusinessUnitCode(this.mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
        importsVo.setFeeClassifyCode(this.tpmFeeClassifyMap.get(importsVo.getFeeClassifyCode()));
        importsVo.setForecastTypeCode(this.tpmForecastTypeMap.get(importsVo.getForecastTypeCode()));
        if (!this.budgetItemVoMap.containsKey(importsVo.getBudgetItemCode())) {
            throw new RuntimeException("\u9884\u7b97\u9879\u76ee" + importsVo.getBudgetItemCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        importsVo.setBudgetItemName(this.budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemName());
        importsVo.setBudgetItemLevelCode(this.budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemLevelCode());
    }

    private void buildBaseMap(List<BudgetForecastImportsVo> budgetForecastImportsVos) {
        this.mdmBusinessFormatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        this.mdmBusinessUnitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        this.tpmFeeClassifyMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_fee_classify");
        this.tpmForecastTypeMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_forecast_type");
        Set budgetItemCodeSet = budgetForecastImportsVos.stream().map(BudgetForecastImportsVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemCodeSet));
        this.budgetItemVoMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
    }

    public Class<BudgetForecastImportsVo> findCrmExcelVoClass() {
        return BudgetForecastImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_BUDGET_FORECAST_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u9884\u7b97\u9884\u6d4b\u5bfc\u5165";
    }
}

