/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastImportsVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComBudgetForecastImportsProcess
implements ImportProcess<SubComBudgetForecastImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComBudgetForecastImportsProcess.class);
    @Resource
    private OrgVoService orgVoService;
    @Resource
    private BudgetItemService budgetItemService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private SubComBudgetForecastService subComBudgetForecastService;
    public static final String DATE_YEAR_MONTH_REGEX = "^\\d{4}-((0([1-9]))|(1(0|1|2)))$";

    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComBudgetForecastImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        HashMap<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
        HashMap<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
        HashMap<String, BudgetItemVo> budgetItemVoMap = new HashMap<String, BudgetItemVo>();
        HashMap<String, OrgVo> orgVoMap = new HashMap<String, OrgVo>();
        HashMap<String, String> feeSourceMap = new HashMap<String, String>();
        List<SubComBudgetForecastDto> importList = this.validate(data, mdmBusinessFormatMap, mdmBusinessUnitMap, budgetItemVoMap, orgVoMap, feeSourceMap, errMap);
        ArrayList<String> list = new ArrayList<String>();
        for (SubComBudgetForecastDto dto : importList) {
            dto.setDataSourceCode("manual");
            list.add(dto.getBudgetItemCode());
        }
        List listByCodes = this.subComBudgetForecastService.findListByBudgetItemCodes(list);
        Map dtoMap = importList.stream().collect(Collectors.toMap(SubComBudgetForecastDto::getBudgetItemCode, Function.identity()));
        for (SubComBudgetForecastVo vo : listByCodes) {
            String dtoItem;
            SubComBudgetForecastDto dto = (SubComBudgetForecastDto)dtoMap.get(vo.getBudgetItemCode());
            String voItem = vo.getOrgCode() + vo.getYearMonthLy() + vo.getBusinessFormatCode() + vo.getBusinessUnitCode() + vo.getBudgetItemCode() + vo.getFeeSourceCode();
            if (!voItem.equals(dtoItem = dto.getOrgCode() + dto.getYearMonthLy() + dto.getBusinessFormatCode() + dto.getBusinessUnitCode() + dto.getBudgetItemCode() + dto.getFeeSourceCode())) continue;
            throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6570\u636e\u5b58\u5728\u91cd\u590d");
        }
        if (errMap.isEmpty()) {
            this.subComBudgetForecastService.importSave(importList);
        }
        return errMap;
    }

    public Integer getBatchCount() {
        return 2000;
    }

    private List<SubComBudgetForecastDto> validate(LinkedHashMap<Integer, SubComBudgetForecastImportsVo> data, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, BudgetItemVo> budgetItemVoMap, Map<String, OrgVo> orgVoMap, Map<String, String> feeSourceMap, Map<Integer, String> errMap) {
        this.buildBaseMap(data.values(), mdmBusinessFormatMap, mdmBusinessUnitMap, budgetItemVoMap, orgVoMap, feeSourceMap);
        data.forEach((k, v) -> {
            this.buildBaseData((SubComBudgetForecastImportsVo)v, mdmBusinessFormatMap, mdmBusinessUnitMap, budgetItemVoMap, orgVoMap, feeSourceMap);
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put((Integer)k, errInfo);
            }
        });
        if (!errMap.isEmpty()) {
            return new ArrayList<SubComBudgetForecastDto>();
        }
        Collection budgetForecastDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), SubComBudgetForecastImportsVo.class, SubComBudgetForecastDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<SubComBudgetForecastDto>(budgetForecastDtoList);
    }

    private void buildBaseData(SubComBudgetForecastImportsVo importsVo, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, BudgetItemVo> budgetItemVoMap, Map<String, OrgVo> orgVoMap, Map<String, String> feeSourceMap) {
        if (StringUtils.isEmpty((CharSequence)importsVo.getBusinessFormatCode())) {
            this.validateIsTrue(false, "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
            importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u6001" + importsVo.getBusinessFormatCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getBusinessUnitCode())) {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
            importsVo.setBusinessUnitCode(mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
        } else {
            this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143" + importsVo.getBusinessUnitCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getYearMonthLy())) {
            this.validateIsTrue(false, "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            try {
                if (!importsVo.getYearMonthLy().matches(DATE_YEAR_MONTH_REGEX)) {
                    this.validateIsTrue(false, "\u5e74\u6708" + importsVo.getYearMonthLy() + "\u683c\u5f0f\u9519\u8bef\uff08yyyy-MM\uff09\uff0c\u8bf7\u68c0\u67e5");
                } else {
                    DateUtil.parse((String)importsVo.getYearMonthLy(), (String)"yyyy-MM");
                }
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u5e74\u6708" + importsVo.getYearMonthLy() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getOrgCode())) {
            this.validateIsTrue(false, "\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (orgVoMap.containsKey(importsVo.getOrgCode())) {
            importsVo.setOrgName(orgVoMap.get(importsVo.getOrgCode()).getOrgName());
        } else {
            this.validateIsTrue(false, "\u7ec4\u7ec7" + importsVo.getOrgCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getBudgetItemCode())) {
            this.validateIsTrue(false, "\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (budgetItemVoMap.containsKey(importsVo.getBudgetItemCode())) {
            importsVo.setBudgetItemName(budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemName());
        } else {
            this.validateIsTrue(false, "\u9884\u7b97\u9879\u76ee\u7f16\u7801" + importsVo.getBudgetItemCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getFeeSourceCode())) {
            this.validateIsTrue(false, "\u8d39\u7528\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (feeSourceMap.containsKey(importsVo.getFeeSourceCode())) {
            importsVo.setFeeSourceCode(feeSourceMap.get(importsVo.getFeeSourceCode()));
        } else {
            this.validateIsTrue(false, "\u8d39\u7528\u6765\u6e90" + importsVo.getFeeSourceCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StringUtils.isEmpty((CharSequence)importsVo.getBudgetAmountStr())) {
            this.validateIsTrue(false, "\u9884\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            try {
                importsVo.setBudgetAmount(new BigDecimal(importsVo.getBudgetAmountStr()));
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u9884\u7b97\u91d1\u989d" + importsVo.getBudgetAmountStr() + "\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    private void buildBaseMap(Collection<SubComBudgetForecastImportsVo> budgetForecastImportsVos, Map<String, String> mdmBusinessFormatMap, Map<String, String> mdmBusinessUnitMap, Map<String, BudgetItemVo> budgetItemVoMap, Map<String, OrgVo> orgVoMap, Map<String, String> feeSourceMap) {
        Set orgCodeSet;
        List byOrgCodes;
        mdmBusinessFormatMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format"));
        mdmBusinessUnitMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit"));
        feeSourceMap.putAll(this.dictToolkitService.findConvertMapByDictTypeCode("tpm_fee_source"));
        Set budgetItemCodeSet = budgetForecastImportsVos.stream().map(SubComBudgetForecastImportsVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List budgetItemVos = this.budgetItemService.listByCodes(new ArrayList(budgetItemCodeSet));
        if (!CollectionUtils.isEmpty((Collection)budgetItemVos)) {
            budgetItemVoMap.putAll(budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity())));
        }
        if (!CollectionUtils.isEmpty((Collection)(byOrgCodes = this.orgVoService.findByOrgCodes(new ArrayList(orgCodeSet = budgetForecastImportsVos.stream().map(SubComBudgetForecastImportsVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toSet())))))) {
            orgVoMap.putAll(byOrgCodes.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity())));
        }
    }

    public Class<SubComBudgetForecastImportsVo> findCrmExcelVoClass() {
        return SubComBudgetForecastImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SUB_COM_BUDGET_FORECAST_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u5bfc\u5165";
    }
}

