/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.forecast.local.service.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(ExternalAutoSyncXxlJob.class);
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @DynamicTaskService(cornExpression="0 0 0 1/1 1/1 ?", taskDesc="\u5b9a\u65f6\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5916\u8d39\u7528")
    public void autoSync() {
        log.info("=====>    \u5b9a\u65f6\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5916\u8d39\u7528[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        this.loginUserService.refreshAuthentication(null);
        String yearMonthStr = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        if (this.redisLockService.isLock("sub_com_budget_forecast_out_job_lock:" + yearMonthStr)) {
            throw new RuntimeException("\u70b9\u5916\u9884\u7b97\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e");
        }
        boolean flag = false;
        try {
            flag = this.redisLockService.tryLock("sub_com_budget_forecast_out_job_lock:" + yearMonthStr, TimeUnit.SECONDS, 60L);
            log.info("\u5b9a\u65f6\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5916\u8d39\u7528\u52a0\u9501\u6210\u529f");
            this.subComBudgetForecastService.calExternalData(yearMonthStr);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5916\u8d39\u7528\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (flag) {
                this.redisLockService.unlock("sub_com_budget_forecast_out_job_lock:" + yearMonthStr);
            }
        }
        log.info("=====>    \u5b9a\u65f6\u751f\u6210\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u70b9\u5916\u8d39\u7528[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }
}

