package com.biz.crm.tpm.business.budget.forecast.sdk.dto;

import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 分子预算预测调整
 */
@ApiModel(value = "SubComBudgetForecastAdjustDto", description = "TPM-分子预算预测调整")
@Getter
@Setter
public class SubComBudgetForecastAdjustDto {

    @ApiModelProperty(value = "调出方预算编码")
    private String adjustOutBudgetCode;

    @ApiModelProperty(value = "调出金额")
    private BigDecimal adjustOutAmount;

    @ApiModelProperty(value = "调入方预算编码")
    private String adjustInBudgetCode;

    @ApiModelProperty(value = "操作说明")
    private String operationRemarks;

    @ApiModelProperty("工作流参数")
    private ProcessBusinessDto processBusiness;
}
