package com.biz.crm.tpm.business.budget.forecast.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月31日 15:38
 */
@ApiModel(value = "SubComOffPlanVo", description = "TPM-分子公司预算预测点外费用方案明细")
@Getter
@Setter
public class SubComOffPlanDto extends TenantFlagOpDto {

    /**
     * 分子公司预算预测编码
     */
    @ApiModelProperty(value = "分子公司预算预测编码")
    private String budgetForecastCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    private String planCode;

    /**
     * 方案名称
     */
    @ApiModelProperty("方案名称")
    private String planName;

    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    private String planItemCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 区域编码
     */
    @ApiModelProperty(value = "区域编码", notes = "")
    private String areaCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(value = "区域名称", notes = "")
    private String areaName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    private String customerName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 核销公式
     */
    @ApiModelProperty("核销公式")
    private String auditExpression;

    /**
     * 方案金额
     */
    @ApiModelProperty(value = "方案金额", notes = "")
    private BigDecimal planAmount;

    /**
     * 预测可使用金额
     */
    @ApiModelProperty(value = "预测可使用金额", notes = "")
    private BigDecimal forecastAvailableAmount;

    /**
     * 核准金额
     */
    @ApiModelProperty("核准金额")
    private BigDecimal approvedAmount;

}


