package com.biz.crm.tpm.business.budget.forecast.sdk.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月09日 11:35
 */
@Getter
public enum AutoDetailAmountTypeEnum {

    THEORY_INCOME("theory_income", "理论收入"),

    THEORY_COST("theory_cost", "理论成本"),

    THEORY_PROFIT("theory_profit", "理论毛利"),

    /*FIXED_PAY("fixed_pay", "固定支出"),*/

    FIXED_PAY_TOTAL("fixed_pay_total", "固定支出小计"),

    PROFIT_GOAL("profit_goal", "利润目标"),

    ASSESS_DEDUCTION("assess_deduction", "考核扣款"),

    TAX_AMOUNT("tax_amount", "税金及附加"),

    AUTO_AMOUNT("auto_amount", "自投费用"),

    RETURN_AMOUNT("return_amount", "费用退还"),
    ;

    private String code;

    private String desc;

    AutoDetailAmountTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (AutoDetailAmountTypeEnum t : AutoDetailAmountTypeEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }

}
