package com.biz.crm.tpm.business.budget.forecast.sdk.event;

import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author huojia
 * @date 2022年10月28日 17:38
 */
public interface BudgetForecastLogEventListener extends NebulaEvent {

    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(BudgetForecastLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(BudgetForecastLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(BudgetForecastLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(BudgetForecastLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(BudgetForecastLogEventDto dto);
}
