package com.biz.crm.tpm.business.budget.forecast.sdk.service;

import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;

public interface SubComBudgetForecastCallBackService {

    /**
     * 预算预测调整 审批通过
     *
     **/
    void adjustPass(ProcessStatusDto dto);

    /**
     * 预算预测调整 审批驳回、追回
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:42
     **/
    void adjustRejectAndRecover(ProcessStatusDto dto);

    /**
     * 预算预测变更 审批通过
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:47
     **/
    void changePass(ProcessStatusDto dto);

    /**
     * 预算预测变更 审批驳回、追回
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:48
     **/
    void changeRejectAndRecover(ProcessStatusDto dto);

    /**
     * 预算预测手动录入数据 审批通过
     *
     **/
    void manualPass(ProcessStatusDto dto);

    /**
     * 预算预测手动录入数据 审批驳回、追回
     *
     * @param dto
     * @author huojia
     * @date 2022/11/12 17:42
     **/
    void manualRejectAndRecover(ProcessStatusDto dto);
}
