package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetAdjustVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 分子预算预测调整
 */
@ApiModel(value = "SubComBudgetForecastAdjustVo", description = "TPM-分子预算预测调整详情vo")
@Getter
@Setter
public class SubComBudgetForecastAdjustVo extends SubComBudgetForecastVo{

    @ApiModelProperty(value = "可用金额（调整前）")
    private BigDecimal balanceBeforeAdjustAmount;

    @ApiModelProperty(value = "调整金额")
    private BigDecimal adjustAmount;

    @ApiModelProperty(value = "可用金额（调整后）")
    private BigDecimal balanceBehindAdjustAmount;

    @ApiModelProperty(value = "操作说明")
    private String operationRemarks;
}
