package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月31日 15:38
 */
@ApiModel(value = "BudgetForecastVo", description = "TPM-分子公司预算预测明细")
@Getter
@Setter
public class SubComBudgetForecastDetailVo extends TenantFlagOpVo {

    /**
     * 分子公司预算预测编码
     */
    @ApiModelProperty(value = "分子公司预算预测编码")
    private String budgetForecastCode;

    /**
     * 操作类型[数据字典:tpm_forecast_operation_type]
     */
    @ApiModelProperty(value = "操作类型[数据字典:tpm_forecast_operation_type]", notes = "")
    private String operationType;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 期初金额
     */
    @ApiModelProperty(value = "期初金额", notes = "")
    private BigDecimal initialAmount;

    /**
     * 操作前金额
     */
    @ApiModelProperty(value = "操作前金额", notes = "")
    private BigDecimal beforeAmount;

    /**
     * 当前操作金额
     */
    @ApiModelProperty(value = "当前操作金额", notes = "")
    private BigDecimal curOperationAmount;

    /**
     * 操作后余额
     */
    @ApiModelProperty(value = "操作后余额", notes = "")
    private BigDecimal balanceAmount;

    /**
     * 审批编码
     */
    @ApiModelProperty(value = "审批编码", notes = "")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态", notes = "")
    private String processStatus;

    @ApiModelProperty(value = "业务编码", notes = "")
    private String businessCode;

}
