package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月28日 17:19
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class SubComBudgetForecastImportsVo extends CrmExcelVo {

    /**
     * 字段
     */
    @CrmExcelColumn(value = "字段")
    private String ext1;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元")
    private String businessUnitCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @CrmExcelColumn(value = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmExcelColumn(value = "组织编码")
    private String orgName;

    /**
     * 预算项目编码
     */
    @CrmExcelColumn(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @CrmExcelColumn(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @CrmExcelColumn(value = "费用来源")
    private String feeSourceCode;

    /**
     * 预算金额
     */
    @CrmExcelColumn(value = "预算金额")
    private String budgetAmountStr;

    @ExcelIgnore
    private BigDecimal budgetAmount;
}
