package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author chenlong
 * @date 2023年05月31日 15:26
 */
@ApiModel(value = "SubComBudgetForecastProcessVo", description = "TPM-分子预算预测流程业务表单vo")
@Data
public class SubComBudgetForecastProcessVo {

    /**
     * 分子公司预算预测详情
     */
    @ApiModelProperty(value = "分子公司预算预测详情")
    private SubComBudgetForecastVo forecastVo;

    @ApiModelProperty(value = "分子公司预算预测编码")
    private String budgetForecastCode;

    @ApiModelProperty(value = "操作金额")
    private BigDecimal operationAmount;

    @ApiModelProperty(value = "操作类型")
    private String operationType;

    @ApiModelProperty(value = "操作说明")
    private String operationRemarks;

    /**
     * 变更后余额
     */
    @ApiModelProperty(value = "变更后余额", notes = "")
    private BigDecimal balanceAmount;

}
