package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;

/**
 * @ClassName SubComBudgetInternalApprovedAmountChangeDetailLogVo
 * @Description
 * @Author: jiangyin
 * @Date 2023/1/10
 */
@Data
@ApiModel("分子公司预算预测-点内核准金额变更日志明细视图类")
public class SubComBudgetInternalApprovedAmountChangeDetailLogVo extends TenantFlagOpVo {

    /**
     * 变更日志id
     */
    @ApiModelProperty("变更日志id")
    private String parentId;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 分子公司预算预测编码
     */
    @ApiModelProperty(name = "分子公司预算预测编码")
    private String budgetForecastCode;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    private String budgetItemLevelCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    
    private String orgName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额", notes = "")
    private BigDecimal budgetAmount;

    /**
     * 批复金额
     */
    @ApiModelProperty(value = "批复金额", notes = "")
    private BigDecimal budgetApprovedAmount;

    /**
     * 核准金额
     */
    @ApiModelProperty("核准金额")
    private BigDecimal approvedAmount;
    
}
