package com.biz.crm.tpm.business.budget.item.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 实体：TPM-预算项目管控条件;
 *
 * @author : Keller
 * @date : 2022-5-18
 */
@ApiModel(value = "BudgetItemControlConditionEntity", description = "TPM-预算项目管控条件")
@TableName("tpm_budget_item_control_condition")
@Getter
@Setter
@Entity(name = "tpm_budget_item_control_condition")
@Table(name = "tpm_budget_item_control_condition", indexes = {@Index(name = "tpm_budget_item_control_condition_index1", columnList = "budget_item_code")})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_item_control_condition", comment = "TPM-预算项目管控条件")
public class BudgetItemControlConditionEntity extends TenantFlagOpEntity {

    /*冗余字段*/

    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /*冗余字段*/

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 管控类型[数据字典:tpm_budget_control_type]
     */
    @ApiModelProperty(name = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    @Column(name = "control_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '管控类型[数据字典:tpm_budget_control_type] '")
    private String controlTypeCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(name = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    /**
     * 部门归口[数据字典:tpm_department_belong]
     */
    @ApiModelProperty(name = "部门归口[数据字典:tpm_department_belong]", notes = "")
    @Column(name = "department_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门归口[数据字典:tpm_department_belong] '")
    private String departmentBelongCode;

}