package com.biz.crm.tpm.business.budget.item.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 实体：TPM-预算项目;
 *
 * @author : Keller
 * @date : 2022-5-18
 */
@ApiModel(value = "BudgetItemEntity", description = "TPM-预算项目")
@TableName("tpm_budget_item")
@Getter
@Setter
@Entity(name = "tpm_budget_item")
@Table(name = "tpm_budget_item", indexes = {
        @Index(name = "tpm_budget_item_index1", columnList = "budget_item_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_item", comment = "TPM-预算项目")
public class BudgetItemEntity extends TenantFlagTreeOpEntity {

    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(name = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(name = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    @Column(name = "budget_item_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目层级[数据字典:tpm_budget_item_level] '")
    private String budgetItemLevelCode;

    /**
     * 上级预算项目编码
     */
    @ApiModelProperty(name = "上级预算项目编码", notes = "")
    @Column(name = "parent_budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '上级预算项目编码 '")
    private String parentBudgetItemCode;

    /**
     * 上级预算项目名称
     */
    @ApiModelProperty(name = "上级预算项目名称", notes = "")
    @Column(name = "parent_budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '上级预算项目名称 '")
    private String parentBudgetItemName;

    /**
     * 费用属性[数据字典:tpm_budget_fee_attr]
     */
    @ApiModelProperty(name = "费用属性[数据字典:tpm_budget_fee_attr]", notes = "")
    @Column(name = "fee_attr_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用属性[数据字典:tpm_budget_fee_attr] '")
    private String feeAttrCode;

    /**
     * 数据类型[数据字典:tpm_budget_data_type]
     */
    @ApiModelProperty(name = "数据类型[数据字典:tpm_budget_data_type]", notes = "")
    @Column(name = "data_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据类型[数据字典:tpm_budget_data_type] '")
    private String dataTypeCode;

    /**
     * 关联主体预算项目编码（多选，用“,”隔开）
     */
    @ApiModelProperty(name = "关联主体预算项目编码（多选，用“,”隔开）", notes = "")
    @Column(name = "main_budget_item_code", nullable = true, length = 512, columnDefinition = "VARCHAR(512) COMMENT '关联主体预算项目编码（多选，用“,”隔开） '")
    private String mainBudgetItemCode;

    /**
     * 关联主体预算项目名称
     */
    @ApiModelProperty(name = "关联主体预算项目名称", notes = "")
    @Column(name = "main_budget_item_name", nullable = true, length = 512, columnDefinition = "VARCHAR(512) COMMENT '关联主体预算项目名称 '")
    private String mainBudgetItemName;

    /**
     * 关联历史预算项目编码
     */
    @ApiModelProperty(name = "关联历史预算项目编码", notes = "")
    @Column(name = "history_budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联历史预算项目编码 '")
    private String historyBudgetItemCode;

    /**
     * 关联历史预算项目名称
     */
    @ApiModelProperty(name = "关联历史预算项目名称", notes = "")
    @Column(name = "history_budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '关联历史预算项目名称 '")
    private String historyBudgetItemName;

    /**
     * 是否允许跨月
     */
    @ApiModelProperty(name = "是否允许跨月", notes = "")
    @Column(name = "allow_cross_month", nullable = true, length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否允许跨月 '")
    private String allowCrossMonth;

}