package com.biz.crm.tpm.business.budget.item.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 实体：TPM-预算项目关联主预算项目;
 *
 * @author : Keller
 * @date : 2022-5-18
 */
@ApiModel(value = "BudgetItemMainItemEntity", description = "TPM-预算项目关联主预算项目")
@TableName("tpm_budget_item_main_item")
@Getter
@Setter
@Entity(name = "tpm_budget_item_main_item")
@Table(name = "tpm_budget_item_main_item",
        indexes = {@Index(name = "tpm_budget_item_main_item_index1", columnList = "budget_item_code"),
                @Index(name = "tpm_budget_item_main_item_index2", columnList = "main_budget_item_code")})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_item_main_item", comment = "TPM-预算项目关联主预算项目")
public class BudgetItemMainItemEntity extends TenantFlagOpEntity {

    /*冗余字段*/

    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /*冗余字段*/

    /**
     * 主体预算项目编码
     */
    @ApiModelProperty(name = "主体预算项目编码", notes = "")
    @Column(name = "main_budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '主体预算项目编码 '")
    private String mainBudgetItemCode;

    /**
     * 主体预算项目名称
     */
    @ApiModelProperty(name = "主体预算项目名称", notes = "")
    @Column(name = "main_budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '主体预算项目名称 '")
    private String mainBudgetItemName;

}