package com.biz.crm.tpm.business.budget.item.local.interceptor;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.budget.item.sdk.constant.DictTypeCodeConstant;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description 预算项目视图字段扩展
 * @Author YangWei
 * @Date 2023/2/7 上午10:02
 */
@Slf4j
@Component
public class BudgetItemInterceptor implements ExternalQueryInterceptor {

    //扩展字段
    private static final String BUSINESS_UNIT_CODE = "business_unit_code";

    @Resource
    private DictDataVoService dictDataVoService;

    @Override
    public String code() {
        return "tpm_budget_item_data_view_business_unit_code";
    }

    @Override
    public String name() {
        return "业务单元";
    }

    @Override
    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
        //查询结果
        List<Map<String, Object>> results = executeContent.getResults();
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        //查询业务单元数据字典
        List<DictDataVo> businessUnit = this.dictDataVoService.findByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_UNIT);
        Map<String, DictDataVo> businessUnitMap = businessUnit.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        //数据处理
        List<Object[]> contents = Lists.newArrayList();
        results.forEach(item -> {
            if (null == item){
                contents.add(null);
                return;
            }
            List<Object> businessUnitNameArray = Lists.newArrayList();
            String businessUnitCodeStr = (String) item.get(BUSINESS_UNIT_CODE);
            if(StringUtils.hasText(businessUnitCodeStr)){
                String[] businessUnitCodeArray = businessUnitCodeStr.split(",");
                List<String> businessUnitNameList = Lists.newArrayList();
                for (int i = 0; i < businessUnitCodeArray.length; i++) {
                    DictDataVo dictDataVo = businessUnitMap.get(businessUnitCodeArray[i]);
                    if(!ObjectUtils.isEmpty(dictDataVo)){
                        businessUnitNameList.add(dictDataVo.getDictValue());
                    }
                }
                if(CollectionUtils.isEmpty(businessUnitNameList)){
                    businessUnitNameArray.add(businessUnitCodeStr);
                }else{
                    String businessUnitNameStr = String.join(",", businessUnitNameList);
                    businessUnitNameArray.add(businessUnitNameStr);
                }
            }else{
                businessUnitNameArray.add(businessUnitCodeStr);
            }
            contents.add(businessUnitNameArray.toArray(new Object[]{}));
        });
        return contents;
    }
}