package com.biz.crm.tpm.business.budget.item.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemEntity;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemDto;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月24日 16:26
 */
public interface BudgetItemMapper extends BaseMapper<BudgetItemEntity> {

    /**
     * 条件查询预算项目
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.budget.item.sdk.vo.resp.BudgetItemRespVo>
     * @author huojia
     * @date 2022/10/24 16:27
     **/
    Page<BudgetItemVo> findByConditions(Page<BudgetItemVo> page, @Param("dto") BudgetItemDto dto);

    /**
     * 查询上级预算项目
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.budget.item.sdk.vo.resp.BudgetItemRespVo>
     * @author huojia
     * @date 2022/10/24 22:55
     **/
    Page<BudgetItemVo> listParent(Page<BudgetItemVo> page, @Param("dto") BudgetItemDto dto);

    /**
     * 置空无上级的预算项目对应的ruleCode
     *
     * @author huojia
     * @date 2022/10/25 10:22
     **/
    void updateOrphanParentCodeNull();

    /**
     * 获取预算项目树
     *
     * @param enableStatus
     * @param topOnly
     * @param parentCode
     * @param codeList
     * @param ruleCodeList
     * @param excludeRuleCode
     * @return java.util.List<com.biz.crm.business.common.sdk.vo.LazyTreeVo>
     * @author huojia
     * @date 2022/10/25 11:06
     **/
    List<LazyTreeVo> findBudgetItemLazyTreeList(@Param("enableStatus") String enableStatus,
                                                @Param("topOnly") Boolean topOnly,
                                                @Param("parentCode") String parentCode,
                                                @Param("codeList") List<String> codeList,
                                                @Param("ruleCodeList") List<String> ruleCodeList,
                                                @Param("excludeRuleCode") String excludeRuleCode);

    /**
     * 分页查询已
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo>
     * @author huojia
     * @date 2022/10/25 18:02
     **/
    Page<BudgetItemVo> listByBudgetItemCodeList(Page<BudgetItemVo> page, @Param("dto") BudgetItemDto dto);

    /**
     * 通过主体预算项目找到分子公司预算项目
     * @param dto
     * @return {@link List}<{@link BudgetItemVo}>
     */
    List<BudgetItemVo> findByMainBudgetItem(@Param("dto") BudgetItemDto dto);

    /**
     * 分页查询分子公司预算项目
     *
     * @param page
     * @param dto
     * @return
     */
    Page<BudgetItemVo> listSubsidiaryCompaniesBudgetItem(Page<BudgetItemVo> page, @Param("dto") BudgetItemDto dto);
}
