package com.biz.crm.tpm.business.budget.item.local.notifier;

import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemEntity;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemRepository;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemDto;
import com.biz.crm.tpm.business.budget.item.sdk.event.BudgetItemEventListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 预算项目
 *
 * @author huojia
 * @date 2022年10月25日 17:20
 */
@Slf4j
@Component
public class ItemForBudgetItemEventListener implements BudgetItemEventListener {

    @Autowired(required = false)
    private BudgetItemRepository budgetItemRepository;

    @Override
    public void onCreated(BudgetItemDto reqVo) {

    }

    /**
     * 修改预算项目后，更新父级预算项目名称
     *
     * @param oldDto
     * @param newDto
     * @author huojia
     * @date 2022/10/25 17:23
     **/
    @Override
    public void onUpdate(BudgetItemDto oldDto, BudgetItemDto newDto) {
        List<BudgetItemEntity> childrenList = budgetItemRepository.findChildrenListByParentCode(oldDto.getBudgetItemCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        childrenList.forEach(children -> {
            children.setParentBudgetItemName(newDto.getParentBudgetItemName());
        });
        this.budgetItemRepository.updateBatchById(childrenList);
    }

    @Override
    public void onDeleted(BudgetItemDto reqVo) {

    }

    @Override
    public void onEnable(BudgetItemDto reqVo) {

    }

    @Override
    public void onDisable(BudgetItemDto reqVo) {

    }
}
