package com.biz.crm.tpm.business.budget.item.local.register;

import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemEntity;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.apache.commons.lang3.StringUtils;
import java.util.Objects;

/**
 * @CLASS_DESCRIBE: 类的描述
 * @AUTHOR: create by zkey on 2023-01-15
 */
@Component("BudgetItemRuleCodeParameterValueBindingStrategy")
public class BudgetItemRuleCodeParameterValueBindingStrategy implements ParameterValueBindingStrategy {

    @Autowired
    private BudgetItemRepository budgetItemRepository;

    public BudgetItemRuleCodeParameterValueBindingStrategy() {
    }

    @Override
    public String getBindType() {
        return "BudgetItem_RuleCode";
    }

    @Override
    public String getBindTypeCnName() {
        return "预算项目ruleCode规则编码取值";
    }

    @Override
    public Boolean getOutside() {
        return false;
    }

    @Override
    public Class<?>[] matchedJavaClasses() {
        return new Class[]{CharSequence.class};
    }

    @Override
    public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        String budgetItemCode = (String) databaseExecuteExternalRequest.getAttribute("budgetItemCode");
        if (StringUtils.isBlank(budgetItemCode)){
            return null;
        }
        BudgetItemEntity budgetItemEntity = this.budgetItemRepository.getByBudgetItemCode(budgetItemCode, null);
        if (Objects.isNull(budgetItemEntity)){
            return null;
        }
        return budgetItemEntity.getRuleCode();
    }
}
