package com.biz.crm.tpm.business.budget.item.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity;
import com.biz.crm.tpm.business.budget.item.local.mapper.BudgetItemControlConditionMapper;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月24日 16:35
 */
@Component
public class BudgetItemControlConditionRepository
        extends ServiceImpl<BudgetItemControlConditionMapper, BudgetItemControlConditionEntity> {

    /**
     * 根据预算项目查询管控
     *
     * @param budgetItemCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo>
     * @author huojia
     * @date 2022/10/24 17:38
     **/
    public List<BudgetItemControlConditionEntity> findByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty(budgetItemCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据预算项目查询管控
     *
     * @param budgetItemCodes
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo>
     * @author huojia
     * @date 2022/10/24 17:38
     **/
    public List<BudgetItemControlConditionEntity> findByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCodes)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据预算科目删除管控
     *
     * @param budgetItemCode
     * @author huojia
     * @date 2022/10/24 19:46
     **/
    public void delByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty(budgetItemCode)) {
            return;
        }
        List<BudgetItemControlConditionEntity> list = this.lambdaQuery().eq(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCode).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetItemControlConditionEntity -> {
                budgetItemControlConditionEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 根据预算科目编码批量删除管控
     *
     * @param budgetItemCodes
     * @author huojia
     * @date 2022/10/24 19:58
     **/
    public void delByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return;
        }
        List<BudgetItemControlConditionEntity> list = this.lambdaQuery().in(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCodes).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetItemControlConditionEntity -> {
                budgetItemControlConditionEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 查询主体
     *
     * @param businessUnitCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity>
     * @author huojia
     * @date 2022/10/25 18:11
     **/
    public List<BudgetItemControlConditionEntity> listByBusinessUnitCode(String businessUnitCode) {
        if (StringUtils.isEmpty(businessUnitCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(BudgetItemControlConditionEntity::getBusinessUnitCode, businessUnitCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据预算项目编码查询
     *
     * @param budgetItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity>
     * @author huojia
     * @date 2023/1/10 16:25
     **/
    public List<BudgetItemControlConditionEntity> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public List<String> findCodeForVariable(BudgetItemControlConditionDto dto) {
        return this.baseMapper.findCodeForVariable(dto,TenantUtils.getTenantCode());
    }
}
