package com.biz.crm.tpm.business.budget.item.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemMainItemEntity;
import com.biz.crm.tpm.business.budget.item.local.mapper.BudgetItemMainItemMapper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月24日 16:35
 */
@Component
public class BudgetItemMainItemRepository
        extends ServiceImpl<BudgetItemMainItemMapper, BudgetItemMainItemEntity> {

    /**
     * 根据预算项目编码查询
     *
     * @param budgetItemCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemMainItemEntity>
     * @author huojia
     * @date 2022/11/28 14:23
     **/
    public List<BudgetItemMainItemEntity> findByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty(budgetItemCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(BudgetItemMainItemEntity::getBudgetItemCode, budgetItemCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据预算项目编码查询
     *
     * @param budgetItemCodes
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemMainItemEntity>
     * @author huojia
     * @date 2022/11/28 14:23
     **/
    public List<BudgetItemMainItemEntity> findByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(BudgetItemMainItemEntity::getBudgetItemCode, budgetItemCodes)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据预算项目编码删除
     *
     * @param budgetItemCode
     * @author huojia
     * @date 2022/11/28 14:27
     **/
    public void delByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty(budgetItemCode)) {
            return;
        }
        List<BudgetItemMainItemEntity> list = this.lambdaQuery().eq(BudgetItemMainItemEntity::getBudgetItemCode, budgetItemCode).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetItemMainItemEntity -> {
                budgetItemMainItemEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 根据预算科目编码批量删除
     *
     * @param budgetItemCodes
     * @author huojia
     * @date 2022/11/28 14:29
     **/
    public void delByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return;
        }
        List<BudgetItemMainItemEntity> list = this.lambdaQuery().in(BudgetItemMainItemEntity::getBudgetItemCode, budgetItemCodes).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetItemMainItemEntity -> {
                budgetItemMainItemEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 根据主编码查询
     *
     * @param mainBudgetItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemMainItemEntity>
     * @author huojia
     * @date 2022/12/8 15:07
     **/
    public List<BudgetItemMainItemEntity> listByMainBudgetItemCodeList(List<String> mainBudgetItemCodeList) {
        if (CollectionUtils.isEmpty(mainBudgetItemCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(BudgetItemMainItemEntity::getMainBudgetItemCode, mainBudgetItemCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}
