package com.biz.crm.tpm.business.budget.item.local.service.internal;

import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemControlConditionRepository;
import com.biz.crm.tpm.business.budget.item.local.service.BudgetItemControlConditionService;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemControlConditionVoService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月24日 15:43
 */
@Slf4j
@Service
public class BudgetItemControlConditionServiceImpl implements BudgetItemControlConditionVoService {

    @Autowired(required = false)
    private BudgetItemControlConditionRepository budgetItemControlConditionRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<BudgetItemControlConditionVo> findByCode(String code) {
        List<BudgetItemControlConditionEntity> byBudgetItemCode = budgetItemControlConditionRepository.findByBudgetItemCode(code);
        ArrayList<BudgetItemControlConditionVo> list = new ArrayList<>();
        byBudgetItemCode.forEach(b->{
            BudgetItemControlConditionVo budgetItemControlConditionVo = this.nebulaToolkitService.copyObjectByWhiteList(b, BudgetItemControlConditionVo.class, LinkedHashSet.class, ArrayList.class);
            list.add(budgetItemControlConditionVo);
        });
        return list;
    }

    @Override
    public List<String> findCodeForVariable(BudgetItemControlConditionDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(),"业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(),"业务单元不能为空!");
        Validate.notBlank(dto.getFeeBelongCode(),"费用归口不能为空！");
        Validate.notBlank(dto.getDepartmentBelongCode(),"部门归口不能为空！");
        List<String> codes = this.budgetItemControlConditionRepository.findCodeForVariable(dto);
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        return codes;
    }
}
