package com.biz.crm.tpm.business.budget.item.local.service.internal;

import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemMainItemEntity;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemMainItemRepository;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author huojia
 * @date 2022年12月08日 14:59
 */
@Slf4j
@Service
public class BudgetItemMainItemServiceImpl implements BudgetItemMainItemService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private BudgetItemMainItemRepository budgetItemMainItemRepository;

    /**
     * 根据主预算项目编码查询
     *
     * @param mainBudgetItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo>
     * @author huojia
     * @date 2022/12/8 15:00
     **/
    @Override
    public List<BudgetItemMainItemVo> listByMainBudgetItemCodeList(List<String> mainBudgetItemCodeList) {
        if (CollectionUtils.isEmpty(mainBudgetItemCodeList)) {
            return Lists.newArrayList();
        }
        List<BudgetItemMainItemEntity> budgetItemMainItemEntityList = this.budgetItemMainItemRepository.listByMainBudgetItemCodeList(mainBudgetItemCodeList);
        if (CollectionUtils.isEmpty(budgetItemMainItemEntityList)) {
            return Lists.newArrayList();
        }
        return (List<BudgetItemMainItemVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                budgetItemMainItemEntityList, BudgetItemMainItemEntity.class, BudgetItemMainItemVo.class, LinkedHashSet.class, ArrayList.class
        );
    }
}
