/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemEntity;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemDto;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemDataTypeVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/budget/item"})
@Api(tags={"\u9884\u7b97\u9879\u76ee"})
public class BudgetItemController {
    private static final Logger log = LoggerFactory.getLogger(BudgetItemController.class);
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private BudgetItemMainItemService budgetItemMainItemService;

    @ApiOperation(value="\u7531\u4e8e\u521b\u5efa\u6388\u6743\u6807\u7b7e\u6765\u907f\u514d\u91cd\u590d\u63d0\u4ea4\u7684\u95ee\u9898\u3002\u6240\u4ee5\u5728\u521b\u5efa\u524d\uff0c\u9700\u8981\u4f7f\u7528\u8be5\u65b9\u6cd5\u83b7\u5f97\u9884\u6388\u6743")
    @PostMapping(value={"/preSave"})
    public Result<?> preSave(Result<Object> ok) {
        try {
            String prefix = this.budgetItemService.preSave();
            return Result.ok((Object)prefix);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<BudgetItemVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="budgetItemDto", value="\u9884\u7b97\u9879\u76ee\u4fe1\u606f") BudgetItemDto dto) {
        try {
            Page page = this.budgetItemService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u4f53\u9884\u7b97\u9879\u76ee\uff0c\u67e5\u8be2\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"listByMainBudgetItemCodeList"})
    public Result<List<BudgetItemMainItemVo>> listByMainBudgetItemCodeList(@RequestBody List<String> mainBudgetItemCodeList) {
        try {
            List result = this.budgetItemMainItemService.listByMainBudgetItemCodeList(mainBudgetItemCodeList);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4e0a\u7ea7\u6570\u636e")
    @GetMapping(value={"listParent"})
    public Result<Page<BudgetItemVo>> listParent(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="budgetItemDto", value="\u9884\u7b97\u9879\u76ee\u4fe1\u606f") BudgetItemDto dto) {
        try {
            Page page = this.budgetItemService.listParent(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0a\u7ea7\u5bf9\u5e94\u6570\u636e\u7c7b\u578b")
    @PostMapping(value={"listParentDataType"})
    public Result<List<BudgetItemDataTypeVo>> listParentDataType(@RequestBody BudgetItemDto dto) {
        try {
            List dataTypeVos = this.budgetItemService.listParentDataType(dto);
            return Result.ok((Object)dataTypeVos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4e3b\u4f53\u9884\u7b97\u9879\u76ee")
    @GetMapping(value={"listMainItem"})
    public Result<Page<BudgetItemVo>> listMainItem(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="budgetItemDto", value="\u9884\u7b97\u9879\u76ee\u4fe1\u606f") BudgetItemDto dto) {
        try {
            Page page = this.budgetItemService.listMainItem(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u9884\u7b97\u9879\u76ee\u6811\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/resetRuleCode"})
    public Result<?> resetRuleCode() {
        try {
            this.budgetItemService.updateRuleCode();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u7b97\u79d1\u76ee\u6811", notes="\u4ec0\u4e48\u90fd\u4e0d\u4f20\u8fd4\u56de\u7b2c\u4e00\u5c42\uff0c\u4f20parentCode\u8fd4\u56de\u8fd9\u4e2a\u7f16\u7801\u7684\u4e0b\u4e00\u7ea7\uff0c\u4f20name\u6a21\u7cca\u67e5\u8be2\u5e76\u4e14\u67e5\u8be2\u51fa\u6240\u6709\u4e0a\u7ea7\u518d\u6784\u5efa\u6210\u6811\u5f62\uff0c\u4f18\u5148\u7ea7parentCode > name")
    @GetMapping(value={"/budgetItemLazyTree"})
    public Result<List<LazyTreeVo>> budgetItemLazyTree(@ApiParam(name="treeDto", value="\u67e5\u8be2Dto") TreeDto treeDto) {
        return Result.ok((Object)this.budgetItemService.budgetSubjectsLazyTree(treeDto));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"detail"})
    public Result<BudgetItemVo> detail(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            BudgetItemVo budgetItemVo = this.budgetItemService.findById(id);
            return Result.ok((Object)budgetItemVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u9884\u7b97\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<BudgetItemVo> findByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u7f16\u53f7") String code) {
        try {
            BudgetItemVo budgetItemVo = this.budgetItemService.findByCode(code, null);
            return Result.ok((Object)budgetItemVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<BudgetItemVo> create(@ApiParam(name="budgetItemDto", value="TPM-\u9884\u7b97\u79d1\u76ee") @RequestBody BudgetItemDto dto) {
        try {
            BudgetItemVo result = this.budgetItemService.create(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e-\u80fd\u529b\u4e2d\u5fc3")
    @PostMapping(value={"create"})
    public Result<BudgetItemVo> feignCreate(@RequestBody BudgetItemDto dto) {
        try {
            BudgetItemVo result = this.budgetItemService.create(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, BudgetItemEntity.class));
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<BudgetItemVo> update(@ApiParam(name="budgetItemDto", value="TPM-\u9884\u7b97\u79d1\u76ee") @RequestBody BudgetItemDto dto) {
        try {
            BudgetItemVo result = this.budgetItemService.update(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.budgetItemService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6839\u636eid\u542f\u7528")
    @PatchMapping(value={"enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.budgetItemService.enable(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6839\u636eid\u7981\u7528")
    @PatchMapping(value={"disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.budgetItemService.disable(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6839\u636eid\u7981\u7528")
    @PostMapping(value={"disablePost"})
    public Result<?> disablePost(@RequestBody List<String> ids) {
        try {
            this.budgetItemService.disable(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9879\u76ee")
    @GetMapping(value={"listSubsidiaryCompaniesBudgetItem"})
    public Result<Page<BudgetItemVo>> listSubsidiaryCompaniesBudgetItem(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="budgetItemDto", value="\u9884\u7b97\u9879\u76ee\u4fe1\u606f") BudgetItemDto dto) {
        try {
            Page page = this.budgetItemService.listSubsidiaryCompaniesBudgetItem(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

