/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.interceptor;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class BudgetItemInterceptor
implements ExternalQueryInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BudgetItemInterceptor.class);
    private static final String BUSINESS_UNIT_CODE = "business_unit_code";
    @Resource
    private DictDataVoService dictDataVoService;

    public String code() {
        return "tpm_budget_item_data_view_business_unit_code";
    }

    public String name() {
        return "\u4e1a\u52a1\u5355\u5143";
    }

    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String ... strings) {
        List results = executeContent.getResults();
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        List businessUnit = this.dictDataVoService.findByDictTypeCode("mdm_business_unit");
        Map businessUnitMap = businessUnit.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        ArrayList contents = Lists.newArrayList();
        results.forEach(item -> {
            if (null == item) {
                contents.add(null);
                return;
            }
            ArrayList businessUnitNameArray = Lists.newArrayList();
            String businessUnitCodeStr = (String)item.get(BUSINESS_UNIT_CODE);
            if (StringUtils.hasText((String)businessUnitCodeStr)) {
                String[] businessUnitCodeArray = businessUnitCodeStr.split(",");
                ArrayList businessUnitNameList = Lists.newArrayList();
                for (int i = 0; i < businessUnitCodeArray.length; ++i) {
                    DictDataVo dictDataVo = (DictDataVo)businessUnitMap.get(businessUnitCodeArray[i]);
                    if (ObjectUtils.isEmpty((Object)dictDataVo)) continue;
                    businessUnitNameList.add(dictDataVo.getDictValue());
                }
                if (CollectionUtils.isEmpty((Collection)businessUnitNameList)) {
                    businessUnitNameArray.add(businessUnitCodeStr);
                } else {
                    String businessUnitNameStr = String.join((CharSequence)",", businessUnitNameList);
                    businessUnitNameArray.add(businessUnitNameStr);
                }
            } else {
                businessUnitNameArray.add(businessUnitCodeStr);
            }
            contents.add(businessUnitNameArray.toArray(new Object[0]));
        });
        return contents;
    }
}

