/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.notifier;

import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemEntity;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemRepository;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemDto;
import com.biz.crm.tpm.business.budget.item.sdk.event.BudgetItemEventListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ItemForBudgetItemEventListener
implements BudgetItemEventListener {
    private static final Logger log = LoggerFactory.getLogger(ItemForBudgetItemEventListener.class);
    @Autowired(required=false)
    private BudgetItemRepository budgetItemRepository;

    public void onCreated(BudgetItemDto reqVo) {
    }

    public void onUpdate(BudgetItemDto oldDto, BudgetItemDto newDto) {
        List<BudgetItemEntity> childrenList = this.budgetItemRepository.findChildrenListByParentCode(oldDto.getBudgetItemCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        childrenList.forEach(children -> children.setParentBudgetItemName(newDto.getParentBudgetItemName()));
        this.budgetItemRepository.updateBatchById(childrenList);
    }

    public void onDeleted(BudgetItemDto reqVo) {
    }

    public void onEnable(BudgetItemDto reqVo) {
    }

    public void onDisable(BudgetItemDto reqVo) {
    }
}

