/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity;
import com.biz.crm.tpm.business.budget.item.local.mapper.BudgetItemControlConditionMapper;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetItemControlConditionRepository
extends ServiceImpl<BudgetItemControlConditionMapper, BudgetItemControlConditionEntity> {
    public List<BudgetItemControlConditionEntity> findByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty((CharSequence)budgetItemCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetItemControlConditionEntity::getBudgetItemCode, (Object)budgetItemCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<BudgetItemControlConditionEntity> findByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void delByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty((CharSequence)budgetItemCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetItemControlConditionEntity::getBudgetItemCode, (Object)budgetItemCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetItemControlConditionEntity -> budgetItemControlConditionEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public void delByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCodes)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetItemControlConditionEntity -> budgetItemControlConditionEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public List<BudgetItemControlConditionEntity> listByBusinessUnitCode(String businessUnitCode) {
        if (StringUtils.isEmpty((CharSequence)businessUnitCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetItemControlConditionEntity::getBusinessUnitCode, (Object)businessUnitCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<BudgetItemControlConditionEntity> listByBudgetItemCodeList(List<String> budgetItemCodeList) {
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemControlConditionEntity::getBudgetItemCode, budgetItemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<String> findCodeForVariable(BudgetItemControlConditionDto dto) {
        return ((BudgetItemControlConditionMapper)this.baseMapper).findCodeForVariable(dto, TenantUtils.getTenantCode());
    }
}

