/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemMainItemEntity;
import com.biz.crm.tpm.business.budget.item.local.mapper.BudgetItemMainItemMapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetItemMainItemRepository
extends ServiceImpl<BudgetItemMainItemMapper, BudgetItemMainItemEntity> {
    public List<BudgetItemMainItemEntity> findByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty((CharSequence)budgetItemCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetItemMainItemEntity::getBudgetItemCode, (Object)budgetItemCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<BudgetItemMainItemEntity> findByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemMainItemEntity::getBudgetItemCode, budgetItemCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void delByBudgetItemCode(String budgetItemCode) {
        if (StringUtils.isEmpty((CharSequence)budgetItemCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetItemMainItemEntity::getBudgetItemCode, (Object)budgetItemCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetItemMainItemEntity -> budgetItemMainItemEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public void delByBudgetItemCodes(List<String> budgetItemCodes) {
        if (CollectionUtils.isEmpty(budgetItemCodes)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemMainItemEntity::getBudgetItemCode, budgetItemCodes)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetItemMainItemEntity -> budgetItemMainItemEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public List<BudgetItemMainItemEntity> listByMainBudgetItemCodeList(List<String> mainBudgetItemCodeList) {
        if (CollectionUtils.isEmpty(mainBudgetItemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemMainItemEntity::getMainBudgetItemCode, mainBudgetItemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

