/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemEntity;
import com.biz.crm.tpm.business.budget.item.local.mapper.BudgetItemMapper;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemDto;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetItemRepository
extends ServiceImpl<BudgetItemMapper, BudgetItemEntity> {
    @Autowired(required=false)
    private BudgetItemMapper budgetItemMapper;

    public BudgetItemEntity getById(String id, String delFlag) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (BudgetItemEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).one());
    }

    public BudgetItemEntity getByBudgetItemCode(String code, String enableStatus) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        return (BudgetItemEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetItemEntity::getBudgetItemCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).one());
    }

    public List<BudgetItemEntity> getByBudgetItemCodes(List<String> codes, String enableStatus) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemEntity::getBudgetItemCode, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).list();
    }

    public List<BudgetItemEntity> findChildrenListByParentCode(String parentCode) {
        parentCode = Optional.ofNullable(parentCode).orElse("");
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)parentCode), BudgetItemEntity::getParentBudgetItemCode, (Object)parentCode)).and(StringUtils.isEmpty((CharSequence)parentCode), qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(BudgetItemEntity::getParentBudgetItemCode)).or()).eq(BudgetItemEntity::getParentBudgetItemCode, (Object)"");
        })).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<BudgetItemEntity> findListWithoutParentCode() {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(BudgetItemEntity::getParentBudgetItemCode)).or()).eq(BudgetItemEntity::getParentBudgetItemCode, (Object)"");
        })).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<BudgetItemEntity> findItemCodeAndRuleCodeByEnableStatusOptAndItemNameLike(String enableStatus, String name) {
        List likeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).like(BudgetItemEntity::getBudgetItemName, (Object)name)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).select(new SFunction[]{BudgetItemEntity::getBudgetItemCode, TenantFlagTreeOpEntity::getRuleCode}).list();
        return likeList;
    }

    public List<BudgetItemEntity> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(StringUtils.isNotEmpty((CharSequence)delFlag), UuidFlagOpEntity::getDelFlag, (Object)delFlag)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<BudgetItemEntity> listByBudgetItemCodeList(List<String> mainBudgetItemCodeList, String enableStatus) {
        if (CollectionUtils.isEmpty(mainBudgetItemCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemEntity::getBudgetItemCode, mainBudgetItemCodeList)).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<BudgetItemEntity> listByParent(List<String> parentCodeList) {
        if (CollectionUtils.isEmpty(parentCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetItemEntity::getParentBudgetItemCode, parentCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<BudgetItemVo> findByMainBudgetItem(BudgetItemDto dto) {
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((BudgetItemMapper)this.baseMapper).findByMainBudgetItem(dto);
    }

    public Page<BudgetItemVo> listSubsidiaryCompaniesBudgetItem(Page<BudgetItemVo> page, BudgetItemDto dto) {
        return this.budgetItemMapper.listSubsidiaryCompaniesBudgetItem(page, dto);
    }

    public List<BudgetItemEntity> listByParentCodes(List<String> parentCodeList) {
        if (CollectionUtils.isEmpty(parentCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(BudgetItemEntity::getParentBudgetItemCode, parentCodeList)).list();
    }
}

