/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.service.internal;

import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemControlConditionRepository;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemControlConditionVoService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BudgetItemControlConditionServiceImpl
implements BudgetItemControlConditionVoService {
    private static final Logger log = LoggerFactory.getLogger(BudgetItemControlConditionServiceImpl.class);
    @Autowired(required=false)
    private BudgetItemControlConditionRepository budgetItemControlConditionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<BudgetItemControlConditionVo> findByCode(String code) {
        List<BudgetItemControlConditionEntity> byBudgetItemCode = this.budgetItemControlConditionRepository.findByBudgetItemCode(code);
        ArrayList<BudgetItemControlConditionVo> list = new ArrayList<BudgetItemControlConditionVo>();
        byBudgetItemCode.forEach(b -> {
            BudgetItemControlConditionVo budgetItemControlConditionVo = (BudgetItemControlConditionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)b, BudgetItemControlConditionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            list.add(budgetItemControlConditionVo);
        });
        return list;
    }

    public List<String> findCodeForVariable(BudgetItemControlConditionDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeBelongCode(), (String)"\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDepartmentBelongCode(), (String)"\u90e8\u95e8\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<String> codes = this.budgetItemControlConditionRepository.findCodeForVariable(dto);
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        return codes;
    }
}

