/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemControlConditionEntity;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemEntity;
import com.biz.crm.tpm.business.budget.item.local.entity.BudgetItemMainItemEntity;
import com.biz.crm.tpm.business.budget.item.local.mapper.BudgetItemMapper;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemControlConditionRepository;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemMainItemRepository;
import com.biz.crm.tpm.business.budget.item.local.repository.BudgetItemRepository;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemDto;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemLogEventDto;
import com.biz.crm.tpm.business.budget.item.sdk.event.BudgetItemEventListener;
import com.biz.crm.tpm.business.budget.item.sdk.event.BudgetItemLogEventListener;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemDataTypeVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BudgetItemServiceImpl
implements BudgetItemService {
    private static final Logger log = LoggerFactory.getLogger(BudgetItemServiceImpl.class);
    @Autowired(required=false)
    private BudgetItemMapper budgetItemMapper;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private BudgetItemRepository budgetItemRepository;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;
    @Autowired(required=false)
    private BudgetItemMainItemRepository budgetItemMainItemRepository;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired(required=false)
    private List<BudgetItemEventListener> budgetItemEventListenerList;
    @Autowired(required=false)
    private BudgetItemControlConditionRepository controlConditionRepository;

    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    public Page<BudgetItemVo> findByConditions(Pageable pageable, BudgetItemDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new BudgetItemDto();
        }
        List selectedCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            selectedCodeList.add(dto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            dto.setSelectedCodeList(selectedCodeList);
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.budgetItemMapper.findByConditions((Page<BudgetItemVo>)page, dto);
    }

    public Page<BudgetItemVo> listParent(Pageable pageable, BudgetItemDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)25));
        if (Objects.isNull(dto)) {
            dto = new BudgetItemDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getBudgetItemLevelCode())) {
            throw new RuntimeException("\u67e5\u8be2\u4e0a\u7ea7\u9884\u7b97\u5931\u8d25\uff0c\u5f53\u524d\u9884\u7b97\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int itemLevel = Integer.parseInt(dto.getBudgetItemLevelCode());
        if (itemLevel <= 1) {
            return new Page();
        }
        dto.setBudgetItemLevelCode(String.valueOf(Integer.parseInt(dto.getBudgetItemLevelCode()) - 1));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<BudgetItemVo> pageResult = this.budgetItemMapper.listParent((Page<BudgetItemVo>)page, dto);
        List records = pageResult.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            Map dataTypeMap = this.dictToolkitService.findMapByDictTypeCode("tpm_budget_data_type");
            records.forEach(record -> {
                if (StringUtils.isNotEmpty((CharSequence)record.getDataTypeCode())) {
                    List<String> dataTypeCodeList = Arrays.asList(record.getDataTypeCode().split(","));
                    ArrayList dataTypeList = new ArrayList();
                    dataTypeCodeList.forEach(dataTypeCode -> {
                        BudgetItemDataTypeVo budgetItemDataTypeVo = new BudgetItemDataTypeVo();
                        budgetItemDataTypeVo.setDataTypeCode(dataTypeCode);
                        budgetItemDataTypeVo.setDataTypeName((String)dataTypeMap.get(dataTypeCode));
                        dataTypeList.add(budgetItemDataTypeVo);
                    });
                    record.setDataTypeList(dataTypeList);
                }
            });
            pageResult.setRecords(records);
        }
        return pageResult;
    }

    public List<BudgetItemDataTypeVo> listParentDataType(BudgetItemDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList<BudgetItemDataTypeVo> result = new ArrayList<BudgetItemDataTypeVo>();
        List dictDataVos = this.dictDataVoService.findByDictTypeCode("tpm_budget_data_type");
        if (!CollectionUtils.isEmpty((Collection)dictDataVos)) {
            dictDataVos.forEach(dictDataVo -> {
                BudgetItemDataTypeVo budgetItemDataTypeVo = new BudgetItemDataTypeVo();
                budgetItemDataTypeVo.setDataTypeCode(dictDataVo.getDictCode());
                budgetItemDataTypeVo.setDataTypeName(dictDataVo.getDictValue());
                result.add(budgetItemDataTypeVo);
            });
        }
        return result;
    }

    public List<LazyTreeVo> budgetSubjectsLazyTree(TreeDto dto) {
        BudgetItemEntity one;
        ArrayList<LazyTreeVo> list = new ArrayList<LazyTreeVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((CharSequence)dto.getExcludeCodeAndChildren()) && (one = this.budgetItemRepository.getByBudgetItemCode(dto.getExcludeCodeAndChildren(), null)) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (!StringUtils.isEmpty((CharSequence)dto.getParentCode())) {
            List<LazyTreeVo> lazyTreeVos = this.budgetItemMapper.findBudgetItemLazyTreeList(dto.getEnableStatus(), null, dto.getParentCode(), null, null, excludeRuleCode);
            list.addAll(lazyTreeVos);
        } else if (!StringUtils.isEmpty((CharSequence)dto.getName())) {
            List<BudgetItemEntity> likeList = this.budgetItemRepository.findItemCodeAndRuleCodeByEnableStatusOptAndItemNameLike(dto.getEnableStatus(), dto.getName());
            if (!CollectionUtils.isEmpty(likeList)) {
                TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
                Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(3, likeList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(this.budgetItemMapper.findBudgetItemLazyTreeList(dto.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode));
            }
        } else {
            list.addAll(this.budgetItemMapper.findBudgetItemLazyTreeList(dto.getEnableStatus(), true, null, null, null, excludeRuleCode));
        }
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(item -> item.setHasChild(Boolean.valueOf(BooleanEnum.TRUE.getNumStr().equalsIgnoreCase(String.valueOf(item.getHasChildFlag())))));
            return TreeUtil.generateLazyTreeByParentCode(list);
        }
        return new ArrayList<LazyTreeVo>();
    }

    public void updateRuleCode() {
        this.budgetItemMapper.updateOrphanParentCodeNull();
        List<BudgetItemEntity> topList = this.budgetItemRepository.findListWithoutParentCode();
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        log.info("updateRuleCode topList={}", (Object)topList.size());
        for (int i = 0; i < topList.size(); ++i) {
            log.info("updateRuleCode top={}", (Object)topList.get(i).getBudgetItemCode());
            this.updateCurAndChildrenRuleCode(topList.get(i).getBudgetItemCode(), treeRuleCodeStrategy.generateByNum(3, i + 1), 1);
        }
    }

    public Page<BudgetItemVo> listMainItem(Pageable pageable, BudgetItemDto dto) {
        List<BudgetItemControlConditionEntity> controlConditionEntityList;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)25));
        if (Objects.isNull(dto)) {
            dto = new BudgetItemDto();
        }
        if (CollectionUtils.isEmpty(controlConditionEntityList = this.controlConditionRepository.listByBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode()))) {
            return new Page();
        }
        Set budgetItemCodeSet = controlConditionEntityList.stream().map(BudgetItemControlConditionEntity::getBudgetItemCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(budgetItemCodeSet)) {
            return new Page();
        }
        ArrayList selectCodeList = new ArrayList(budgetItemCodeSet);
        selectCodeList.remove(dto.getExcludeCode());
        if (CollectionUtils.isEmpty(selectCodeList)) {
            return new Page();
        }
        dto.setSelectedCodeList(selectCodeList);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<BudgetItemVo> result = this.budgetItemMapper.listByBudgetItemCodeList((Page<BudgetItemVo>)page, dto);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<BudgetItemDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        ArrayList controlConditionDtoList = new ArrayList();
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            dto.getControlConditionDtoList().forEach(controlConditionDto -> {
                controlConditionDto.setBudgetItemCode(dto.getBudgetItemCode());
                controlConditionDtoList.add(controlConditionDto);
            });
        });
        ArrayList budgetItemEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(importList, BudgetItemDto.class, BudgetItemEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.budgetItemRepository.saveBatch(budgetItemEntities);
        if (!CollectionUtils.isEmpty(this.budgetItemEventListenerList)) {
            importList.forEach(dto -> {
                for (BudgetItemEventListener budgetItemEventListener : this.budgetItemEventListenerList) {
                    budgetItemEventListener.onCreated(dto);
                }
            });
        }
        Collection controlConditionEntities = this.nebulaToolkitService.copyCollectionByBlankList(controlConditionDtoList, BudgetItemControlConditionDto.class, BudgetItemControlConditionEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.controlConditionRepository.saveBatch(new ArrayList(controlConditionEntities));
        importList.forEach(dto -> {
            BudgetItemLogEventDto logEventDto = new BudgetItemLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = BudgetItemLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetItemLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
        this.updateRuleCode();
    }

    public List<BudgetItemVo> listByCodes(List<String> budgetItemCodeList) {
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return Lists.newArrayList();
        }
        List<BudgetItemEntity> budgetItemEntities = this.budgetItemRepository.listByBudgetItemCodeList(budgetItemCodeList, EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isEmpty(budgetItemEntities)) {
            return Lists.newArrayList();
        }
        ArrayList budgetItemVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(budgetItemEntities, BudgetItemEntity.class, BudgetItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        List<BudgetItemControlConditionEntity> controlConditionList = this.controlConditionRepository.listByBudgetItemCodeList(budgetItemCodeList);
        if (!CollectionUtils.isEmpty(controlConditionList)) {
            List budgetItemControlConditionVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(controlConditionList, BudgetItemControlConditionEntity.class, BudgetItemControlConditionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Map<String, List<BudgetItemControlConditionVo>> controlConditionMap = budgetItemControlConditionVos.stream().collect(Collectors.groupingBy(BudgetItemControlConditionVo::getBudgetItemCode));
            budgetItemVos.forEach(budgetItemVo -> budgetItemVo.setControlConditionDtoList((List)controlConditionMap.get(budgetItemVo.getBudgetItemCode())));
        }
        return budgetItemVos;
    }

    public List<BudgetItemVo> listByCodesSimple(List<String> budgetItemCodeList) {
        if (CollectionUtils.isEmpty(budgetItemCodeList)) {
            return Lists.newArrayList();
        }
        List<BudgetItemEntity> budgetItemEntities = this.budgetItemRepository.listByBudgetItemCodeList(budgetItemCodeList, EnableStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isEmpty(budgetItemEntities)) {
            return Lists.newArrayList();
        }
        ArrayList budgetItemVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(budgetItemEntities, BudgetItemEntity.class, BudgetItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        return budgetItemVos;
    }

    public List<BudgetItemVo> listByMainBudgetItem(List<String> mainBudgetItemList) {
        if (CollectionUtils.isEmpty(mainBudgetItemList)) {
            return Lists.newArrayList();
        }
        List<BudgetItemMainItemEntity> budgetItemMainItemEntityList = this.budgetItemMainItemRepository.listByMainBudgetItemCodeList(mainBudgetItemList);
        if (CollectionUtils.isEmpty(budgetItemMainItemEntityList)) {
            return Lists.newArrayList();
        }
        Map<String, List<BudgetItemMainItemEntity>> mainBudgetItemMap = budgetItemMainItemEntityList.stream().collect(Collectors.groupingBy(BudgetItemMainItemEntity::getBudgetItemCode));
        List<String> budgetItemCodeList = budgetItemMainItemEntityList.stream().map(BudgetItemMainItemEntity::getBudgetItemCode).collect(Collectors.toList());
        List<BudgetItemEntity> budgetItemEntities = this.budgetItemRepository.listByBudgetItemCodeList(budgetItemCodeList, null);
        if (CollectionUtils.isEmpty(budgetItemEntities)) {
            return Lists.newArrayList();
        }
        List budgetItemVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetItemEntities, BudgetItemEntity.class, BudgetItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        budgetItemVos.forEach(budgetItemVo -> budgetItemVo.setBudgetItemMainItemList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)mainBudgetItemMap.get(budgetItemVo.getBudgetItemCode()), BudgetItemMainItemEntity.class, BudgetItemMainItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0])));
        return budgetItemVos;
    }

    public List<BudgetItemVo> listByParent(List<String> parentCodeList) {
        if (CollectionUtils.isEmpty(parentCodeList)) {
            return null;
        }
        List<BudgetItemEntity> budgetItemEntities = this.budgetItemRepository.listByParent(parentCodeList);
        if (CollectionUtils.isEmpty(budgetItemEntities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetItemEntities, BudgetItemEntity.class, BudgetItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private void updateCurAndChildrenRuleCode(String budgetItemCode, String ruleCode, int levelNum) {
        log.info("updateRuleCode budgetItemCode\uff1a{}\uff0cruleCode\uff1a{}\uff0clevelNum\uff1a{}", new Object[]{budgetItemCode, ruleCode, levelNum});
        BudgetItemEntity budgetItemEntity = this.budgetItemRepository.getByBudgetItemCode(budgetItemCode, null);
        if (budgetItemEntity == null) {
            return;
        }
        budgetItemEntity.setRuleCode(ruleCode);
        budgetItemEntity.setLevelNum(levelNum);
        this.budgetItemRepository.updateById((Object)budgetItemEntity);
        List<BudgetItemEntity> childrenList = this.budgetItemRepository.findChildrenListByParentCode(budgetItemCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < childrenList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(childrenList.get(i).getBudgetItemCode(), ruleCode + treeRuleCodeStrategy.generateByNum(3, i + 1), levelNum + 1);
        }
    }

    public BudgetItemVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        BudgetItemEntity budgetItemEntity = this.budgetItemRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull((Object)((Object)budgetItemEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return this.buildVo(budgetItemEntity);
    }

    public BudgetItemVo findByCode(String code, String enableStatus) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        BudgetItemEntity budgetItemEntity = this.budgetItemRepository.getByBudgetItemCode(code, enableStatus);
        Validate.notNull((Object)((Object)budgetItemEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return this.buildVo(budgetItemEntity);
    }

    public List<BudgetItemVo> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        return this.findByCodes(codes, EnableStatusEnum.ENABLE.getCode());
    }

    public List<BudgetItemVo> findByCodes(List<String> codes, String enableStatus) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<BudgetItemEntity> list = this.budgetItemRepository.getByBudgetItemCodes(codes, enableStatus);
        return this.buildVos(list);
    }

    private BudgetItemVo buildVo(BudgetItemEntity budgetItemEntity) {
        List<BudgetItemControlConditionEntity> controlConditionEntityList;
        if (ObjectUtils.isEmpty((Object)((Object)budgetItemEntity))) {
            return null;
        }
        BudgetItemVo vo = (BudgetItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetItemEntity, BudgetItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<BudgetItemMainItemEntity> mainItemEntityList = this.budgetItemMainItemRepository.findByBudgetItemCode(vo.getBudgetItemCode());
        if (!CollectionUtils.isEmpty(mainItemEntityList)) {
            Collection budgetItemMainItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(mainItemEntityList, BudgetItemMainItemEntity.class, BudgetItemMainItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            vo.setBudgetItemMainItemList(new ArrayList(budgetItemMainItemVos));
            vo.setMainBudgetItemCode(budgetItemMainItemVos.stream().map(BudgetItemMainItemVo::getMainBudgetItemCode).collect(Collectors.joining(",")));
        }
        if (!CollectionUtils.isEmpty(controlConditionEntityList = this.controlConditionRepository.findByBudgetItemCode(vo.getBudgetItemCode()))) {
            Collection controlConditionDtoList = this.nebulaToolkitService.copyCollectionByBlankList(controlConditionEntityList, BudgetItemControlConditionEntity.class, BudgetItemControlConditionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            vo.setControlConditionDtoList(new ArrayList(controlConditionDtoList));
        }
        return vo;
    }

    private List<BudgetItemVo> buildVos(List<BudgetItemEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List budgetItemVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, BudgetItemEntity.class, BudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<String> budgetItemCodes = budgetItemVos.stream().map(BudgetItemVo::getBudgetItemCode).distinct().collect(Collectors.toList());
        List<BudgetItemMainItemEntity> mainItemEntityList = this.budgetItemMainItemRepository.findByBudgetItemCodes(budgetItemCodes);
        Map<Object, Object> budgetMainItemMap = new HashMap();
        if (!CollectionUtils.isEmpty(mainItemEntityList)) {
            List budgetItemMainItemVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(mainItemEntityList, BudgetItemMainItemEntity.class, BudgetItemMainItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            budgetMainItemMap = budgetItemMainItemVos.stream().collect(Collectors.groupingBy(BudgetItemMainItemVo::getBudgetItemCode));
        }
        Map<Object, Object> controlMap = new HashMap();
        List<BudgetItemControlConditionEntity> controlConditionEntityList = this.controlConditionRepository.findByBudgetItemCodes(budgetItemCodes);
        if (!CollectionUtils.isEmpty(controlConditionEntityList)) {
            List controlConditionDtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(controlConditionEntityList, BudgetItemControlConditionEntity.class, BudgetItemControlConditionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            controlMap = controlConditionDtoList.stream().collect(Collectors.groupingBy(BudgetItemControlConditionVo::getBudgetItemCode));
        }
        for (BudgetItemVo vo : budgetItemVos) {
            if (budgetMainItemMap.containsKey(vo.getBudgetItemCode())) {
                vo.setBudgetItemMainItemList((List)budgetMainItemMap.get(vo.getBudgetItemCode()));
                vo.setMainBudgetItemCode(vo.getBudgetItemMainItemList().stream().map(BudgetItemMainItemVo::getMainBudgetItemCode).collect(Collectors.joining(",")));
            }
            if (!controlMap.containsKey(vo.getBudgetItemCode())) continue;
            vo.setControlConditionDtoList((List)controlMap.get(vo.getBudgetItemCode()));
        }
        return budgetItemVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetItemVo create(BudgetItemDto dto) {
        this.createValidate(dto);
        BudgetItemEntity budgetItemEntity = (BudgetItemEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetItemEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.generateRuleCodeByParentCode(budgetItemEntity);
        String mainBudgetItemCode = budgetItemEntity.getMainBudgetItemCode();
        budgetItemEntity.setMainBudgetItemCode(null);
        budgetItemEntity.setMainBudgetItemName(null);
        budgetItemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        budgetItemEntity.setTenantCode(TenantUtils.getTenantCode());
        this.budgetItemRepository.saveOrUpdate((Object)budgetItemEntity);
        dto.setId(budgetItemEntity.getId());
        if (!CollectionUtils.isEmpty(this.budgetItemEventListenerList)) {
            for (BudgetItemEventListener budgetItemEventListener : this.budgetItemEventListenerList) {
                budgetItemEventListener.onCreated(dto);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)mainBudgetItemCode)) {
            List<String> mainBudgetList = Arrays.asList(mainBudgetItemCode.split(","));
            ArrayList budgetItemMainItemEntities = new ArrayList();
            List<BudgetItemVo> budgetItemVos = this.listByCodes(mainBudgetList);
            Map map = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            mainBudgetList.forEach(mainBudgetCode -> {
                BudgetItemMainItemEntity budgetItemMainItemEntity = new BudgetItemMainItemEntity();
                budgetItemMainItemEntity.setBudgetItemCode(budgetItemEntity.getBudgetItemCode());
                budgetItemMainItemEntity.setMainBudgetItemCode((String)mainBudgetCode);
                if (!MapUtils.isEmpty((Map)map)) {
                    budgetItemMainItemEntity.setMainBudgetItemName(((BudgetItemVo)map.get(mainBudgetCode)).getBudgetItemName());
                }
                budgetItemMainItemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                budgetItemMainItemEntity.setTenantCode(TenantUtils.getTenantCode());
                budgetItemMainItemEntities.add(budgetItemMainItemEntity);
            });
            this.budgetItemMainItemRepository.saveBatch(budgetItemMainItemEntities);
        }
        Collection controlConditionEntities = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getControlConditionDtoList(), BudgetItemControlConditionDto.class, BudgetItemControlConditionEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.controlConditionRepository.saveBatch(new ArrayList(controlConditionEntities));
        BudgetItemLogEventDto logEventDto = new BudgetItemLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = BudgetItemLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetItemLogEventListener.class, (SerializableBiConsumer)onCreate);
        BudgetItemVo budgetItemVo = (BudgetItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList conditionVo = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)controlConditionEntities, BudgetItemControlConditionEntity.class, BudgetItemControlConditionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        budgetItemVo.setControlConditionDtoList(conditionVo);
        return budgetItemVo;
    }

    private void generateRuleCodeByParentCode(BudgetItemEntity budgetItemEntity) {
        int levelNum = 1;
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)budgetItemEntity.getParentBudgetItemCode())) {
            BudgetItemEntity parent = this.budgetItemRepository.getByBudgetItemCode(budgetItemEntity.getParentBudgetItemCode(), null);
            Validate.notNull((Object)((Object)parent), (String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
            levelNum = parent.getLevelNum() + 1;
            parentRuleCode = parent.getRuleCode();
        }
        budgetItemEntity.setParentBudgetItemCode(Optional.ofNullable(budgetItemEntity.getParentBudgetItemCode()).orElse(""));
        List<BudgetItemEntity> childrenListByParentCode = this.budgetItemRepository.findChildrenListByParentCode(budgetItemEntity.getParentBudgetItemCode());
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, BudgetItemEntity.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        String ruleCode = treeRuleCodeStrategy.generate(3, parentRuleCode, (List)childrenDto);
        budgetItemEntity.setRuleCode(ruleCode);
        budgetItemEntity.setLevelNum(levelNum);
    }

    private void createValidate(BudgetItemDto dto) {
        BudgetItemEntity historyBudgetItem;
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getBudgetItemCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBudgetItemName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBudgetItemLevelCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeAttrCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u8d39\u7528\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getControlConditionDtoList(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ba1\u63a7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BudgetItemEntity budgetItemEntity = this.budgetItemRepository.getByBudgetItemCode(dto.getBudgetItemCode(), null);
        Validate.isTrue((budgetItemEntity == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        AtomicInteger sort = new AtomicInteger(1);
        AtomicReference<Boolean> tag = new AtomicReference<Boolean>(true);
        dto.getControlConditionDtoList().forEach(controlConditionVo -> {
            controlConditionVo.setBudgetItemCode(dto.getBudgetItemCode());
            controlConditionVo.setTenantCode(TenantUtils.getTenantCode());
            controlConditionVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            controlConditionVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            Validate.notBlank((CharSequence)controlConditionVo.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)controlConditionVo.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)controlConditionVo.getControlTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ba1\u63a7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (sort.get() == 1 && BusinessUnitEnum.SON_COMPANY.getCode().equals(controlConditionVo.getBusinessUnitCode())) {
                tag.set(false);
            }
            sort.addAndGet(1);
        });
        if (Integer.parseInt(dto.getBudgetItemLevelCode()) != 1 && tag.get().booleanValue()) {
            Validate.notBlank((CharSequence)dto.getParentBudgetItemCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u975e\u4e00\u7ea7\u9884\u7b97\u9879\u76ee\uff0c\u9700\u8981\u9009\u62e9\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee[\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a]\uff01", (Object[])new Object[0]);
            BudgetItemEntity parentBudgetItem = this.budgetItemRepository.getByBudgetItemCode(dto.getParentBudgetItemCode(), null);
            if (ObjectUtils.isEmpty((Object)((Object)parentBudgetItem))) {
                throw new RuntimeException("\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee" + dto.getParentBudgetItemCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            dto.setParentBudgetItemName(parentBudgetItem.getBudgetItemName());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getMainBudgetItemCode())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getHistoryBudgetItemCode()) && (historyBudgetItem = this.budgetItemRepository.getByBudgetItemCode(dto.getHistoryBudgetItemCode(), null)) != null) {
            dto.setHistoryBudgetItemName(historyBudgetItem.getBudgetItemName());
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(BudgetItemDto dto) {
        String prefix = dto.getPrefix();
        Assert.hasLength((String)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!");
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(prefix, TimeUnit.MILLISECONDS, 1L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(prefix);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetItemVo update(BudgetItemDto dto) {
        List<BudgetItemEntity> childrenListByParentCode;
        this.updateValidate(dto);
        BudgetItemVo budgetItemVo = this.findById(dto.getId());
        if (ObjectUtils.isEmpty((Object)budgetItemVo)) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if (!StringUtils.equals((CharSequence)dto.getBudgetItemCode(), (CharSequence)budgetItemVo.getBudgetItemCode())) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\uff01");
        }
        if (!StringUtils.equals((CharSequence)dto.getBudgetItemLevelCode(), (CharSequence)budgetItemVo.getBudgetItemLevelCode()) && !CollectionUtils.isEmpty(childrenListByParentCode = this.budgetItemRepository.findChildrenListByParentCode(budgetItemVo.getBudgetItemCode()))) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u9884\u7b97\u9879\u76ee\u5df2\u5173\u8054\u4e0b\u7ea7\u9884\u7b97\u9879\u76ee\uff0c\u4e0d\u80fd\u4fee\u6539\u5c42\u7ea7\uff01");
        }
        BudgetItemDto oldVo = (BudgetItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetItemVo, BudgetItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<BudgetItemControlConditionEntity> controlConditionEntityList = this.controlConditionRepository.findByBudgetItemCode(dto.getBudgetItemCode());
        oldVo.setControlConditionDtoList(new ArrayList(this.nebulaToolkitService.copyCollectionByBlankList(controlConditionEntityList, BudgetItemControlConditionEntity.class, BudgetItemControlConditionDto.class, LinkedHashSet.class, ArrayList.class, new String[0])));
        BudgetItemEntity budgetItemEntity = (BudgetItemEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetItemEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        if (!StringUtils.equals((CharSequence)oldVo.getParentBudgetItemCode(), (CharSequence)dto.getParentBudgetItemCode())) {
            this.generateRuleCodeByParentCode(budgetItemEntity);
        }
        String mainBudgetItemCode = budgetItemEntity.getMainBudgetItemCode();
        budgetItemEntity.setMainBudgetItemCode(null);
        budgetItemEntity.setMainBudgetItemName(null);
        this.budgetItemRepository.saveOrUpdate((Object)budgetItemEntity);
        if (!CollectionUtils.isEmpty(this.budgetItemEventListenerList)) {
            for (BudgetItemEventListener budgetItemEventListener : this.budgetItemEventListenerList) {
                budgetItemEventListener.onUpdate(oldVo, dto);
            }
        }
        this.budgetItemMainItemRepository.delByBudgetItemCode(dto.getBudgetItemCode());
        if (!StringUtils.isEmpty((CharSequence)mainBudgetItemCode)) {
            List<String> mainBudgetList = Arrays.asList(mainBudgetItemCode.split(","));
            List<BudgetItemVo> budgetItemVos = this.listByCodes(mainBudgetList);
            Map map = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            ArrayList budgetItemMainItemEntities = new ArrayList();
            mainBudgetList.forEach(mainBudgetCode -> {
                BudgetItemMainItemEntity budgetItemMainItemEntity = new BudgetItemMainItemEntity();
                budgetItemMainItemEntity.setBudgetItemCode(budgetItemEntity.getBudgetItemCode());
                budgetItemMainItemEntity.setMainBudgetItemCode((String)mainBudgetCode);
                if (map.containsKey(mainBudgetCode)) {
                    budgetItemMainItemEntity.setMainBudgetItemName(((BudgetItemVo)map.get(mainBudgetCode)).getBudgetItemName());
                }
                budgetItemMainItemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                budgetItemMainItemEntity.setTenantCode(TenantUtils.getTenantCode());
                budgetItemMainItemEntities.add(budgetItemMainItemEntity);
            });
            this.budgetItemMainItemRepository.saveBatch(budgetItemMainItemEntities);
        }
        Collection controlConditionEntities = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getControlConditionDtoList(), BudgetItemControlConditionDto.class, BudgetItemControlConditionEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.controlConditionRepository.delByBudgetItemCode(dto.getBudgetItemCode());
        this.controlConditionRepository.saveOrUpdateBatch(new ArrayList(controlConditionEntities));
        BudgetItemLogEventDto logEventDto = new BudgetItemLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = BudgetItemLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetItemLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (BudgetItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private void updateValidate(BudgetItemDto dto) {
        BudgetItemEntity historyBudgetItem;
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBudgetItemCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBudgetItemName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBudgetItemLevelCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFeeAttrCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u8d39\u7528\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getControlConditionDtoList(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7ba1\u63a7\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        AtomicReference<Boolean> tag = new AtomicReference<Boolean>(true);
        AtomicInteger sort = new AtomicInteger(1);
        dto.getControlConditionDtoList().forEach(controlConditionVo -> {
            controlConditionVo.setBudgetItemCode(dto.getBudgetItemCode());
            controlConditionVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            controlConditionVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            Validate.notBlank((CharSequence)controlConditionVo.getBusinessFormatCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)controlConditionVo.getBusinessUnitCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)controlConditionVo.getControlTypeCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u7ba1\u63a7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (sort.get() == 1 && BusinessUnitEnum.SON_COMPANY.getCode().equals(controlConditionVo.getBusinessUnitCode())) {
                tag.set(false);
            }
            sort.addAndGet(1);
            if (StringUtils.isEmpty((CharSequence)controlConditionVo.getTenantCode())) {
                controlConditionVo.setTenantCode(TenantUtils.getTenantCode());
            }
        });
        if (Integer.parseInt(dto.getBudgetItemLevelCode()) != 1 && tag.get().booleanValue()) {
            Validate.notBlank((CharSequence)dto.getParentBudgetItemCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u975e\u4e00\u7ea7\u9884\u7b97\u9879\u76ee\uff0c\u9700\u8981\u9009\u62e9\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee[\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a]\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getParentBudgetItemName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u975e\u4e00\u7ea7\u9884\u7b97\u9879\u76ee\uff0c\u9700\u8981\u9009\u62e9\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee[\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a]\uff01", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getMainBudgetItemCode())) {
            // empty if block
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getHistoryBudgetItemCode()) && (historyBudgetItem = this.budgetItemRepository.getByBudgetItemCode(dto.getHistoryBudgetItemCode(), null)) != null) {
            dto.setHistoryBudgetItemName(historyBudgetItem.getBudgetItemName());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
        }
        List budgetItemEntities = this.budgetItemRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)budgetItemEntities)) {
            return;
        }
        List budgetItemCodeList = budgetItemEntities.stream().map(BudgetItemEntity::getBudgetItemCode).collect(Collectors.toList());
        List subComMonthBudgetVoList = this.subComMonthBudgetService.listByBudgetItemCodeList(budgetItemCodeList);
        if (!CollectionUtils.isEmpty((Collection)subComMonthBudgetVoList)) {
            throw new RuntimeException("\u9884\u7b97\u9879\u76ee" + ((SubComMonthBudgetVo)subComMonthBudgetVoList.get(0)).getBudgetItemCode() + "\u5173\u8054\u5206\u5b50\u516c\u53f8\u6708\u5ea6\u9884\u7b97" + ((SubComMonthBudgetVo)subComMonthBudgetVoList.get(0)).getMonthBudgetCode() + "\u65e0\u6cd5\u5220\u9664\uff01");
        }
        budgetItemEntities.forEach(budgetItemEntity -> {
            List<BudgetItemEntity> childrenListByParentCode = this.budgetItemRepository.findChildrenListByParentCode(budgetItemEntity.getBudgetItemCode());
            if (!CollectionUtils.isEmpty(childrenListByParentCode)) {
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee:" + budgetItemEntity.getBudgetItemCode() + "\u5df2\u7ef4\u62a4\u4e0b\u7ea7\u9884\u7b97\u9879\u76ee\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            budgetItemEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.budgetItemRepository.updateBatchById(budgetItemEntities);
        List<String> budgetItemCodes = budgetItemEntities.stream().map(BudgetItemEntity::getBudgetItemCode).collect(Collectors.toList());
        this.budgetItemMainItemRepository.delByBudgetItemCodes(budgetItemCodes);
        this.controlConditionRepository.delByBudgetItemCodes(budgetItemCodes);
        budgetItemEntities.forEach(budgetItemEntity -> {
            BudgetItemLogEventDto logEventDto = new BudgetItemLogEventDto();
            logEventDto.setOriginal((BudgetItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetItemEntity, BudgetItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = BudgetItemLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetItemLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u6570\u636e\uff01");
        }
        List<BudgetItemEntity> budgetItemEntities = this.budgetItemRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(budgetItemEntities)) {
            return;
        }
        budgetItemEntities.forEach(budgetItemEntity -> {
            if (EnableStatusEnum.ENABLE.getCode().equals(budgetItemEntity.getEnableStatus())) {
                throw new RuntimeException("\u542f\u7528\u5931\u8d25\uff0c\u53ea\u80fd\u9009\u62e9\u7981\u7528\u72b6\u6001\u9884\u7b97\u9879\u76ee");
            }
            budgetItemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        this.budgetItemRepository.updateBatchById(budgetItemEntities);
        budgetItemEntities.forEach(budgetItemEntity -> {
            BudgetItemLogEventDto logEventDto = new BudgetItemLogEventDto();
            logEventDto.setOriginal((BudgetItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetItemEntity, BudgetItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onEnable = BudgetItemLogEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetItemLogEventListener.class, (SerializableBiConsumer)onEnable);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u6570\u636e");
        }
        List<BudgetItemEntity> budgetItemEntities = this.budgetItemRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(budgetItemEntities)) {
            return;
        }
        List<String> budgetItemCodeList = budgetItemEntities.stream().map(BudgetItemEntity::getBudgetItemCode).collect(Collectors.toList());
        List<BudgetItemEntity> list = this.budgetItemRepository.listByParentCodes(budgetItemCodeList);
        List relateCodeList = list.stream().map(BudgetItemEntity::getParentBudgetItemCode).distinct().collect(Collectors.toList());
        budgetItemEntities.forEach(budgetItemEntity -> {
            if (EnableStatusEnum.DISABLE.getCode().equals(budgetItemEntity.getEnableStatus())) {
                throw new RuntimeException("\u7981\u7528\u5931\u8d25\uff0c\u53ea\u80fd\u9009\u62e9\u542f\u7528\u72b6\u6001\u9884\u7b97\u9879\u76ee");
            }
            Validate.isTrue((!relateCodeList.contains(budgetItemEntity.getBudgetItemCode()) ? 1 : 0) != 0, (String)"\u9884\u7b97\u9879\u76ee[%s]\u5df2\u88ab\u5173\u8054\uff0c\u65e0\u6cd5\u7981\u7528", (Object[])new Object[]{budgetItemEntity.getBudgetItemCode()});
            budgetItemEntity.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        });
        this.budgetItemRepository.updateBatchById(budgetItemEntities);
        budgetItemEntities.forEach(budgetItemEntity -> {
            BudgetItemLogEventDto logEventDto = new BudgetItemLogEventDto();
            logEventDto.setOriginal((BudgetItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetItemEntity, BudgetItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDisable = BudgetItemLogEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetItemLogEventListener.class, (SerializableBiConsumer)onDisable);
        });
    }

    public List<BudgetItemVo> findByMainBudgetItem(List<String> mainBudgetItemCodes, String businessFormatCode) {
        BudgetItemDto dto = new BudgetItemDto();
        dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        dto.setMainBudgetItemCodes(mainBudgetItemCodes);
        dto.setBusinessFormatCode(businessFormatCode);
        return this.budgetItemRepository.findByMainBudgetItem(dto);
    }

    public Page<BudgetItemVo> listSubsidiaryCompaniesBudgetItem(Pageable pageable, BudgetItemDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new BudgetItemDto();
        }
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<BudgetItemVo> result = this.budgetItemRepository.listSubsidiaryCompaniesBudgetItem((Page<BudgetItemVo>)page, dto);
        return result;
    }
}

