/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.item.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemControlConditionDto;
import com.biz.crm.tpm.business.budget.item.sdk.dto.BudgetItemDto;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemImportsVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetItemImportsProcess
implements ImportProcess<BudgetItemImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(BudgetItemImportsProcess.class);
    @Resource
    private BudgetItemService budgetItemService;
    @Resource
    private DictToolkitService dictToolkitService;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    private Map<String, String> tpmBudgetFeeAttrMap = new HashMap<String, String>();
    private Map<String, String> tpmBudgetItemLevelMap = new HashMap<String, String>();
    private Map<String, String> tpmBudgetDataTypeMap = new HashMap<String, String>();
    private Map<String, String> mdmBusinessFormatMap = new HashMap<String, String>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<String, String>();
    private Map<String, String> tpmBudgetControlTypeMap = new HashMap<String, String>();
    private Map<String, String> tpmFeeBelongMap = new HashMap<String, String>();
    private Map<String, String> tpmDepartmentBelongMap = new HashMap<String, String>();
    private Map<String, BudgetItemVo> budgetItemVoMap = new HashMap<String, BudgetItemVo>();

    public Map<Integer, String> execute(LinkedHashMap<Integer, BudgetItemImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<BudgetItemDto> importList = this.validate(data);
        this.budgetItemService.importSave(importList);
        return null;
    }

    private List<BudgetItemDto> validate(LinkedHashMap<Integer, BudgetItemImportsVo> data) {
        ArrayList<BudgetItemImportsVo> budgetItemImportsVos = new ArrayList<BudgetItemImportsVo>(data.values());
        budgetItemImportsVos.forEach(budgetItemImportsVo -> {
            if (StringUtils.isEmpty((CharSequence)budgetItemImportsVo.getBudgetItemCode())) {
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        });
        ArrayList<BudgetItemDto> budgetItemDtoList = new ArrayList<BudgetItemDto>();
        this.buildBaseMap(budgetItemImportsVos);
        Map<String, List<BudgetItemImportsVo>> itemMap = budgetItemImportsVos.stream().collect(Collectors.groupingBy(BudgetItemImportsVo::getBudgetItemCode));
        itemMap.forEach((key, value) -> {
            if (CollectionUtils.isEmpty((Collection)value)) {
                return;
            }
            BudgetItemImportsVo budgetItemImportsVo = (BudgetItemImportsVo)value.get(0);
            this.buildBaseData(budgetItemImportsVo);
            this.buildDetailData((List<BudgetItemImportsVo>)value);
            ArrayList controlConditionDtoList = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)value, BudgetItemImportsVo.class, BudgetItemControlConditionDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            BudgetItemDto budgetItemDto = (BudgetItemDto)this.nebulaToolkitService.copyObjectByWhiteList(value.get(0), BudgetItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            budgetItemDto.setControlConditionDtoList(controlConditionDtoList);
            budgetItemDtoList.add(budgetItemDto);
        });
        return budgetItemDtoList;
    }

    private void buildDetailData(List<BudgetItemImportsVo> value) {
        value.forEach(importsVo -> {
            Validate.notBlank((CharSequence)importsVo.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getControlTypeCode(), (String)"\u7ba1\u63a7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getFeeBelongCode(), (String)"\u8d39\u7528\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getDepartmentBelongCode(), (String)"\u90e8\u95e8\u5f52\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (!this.mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new RuntimeException("\u4e1a\u6001" + importsVo.getBusinessFormatCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessFormatCode(this.mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            if (!this.mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new RuntimeException("\u4e1a\u52a1\u5355\u5143" + importsVo.getBusinessUnitCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setBusinessUnitCode(this.mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode()));
            if (!this.tpmBudgetControlTypeMap.containsKey(importsVo.getControlTypeCode())) {
                throw new RuntimeException("\u7ba1\u63a7\u7c7b\u578b" + importsVo.getControlTypeCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setControlTypeCode(this.tpmBudgetControlTypeMap.get(importsVo.getControlTypeCode()));
            if (!this.tpmFeeBelongMap.containsKey(importsVo.getFeeBelongCode())) {
                throw new RuntimeException("\u8d39\u7528\u5f52\u53e3" + importsVo.getFeeBelongCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setFeeBelongCode(this.tpmFeeBelongMap.get(importsVo.getFeeBelongCode()));
            if (!this.tpmDepartmentBelongMap.containsKey(importsVo.getDepartmentBelongCode())) {
                throw new RuntimeException("\u90e8\u95e8\u5f52\u53e3" + importsVo.getDepartmentBelongCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            importsVo.setDepartmentBelongCode(this.tpmDepartmentBelongMap.get(importsVo.getDepartmentBelongCode()));
        });
    }

    private void buildBaseData(BudgetItemImportsVo budgetItemImportsVo) {
        Validate.notEmpty((CharSequence)budgetItemImportsVo.getBudgetItemCode(), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)budgetItemImportsVo.getBudgetItemName(), (String)"\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)budgetItemImportsVo.getBudgetItemLevelCode(), (String)"\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)budgetItemImportsVo.getFeeAttrCode(), (String)"\u9884\u7b97\u8d39\u7528\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (this.budgetItemVoMap.containsKey(budgetItemImportsVo.getBudgetItemCode())) {
            throw new RuntimeException("\u9884\u7b97\u9879\u76ee\u7f16\u7801" + budgetItemImportsVo.getBudgetItemCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (this.tpmBudgetItemLevelMap.containsKey(budgetItemImportsVo.getBudgetItemLevelCode())) {
            budgetItemImportsVo.setBudgetItemLevelCode(this.tpmBudgetItemLevelMap.get(budgetItemImportsVo.getBudgetItemLevelCode()));
            if (Integer.parseInt(budgetItemImportsVo.getBudgetItemLevelCode()) != 1) {
                Validate.notBlank((CharSequence)budgetItemImportsVo.getParentBudgetItemCode(), (String)"\u9884\u7b97\u9879\u76ee\u5c42\u7ea7\u975e\u4e00\u7ea7\u9884\u7b97\u9879\u76ee\uff0c\u4e0a\u7ea7\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
        } else {
            throw new RuntimeException("\u9884\u7b97\u9879\u76ee\u5c42\u7ea7" + budgetItemImportsVo.getBudgetItemLevelCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!this.tpmBudgetFeeAttrMap.containsKey(budgetItemImportsVo.getFeeAttrCode())) {
            throw new RuntimeException("\u8d39\u7528\u5c5e\u6027" + budgetItemImportsVo.getFeeAttrCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        budgetItemImportsVo.setFeeAttrCode(this.tpmBudgetFeeAttrMap.get(budgetItemImportsVo.getFeeAttrCode()));
        if (!StringUtils.isEmpty((CharSequence)budgetItemImportsVo.getDataTypeCode())) {
            if (this.tpmBudgetDataTypeMap.containsKey(budgetItemImportsVo.getDataTypeCode())) {
                budgetItemImportsVo.setDataTypeCode(this.tpmBudgetDataTypeMap.get(budgetItemImportsVo.getDataTypeCode()));
            } else {
                throw new RuntimeException("\u6570\u636e\u7c7b\u578b" + budgetItemImportsVo.getDataTypeCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)budgetItemImportsVo.getParentBudgetItemCode())) {
            if (this.budgetItemVoMap.containsKey(budgetItemImportsVo.getParentBudgetItemCode())) {
                budgetItemImportsVo.setParentBudgetItemName(this.budgetItemVoMap.get(budgetItemImportsVo.getParentBudgetItemCode()).getBudgetItemName());
            } else {
                throw new RuntimeException("\u4e0a\u7ea7\u9884\u7b97\u7f16\u7801" + budgetItemImportsVo.getParentBudgetItemCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)budgetItemImportsVo.getMainBudgetItemCode())) {
            List<String> mainBudgetItemCodeList = Arrays.asList(budgetItemImportsVo.getMainBudgetItemCode().split(","));
            ArrayList mainBudgetItemNameList = new ArrayList();
            mainBudgetItemCodeList.forEach(mainBudgetItemCode -> {
                if (!this.budgetItemVoMap.containsKey(mainBudgetItemCode)) {
                    throw new RuntimeException("\u4e3b\u4f53\u9884\u7b97\u9879\u76ee\u7f16\u7801" + budgetItemImportsVo.getMainBudgetItemCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                mainBudgetItemNameList.add(this.budgetItemVoMap.get(mainBudgetItemCode).getBudgetItemName());
            });
            budgetItemImportsVo.setMainBudgetItemName(String.join((CharSequence)",", mainBudgetItemNameList));
        }
        if (!StringUtils.isEmpty((CharSequence)budgetItemImportsVo.getHistoryBudgetItemCode())) {
            if (this.budgetItemVoMap.containsKey(budgetItemImportsVo.getHistoryBudgetItemCode())) {
                budgetItemImportsVo.setHistoryBudgetItemName(this.budgetItemVoMap.get(budgetItemImportsVo.getHistoryBudgetItemCode()).getBudgetItemName());
            } else {
                throw new RuntimeException("\u5386\u53f2\u9884\u7b97\u9879\u76ee\u7f16\u7801" + budgetItemImportsVo.getHistoryBudgetItemCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    private void buildBaseMap(List<BudgetItemImportsVo> budgetItemImportsVos) {
        List<String> mainBudgetItemCodes;
        this.tpmBudgetFeeAttrMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_budget_fee_attr");
        this.tpmBudgetItemLevelMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_budget_item_level");
        this.tpmBudgetDataTypeMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_budget_data_type");
        this.mdmBusinessFormatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        this.mdmBusinessUnitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        this.tpmBudgetControlTypeMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_budget_control_type");
        this.tpmFeeBelongMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_fee_belong");
        this.tpmDepartmentBelongMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_department_belong");
        List budgetItemCodeList = budgetItemImportsVos.stream().map(BudgetItemImportsVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toList());
        List historyBudgetItemCodeList = budgetItemImportsVos.stream().map(BudgetItemImportsVo::getHistoryBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(historyBudgetItemCodeList)) {
            budgetItemCodeList.addAll(historyBudgetItemCodeList);
        }
        if (!CollectionUtils.isEmpty(mainBudgetItemCodes = budgetItemImportsVos.stream().map(BudgetItemImportsVo::getMainBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toList()))) {
            mainBudgetItemCodes.forEach(mainBudgetItemCode -> budgetItemCodeList.addAll(Arrays.asList(mainBudgetItemCode.split(","))));
        }
        List budgetItemVos = this.budgetItemService.listByCodes(budgetItemCodeList);
        this.budgetItemVoMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity(), (oldVo, newVo) -> newVo));
    }

    public Class<BudgetItemImportsVo> findCrmExcelVoClass() {
        return BudgetItemImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_BUDGET_ITEM_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u9884\u7b97\u9879\u76ee\u5bfc\u5165";
    }
}

