/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetDto;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/budget/costBudget"})
@Api(tags={"\u8d39\u7528\u9884\u7b97"})
public class CostBudgetController {
    private static final Logger log = LoggerFactory.getLogger(CostBudgetController.class);
    @Autowired
    private CostBudgetVoService costBudgetVoService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<CostBudgetVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="costBudget", value="\u8d39\u7528\u9884\u7b97") CostBudgetDto dto) {
        try {
            Page page = this.costBudgetVoService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<CostBudgetVo> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            CostBudgetVo costBudget = this.costBudgetVoService.findById(id);
            return Result.ok((Object)costBudget);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<CostBudgetVo> findByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u7f16\u7801") String code) {
        try {
            CostBudgetVo costBudget = this.costBudgetVoService.findByCode(code);
            return Result.ok((Object)costBudget);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<CostBudgetVo> create(@ApiParam(name="costBudget", value="\u8d39\u7528\u9884\u7b97") @RequestBody CostBudgetDto costBudget) {
        try {
            CostBudgetVo result = this.costBudgetVoService.create(costBudget);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<CostBudgetVo> update(@ApiParam(name="costBudget", value="\u8d39\u7528\u9884\u7b97") @RequestBody CostBudgetDto costBudget) {
        try {
            CostBudgetVo result = this.costBudgetVoService.update(costBudget);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u64cd\u4f5c")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.costBudgetVoService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7981\u7528")
    @PatchMapping(value={"updateEnableStatus"})
    public Result<?> updateEnableStatus(@RequestBody @ApiParam(name="ids", value="\u4e3b\u952eid") Set<String> ids, @RequestParam(value="enableStatus") @ApiParam(name="enableStatus", value="\u542f\u7981\u7528\u72b6\u6001") String enableStatus) {
        try {
            this.costBudgetVoService.updateEnableStatus(ids, enableStatus);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8c03\u6574\u64cd\u4f5c")
    @PatchMapping(value={"tranfer"})
    public Result<?> tranfer(@RequestParam(value="costBudgetCodeOut") @ApiParam(name="costBudgetCodeOut", value="\u8c03\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u7f16\u7801") String costBudgetCodeOut, @RequestParam(value="costBudgetCodeIn") @ApiParam(name="costBudgetCodeIn", value="\u8c03\u5165\u65b9\u8d39\u7528\u9884\u7b97\u7f16\u7801") String costBudgetCodeIn, @RequestParam(value="operateAmount") @ApiParam(name="operateAmount", value="\u64cd\u4f5c\u91d1\u989d") BigDecimal operateAmount, @RequestParam(name="operateRemark", required=false) @ApiParam(name="operateRemark", value="\u64cd\u4f5c\u5907\u6ce8") String operateRemark) {
        try {
            this.costBudgetVoService.tranfer(costBudgetCodeOut, costBudgetCodeIn, operateAmount, operateRemark);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d8\u66f4\u64cd\u4f5c")
    @PatchMapping(value={"change"})
    public Result<?> change(@RequestParam(value="costBudgetCode") @ApiParam(name="costBudgetCode", value="\u8d39\u7528\u9884\u7b97\u7f16\u7801") String costBudgetCode, @RequestParam(value="operateAmount") @ApiParam(name="operateAmount", value="\u64cd\u4f5c\u91d1\u989d") BigDecimal operateAmount, @RequestParam(name="operateRemark", required=false) @ApiParam(name="operateRemark", value="\u64cd\u4f5c\u5907\u6ce8") String operateRemark, @RequestParam(value="operateType") @ApiParam(name="operateType", value="\u64cd\u4f5c\u7c7b\u578b") String operateType) {
        try {
            this.costBudgetVoService.change(costBudgetCode, operateAmount, operateRemark, operateType);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5212\u62e8\u64cd\u4f5c")
    @PatchMapping(value={"wipe"})
    public Result<?> wipe(@RequestParam(value="costBudgetCode") @ApiParam(name="costBudgetCode", value="\u5212\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u7f16\u7801") String costBudgetCode, @RequestBody @ApiParam(name="costBudgetDtoIns", value="\u5212\u5165\u65b9\u4fe1\u606f") List<CostBudgetDto> costBudgetDtoIns) {
        try {
            this.costBudgetVoService.wipe(costBudgetCode, costBudgetDtoIns);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f7f\u7528")
    @PatchMapping(value={"occupy"})
    public Result<?> occupy(@RequestParam(value="businessCode") @ApiParam(name="businessCode", value="\u4e1a\u52a1\u7f16\u7801") String businessCode, @RequestParam(value="businessItemCode") @ApiParam(name="businessItemCode", value="\u4e1a\u52a1\u660e\u7ec6\u7f16\u7801") String businessItemCode, @RequestParam(value="costBudgetCode") @ApiParam(name="costBudgetCode", value="\u8d39\u7528\u9884\u7b97\u7f16\u7801") String costBudgetCode, @RequestParam(value="operateAmount") @ApiParam(name="operateAmount", value="\u64cd\u4f5c\u91d1\u989d") BigDecimal operateAmount, @RequestParam(name="itemRemark", required=false) @ApiParam(name="itemRemark", value="\u5907\u6ce8") String itemRemark, @RequestParam(name="source") @ApiParam(name="source", value="\u4e1a\u52a1\u6765\u6e90") String source) {
        try {
            this.costBudgetVoService.occupy(businessCode, businessItemCode, costBudgetCode, operateAmount, itemRemark, source);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u56de\u9000")
    @PatchMapping(value={"back"})
    public Result<?> back(@RequestParam(value="businessCode") @ApiParam(name="businessCode", value="\u4e1a\u52a1\u7f16\u7801") String businessCode, @RequestParam(value="businessItemCode") @ApiParam(name="businessItemCode", value="\u4e1a\u52a1\u660e\u7ec6\u7f16\u7801") String businessItemCode, @RequestParam(value="costBudgetCode") @ApiParam(name="costBudgetCode", value="\u8d39\u7528\u9884\u7b97\u7f16\u7801") String costBudgetCode, @RequestParam(value="operateAmount") @ApiParam(name="operateAmount", value="\u64cd\u4f5c\u91d1\u989d") BigDecimal operateAmount, @RequestParam(name="itemRemark", required=false) @ApiParam(name="itemRemark", value="\u5907\u6ce8") String itemRemark, @RequestParam(name="source") @ApiParam(name="source", value="\u4e1a\u52a1\u6765\u6e90") String source) {
        try {
            this.costBudgetVoService.back(businessCode, businessItemCode, costBudgetCode, operateAmount, itemRemark, source);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u53f7\u67e5\u8be2\u8d39\u7528\u9884\u7b97\u4e0e\u6d3b\u52a8\u5927\u7c7b\uff0c\u9884\u7b97\u79d1\u76ee\u7684\u5173\u7cfb")
    @GetMapping(value={"findRelationByCodes"})
    public Result<?> findRelationByCodes(@RequestParam(value="codes") @ApiParam(name="codes", value="\u8d39\u7528\u9884\u7b97\u7f16\u7801") Set<String> codes) {
        try {
            Set costBudgetRelationVos = this.costBudgetVoService.findRelationByCodes(codes);
            return Result.ok((Object)costBudgetRelationVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

