/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.notifier;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.event.DictDataEventListener;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.budget.local.service.CostTypeCategoryRangeService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetForDictDataEventListener
implements DictDataEventListener {
    @Autowired
    private CostTypeCategoryRangeService costTypeCategoryRangeService;

    public void onCreate(DictDataVo vo) {
    }

    public void onDelete(List<DictDataVo> vos) {
    }

    public void onEnable(List<DictDataVo> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        Set<String> Codes = vos.stream().map(DictDataVo::getDictCode).collect(Collectors.toSet());
        this.costTypeCategoryRangeService.updateEnableStatus(Codes, EnableStatusEnum.ENABLE.getCode());
    }

    public void onDisable(List<DictDataVo> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        Set<String> Codes = vos.stream().map(DictDataVo::getDictCode).collect(Collectors.toSet());
        this.costTypeCategoryRangeService.updateEnableStatus(Codes, EnableStatusEnum.DISABLE.getCode());
    }

    public void onChange(DictDataVo oldVo, DictDataVo newVo) {
    }
}

