/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.notifier;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.biz.crm.mdm.business.org.sdk.event.OrgEventListener;
import com.biz.crm.tpm.business.budget.local.service.CostTypeCategoryRangeService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetForOrgEventListener
implements OrgEventListener {
    @Autowired
    private CostTypeCategoryRangeService costTypeCategoryRangeService;

    public void onDeleteBatch(OrgEventBatchDto orgEventBatchDto) {
        if (orgEventBatchDto == null) {
            return;
        }
        List orgEventDtos = orgEventBatchDto.getOrgEventDtoList();
        if (CollectionUtils.isEmpty((Collection)orgEventDtos)) {
            return;
        }
        Set<String> orgCodes = orgEventDtos.stream().map(OrgEventDto::getOrgCode).collect(Collectors.toSet());
        this.costTypeCategoryRangeService.deleteByRangeCodes(orgCodes);
    }

    public void onEnableBatch(OrgEventBatchDto orgEventBatchDto) {
        if (orgEventBatchDto == null) {
            return;
        }
        List orgEventDtos = orgEventBatchDto.getOrgEventDtoList();
        if (CollectionUtils.isEmpty((Collection)orgEventDtos)) {
            return;
        }
        Set<String> orgCodes = orgEventDtos.stream().map(OrgEventDto::getOrgCode).collect(Collectors.toSet());
        this.costTypeCategoryRangeService.updateEnableStatus(orgCodes, EnableStatusEnum.ENABLE.getCode());
    }

    public void onDisableBatch(OrgEventBatchDto orgEventBatchDto) {
        if (orgEventBatchDto == null) {
            return;
        }
        List orgEventDtos = orgEventBatchDto.getOrgEventDtoList();
        if (CollectionUtils.isEmpty((Collection)orgEventDtos)) {
            return;
        }
        Set<String> orgCodes = orgEventDtos.stream().map(OrgEventDto::getOrgCode).collect(Collectors.toSet());
        this.costTypeCategoryRangeService.updateEnableStatus(orgCodes, EnableStatusEnum.DISABLE.getCode());
    }

    public void onUpdate(OrgEventDto orgEventDto) {
    }

    public void onDelete(List<String> orgCodes) {
    }
}

