/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.notifier;

import com.biz.crm.tpm.business.budget.local.entity.CostBudget;
import com.biz.crm.tpm.business.budget.local.repository.CostBudgetRepository;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetDto;
import com.biz.crm.tpm.business.budget.sdk.event.BudgetSubjectsEventListener;
import com.biz.crm.tpm.business.budget.sdk.vo.BudgetSubjectsVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CostBudgetForBudgetSubjectsEventListener
implements BudgetSubjectsEventListener {
    @Autowired
    private CostBudgetRepository costBudgetRepository;

    public void onCreated(BudgetSubjectsVo budgetSubjectsVo) {
    }

    public void onUpdate(BudgetSubjectsVo oldBudgetSubjectsVo, BudgetSubjectsVo budgetSubjectsVo) {
        if (!StringUtils.equals((CharSequence)oldBudgetSubjectsVo.getBudgetSubjectsName(), (CharSequence)budgetSubjectsVo.getBudgetSubjectsName())) {
            CostBudgetDto costBudgetDto = new CostBudgetDto();
            costBudgetDto.setTenantCode(budgetSubjectsVo.getTenantCode());
            costBudgetDto.setBudgetSubjectCode(budgetSubjectsVo.getBudgetSubjectsCode());
            List<CostBudget> costBudgets = this.costBudgetRepository.findByConditions(costBudgetDto);
            if (!CollectionUtils.isEmpty(costBudgets)) {
                costBudgets.forEach(e -> e.setBudgetSubjectName(budgetSubjectsVo.getBudgetSubjectsName()));
                this.costBudgetRepository.saveOrUpdateBatch(costBudgets);
            }
        }
    }

    public void onDeleted(BudgetSubjectsVo budgetSubjectsVo) {
        CostBudgetDto costBudgetDto = new CostBudgetDto();
        costBudgetDto.setTenantCode(budgetSubjectsVo.getTenantCode());
        costBudgetDto.setBudgetSubjectCode(budgetSubjectsVo.getBudgetSubjectsCode());
        List<CostBudget> costBudgets = this.costBudgetRepository.findByConditions(costBudgetDto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(costBudgets), (String)"\u9884\u7b97\u79d1\u76ee\u3010%s\u3011\u5df2\u6709\u8d39\u7528\u9884\u7b97\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{budgetSubjectsVo.getBudgetSubjectsCode()});
    }

    public void onEnable(BudgetSubjectsVo budgetSubjectsVo) {
    }

    public void onDisable(BudgetSubjectsVo budgetSubjectsVo) {
    }
}

