/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.local.entity.BudgetSubjects;
import com.biz.crm.tpm.business.budget.local.mapper.BudgetSubjectsMapper;
import com.biz.crm.tpm.business.budget.sdk.dto.BudgetSubjectsDto;
import com.biz.crm.tpm.business.budget.sdk.vo.BudgetSubjectsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetSubjectsRepository
extends ServiceImpl<BudgetSubjectsMapper, BudgetSubjects> {
    @Autowired
    private BudgetSubjectsMapper budgetSubjectsMapper;

    public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public Page<BudgetSubjectsVo> findByConditions(Pageable pageable, BudgetSubjectsDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.budgetSubjectsMapper.findByConditions((Page<BudgetSubjectsVo>)page, dto);
    }

    public List<BudgetSubjects> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public BudgetSubjects findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (BudgetSubjects)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetSubjects::getBudgetSubjectsCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<BudgetSubjects> findByEnableStatus(String enableStatus) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)enableStatus)) {
            return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        String tenantCode = TenantUtils.getTenantCode();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq((Object)"tenant_code", (Object)tenantCode);
        updateWrapper.in((Object)"id", idList);
        return this.update((Wrapper)updateWrapper);
    }

    public List<BudgetSubjects> findByCodesAndTenantCode(Set<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetSubjects::getBudgetSubjectsCode, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

