/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.budget.local.entity.CostBudgetItem;
import com.biz.crm.tpm.business.budget.local.mapper.CostBudgetItemMapper;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetItemDto;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetOperateType;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetItemVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class CostBudgetItemRepository
extends ServiceImpl<CostBudgetItemMapper, CostBudgetItem> {
    @Autowired
    private CostBudgetItemMapper costBudgetItemMapper;

    public Page<CostBudgetItemVo> findByConditions(Pageable pageable, CostBudgetItemDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        this.costBudgetItemMapper.findByConditions((Page<CostBudgetItemVo>)page, dto);
        if (page.getTotal() != 0L) {
            List list = page.getRecords();
        }
        return page;
    }

    public List<CostBudgetItem> findByCostBudgetCodeAndTenantCode(String code, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostBudgetItem::getCostBudgetCode, (Object)code)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public CostBudgetItem findById(String id) {
        return (CostBudgetItem)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).one());
    }

    public int countNoInitItemByCostBudgetCodeAndTenantCode(String code, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostBudgetItem::getCostBudgetCode, (Object)code)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).ne(CostBudgetItem::getOperateType, (Object)CostBudgetOperateType.INITIALIZATION.getCode())).count();
    }

    public List<CostBudgetItem> findByCostBudgetCodesAndTenantCode(List<String> costBudgetCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CostBudgetItem::getCostBudgetCode, costBudgetCodes)).orderByDesc(CostBudgetItem::getSortIndex)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public int countByCostBudgetCodeAndTenantCode(String costBudgetCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostBudgetItem::getCostBudgetCode, (Object)costBudgetCode)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).count();
    }

    public List<CostBudgetItem> findByBusinessCodeAndTenantCode(String businessCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostBudgetItem::getBusinessCode, (Object)businessCode)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).orderByDesc(CostBudgetItem::getSortIndex)).list();
    }

    public List<CostBudgetItem> findByBusinessCodeAndBusinessItemCodeAndTenantCode(String businessCode, String businessItemCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostBudgetItem::getBusinessCode, (Object)businessCode)).eq(CostBudgetItem::getBusinessItemCode, (Object)businessItemCode)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).orderByDesc(CostBudgetItem::getSortIndex)).list();
    }
}

