/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.local.entity.CostBudget;
import com.biz.crm.tpm.business.budget.local.mapper.CostBudgetMapper;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetDto;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CostBudgetRepository
extends ServiceImpl<CostBudgetMapper, CostBudget> {
    @Autowired
    private CostBudgetMapper costBudgetMapper;

    public Page<CostBudgetVo> findByConditions(Pageable pageable, CostBudgetDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.costBudgetMapper.findByConditions((Page<CostBudgetVo>)page, dto);
    }

    public CostBudget findByCodeAndTenantCode(String code, String tenantCode) {
        return (CostBudget)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostBudget::getCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<CostBudget> findByBudgetSubjectCodeAndTenantCode(String budgetSubjectCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostBudget::getBudgetSubjectCode, (Object)budgetSubjectCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<CostBudget> findByCodesAndTenantCode(Set<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CostBudget::getCode, codes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void updateEnableStatus(Set<String> ids, String enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).update();
    }

    public void deleteByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void deleteByOrgCodes(Set<String> orgCodes, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(CostBudget::getOrgCode, orgCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateByOrgNameAndOrgCodeAndTenantCode(String orgCode, String orgName, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(CostBudget::getOrgCode, (Object)orgCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(CostBudget::getOrgCode, (Object)orgName)).update();
    }

    public void disableByOrgCodesAndTenantCode(Set<String> orgCodes, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(CostBudget::getOrgCode, orgCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).update();
    }

    public List<CostBudget> findByConditions(CostBudgetDto dto) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)dto.getCode())) {
            lambdaQuery.eq(CostBudget::getCode, (Object)dto.getCode());
        }
        if (dto.getYear() != null) {
            lambdaQuery.eq(CostBudget::getYear, (Object)dto.getYear());
        }
        if (dto.getQuarter() != null) {
            lambdaQuery.eq(CostBudget::getQuarter, (Object)dto.getQuarter());
        }
        if (dto.getMonth() != null) {
            lambdaQuery.eq(CostBudget::getMonth, (Object)dto.getMonth());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getType())) {
            lambdaQuery.eq(CostBudget::getType, (Object)dto.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBudgetSubjectCode())) {
            lambdaQuery.eq(CostBudget::getBudgetSubjectCode, (Object)dto.getBudgetSubjectCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBudgetSubjectName())) {
            lambdaQuery.like(CostBudget::getBudgetSubjectName, (Object)dto.getBudgetSubjectName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEnableStatus())) {
            lambdaQuery.eq(UuidFlagOpEntity::getEnableStatus, (Object)dto.getEnableStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTenantCode())) {
            lambdaQuery.eq(TenantFlagOpEntity::getTenantCode, (Object)dto.getTenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgCode())) {
            lambdaQuery.eq(CostBudget::getOrgCode, (Object)dto.getOrgCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            lambdaQuery.like(CostBudget::getOrgName, (Object)dto.getOrgName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
            lambdaQuery.eq(CostBudget::getCustomerCode, (Object)dto.getCustomerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerName())) {
            lambdaQuery.like(CostBudget::getCustomerName, (Object)dto.getCustomerName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getChannelCode())) {
            lambdaQuery.eq(CostBudget::getChannelCode, (Object)dto.getChannelCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getChannelName())) {
            lambdaQuery.like(CostBudget::getChannelName, (Object)dto.getChannelName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductCode())) {
            lambdaQuery.eq(CostBudget::getProductCode, (Object)dto.getProductCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductName())) {
            lambdaQuery.like(CostBudget::getProductName, (Object)dto.getProductName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalCode())) {
            lambdaQuery.eq(CostBudget::getTerminalCode, (Object)dto.getTerminalCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminalName())) {
            lambdaQuery.like(CostBudget::getTerminalName, (Object)dto.getTerminalName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductLevelCode())) {
            lambdaQuery.eq(CostBudget::getProductLevelCode, (Object)dto.getProductLevelCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getProductLevelName())) {
            lambdaQuery.like(CostBudget::getProductLevelName, (Object)dto.getProductLevelName());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getOrgCodes())) {
            lambdaQuery.in(CostBudget::getOrgCode, (Collection)dto.getOrgCodes());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getExcludeCodes())) {
            lambdaQuery.notIn(CostBudget::getCode, (Collection)dto.getExcludeCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEnableStatus())) {
            lambdaQuery.eq(UuidFlagOpEntity::getEnableStatus, (Object)dto.getEnableStatus());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            lambdaQuery.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        } else {
            lambdaQuery.eq(UuidFlagOpEntity::getDelFlag, (Object)dto.getDelFlag());
        }
        return ((CostBudgetMapper)this.baseMapper).selectList((Wrapper)lambdaQuery);
    }
}

