/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.local.entity.CostTypeCategoryRange;
import com.biz.crm.tpm.business.budget.local.mapper.CostTypeCategoryRangeMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CostTypeCategoryRangeRepository
extends ServiceImpl<CostTypeCategoryRangeMapper, CostTypeCategoryRange> {
    @Autowired
    private CostTypeCategoryRangeMapper costTypeCategoryRangeMapper;

    public List<CostTypeCategoryRange> findByCategoryCode(String categoryCode) {
        if (StringUtils.isBlank((CharSequence)categoryCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CostTypeCategoryRange::getCategoryCode, (Object)categoryCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(CostTypeCategoryRange::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<CostTypeCategoryRange> findByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CostTypeCategoryRange::getRangeCode, codes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public void deleteByCategoryCode(String categoryCode) {
        if (StringUtils.isBlank((CharSequence)categoryCode)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(CostTypeCategoryRange::getCategoryCode, (Object)categoryCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public void deleteByRangeCodes(Collection<String> rangeCodes) {
        if (CollectionUtils.isEmpty(rangeCodes)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in((Object)"range_code", rangeCodes);
        updateWrapper.eq((Object)"tenant_code", (Object)tenantCode);
        this.update((Wrapper)updateWrapper);
    }

    public void updateEnableStatusByCodes(EnableStatusEnum enable, Set<String> codes) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"range_code", codes);
        this.update((Wrapper)updateWrapper);
    }

    public void updateName(String code, String name) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"range_name", (Object)code);
        updateWrapper.eq((Object)"range_code", (Object)name);
        this.update((Wrapper)updateWrapper);
    }

    public List<CostTypeCategoryRange> findAll() {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }
}

