/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.local.entity.StrategySettingManage;
import com.biz.crm.tpm.business.budget.local.mapper.StrategySettingManageMapper;
import com.biz.crm.tpm.business.budget.sdk.dto.StrategySettingManageDto;
import com.biz.crm.tpm.business.budget.sdk.vo.StrategySettingManageVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class StrategySettingManageRepository
extends ServiceImpl<StrategySettingManageMapper, StrategySettingManage> {
    @Autowired
    private StrategySettingManageMapper strategySettingManageMapper;

    public Page<StrategySettingManageVo> findByConditions(Pageable pageable, StrategySettingManageDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.strategySettingManageMapper.findByConditions((Page<StrategySettingManageVo>)page, dto);
    }

    public StrategySettingManage findByCodeAndTenantCode(String code, String tenantCode) {
        return (StrategySettingManage)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StrategySettingManage::getCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public StrategySettingManage findEnabled() {
        return (StrategySettingManage)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).one());
    }

    public List<StrategySettingManage> findByIds(Set<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public boolean existByName(String name) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(StrategySettingManage::getName, (Object)name)).count() != 0;
    }

    public StrategySettingManage findByName(String name) {
        return (StrategySettingManage)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StrategySettingManage::getName, (Object)name)).one());
    }
}

